/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForeachStatement
extends Statement {
    public LocalDeclaration elementVariable;
    public int elementVariableImplicitWidening = -1;
    public Expression collection;
    public Statement action;
    private int kind;
    private static final int ARRAY = 0;
    private static final int RAW_ITERABLE = 1;
    private static final int GENERIC_ITERABLE = 2;
    private TypeBinding iteratorReceiverType;
    private TypeBinding collectionElementType;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    public BlockScope scope;
    public LocalVariableBinding indexVariable;
    public LocalVariableBinding collectionVariable;
    public LocalVariableBinding maxVariable;
    private static final char[] SecretIndexVariableName = " index".toCharArray();
    private static final char[] SecretCollectionVariableName = " collection".toCharArray();
    private static final char[] SecretMaxVariableName = " max".toCharArray();
    int postCollectionInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForeachStatement(LocalDeclaration elementVariable, int start) {
        this.elementVariable = elementVariable;
        this.sourceStart = start;
        this.kind = -1;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo exitBranch;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        this.collection.checkNPE(currentScope, flowContext, flowInfo, true);
        flowInfo = this.elementVariable.analyseCode(this.scope, flowContext, flowInfo);
        FlowInfo condInfo = this.collection.analyseCode(this.scope, flowContext, flowInfo.copy());
        condInfo.markAsDefinitelyAssigned(this.elementVariable.binding);
        this.postCollectionInitStateIndex = currentScope.methodScope().recordInitializationStates(condInfo);
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope);
        UnconditionalFlowInfo actionInfo = condInfo.nullInfoLessUnconditionalCopy();
        if (!(this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L)) {
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo).unconditionalCopy();
            }
            exitBranch = flowInfo.unconditionalCopy().addInitializationsFrom(condInfo.initsWhenFalse());
            if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            } else {
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue);
                loopingContext.complainOnDeferredFinalChecks(this.scope, actionInfo);
                exitBranch.addPotentialInitializationsFrom(actionInfo);
            }
        } else {
            exitBranch = condInfo.initsWhenFalse();
        }
        if (this.action != null && !this.action.isEmptyBlock() && (this.action.bits & 1) == 0) {
            switch (this.kind) {
                case 0: {
                    this.collectionVariable.useFlag = 1;
                    this.indexVariable.useFlag = 1;
                    this.maxVariable.useFlag = 1;
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable.useFlag = 1;
                }
            }
        }
        loopingContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(loopingContext.initsOnBreak, false, exitBranch, false, true);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.action == null || this.action.isEmptyBlock() || (this.action.bits & 1) != 0) {
            codeStream.exitUserScope(this.scope);
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        switch (this.kind) {
            case 0: {
                this.collection.generateCode(this.scope, codeStream, true);
                codeStream.store(this.collectionVariable, false);
                codeStream.iconst_0();
                codeStream.store(this.indexVariable, false);
                codeStream.load(this.collectionVariable);
                codeStream.arraylength();
                codeStream.store(this.maxVariable, false);
                break;
            }
            case 1: 
            case 2: {
                this.collection.generateCode(this.scope, codeStream, true);
                MethodBinding iteratorMethodBinding = new MethodBinding(1, "iterator".toCharArray(), this.scope.getJavaUtilIterator(), Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, (ReferenceBinding)this.iteratorReceiverType.erasure());
                if (this.iteratorReceiverType.isInterface()) {
                    codeStream.invokeinterface(iteratorMethodBinding);
                } else {
                    codeStream.invokevirtual(iteratorMethodBinding);
                }
                codeStream.store(this.indexVariable, false);
            }
        }
        BranchLabel actionLabel = new BranchLabel(codeStream);
        actionLabel.tagBits |= 2;
        BranchLabel conditionLabel = new BranchLabel(codeStream);
        conditionLabel.tagBits |= 2;
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
            this.continueLabel.tagBits |= 2;
        }
        codeStream.goto_(conditionLabel);
        actionLabel.place();
        if (this.elementVariable.binding.resolvedPosition != -1) {
            switch (this.kind) {
                case 0: {
                    codeStream.load(this.collectionVariable);
                    codeStream.load(this.indexVariable);
                    codeStream.arrayAt(this.collectionElementType.id);
                    if (this.elementVariableImplicitWidening != -1) {
                        codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                    }
                    codeStream.store(this.elementVariable.binding, false);
                    break;
                }
                case 1: 
                case 2: {
                    codeStream.load(this.indexVariable);
                    codeStream.invokeJavaUtilIteratorNext();
                    if (this.elementVariable.binding.type.id != 1) {
                        if (this.elementVariableImplicitWidening != -1) {
                            codeStream.checkcast(this.collectionElementType);
                            codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                        } else {
                            codeStream.checkcast(this.elementVariable.binding.type);
                        }
                    }
                    codeStream.store(this.elementVariable.binding, false);
                }
            }
            codeStream.addVisibleLocalVariable(this.elementVariable.binding);
            if (this.postCollectionInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.postCollectionInitStateIndex);
            }
        } else {
            switch (this.kind) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    codeStream.load(this.indexVariable);
                    codeStream.invokeJavaUtilIteratorNext();
                    codeStream.pop();
                }
            }
        }
        this.action.generateCode(this.scope, codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.place();
            int continuationPC = codeStream.position;
            switch (this.kind) {
                case 0: {
                    codeStream.iinc(this.indexVariable.resolvedPosition, 1);
                    break;
                }
            }
            codeStream.recordPositionsFrom(continuationPC, this.elementVariable.sourceStart);
        }
        if (this.postCollectionInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.postCollectionInitStateIndex);
        }
        conditionLabel.place();
        int conditionPC = codeStream.position;
        switch (this.kind) {
            case 0: {
                codeStream.load(this.indexVariable);
                codeStream.load(this.maxVariable);
                codeStream.if_icmplt(actionLabel);
                break;
            }
            case 1: 
            case 2: {
                codeStream.load(this.indexVariable);
                codeStream.invokeJavaUtilIteratorHasNext();
                codeStream.ifne(actionLabel);
            }
        }
        codeStream.recordPositionsFrom(conditionPC, this.elementVariable.sourceStart);
        codeStream.exitUserScope(this.scope);
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        this.breakLabel.place();
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ForeachStatement.printIndent(indent, output).append("for (");
        this.elementVariable.printAsExpression(0, output);
        output.append(" : ");
        this.collection.print(0, output).append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(indent + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        TypeBinding collectionType;
        this.scope = new BlockScope(upperScope);
        this.elementVariable.resolve(this.scope);
        TypeBinding elementType = this.elementVariable.type.resolvedType;
        TypeBinding typeBinding = collectionType = this.collection == null ? null : this.collection.resolveType(this.scope);
        if (elementType != null && collectionType != null) {
            block32: {
                ReferenceBinding iterableType;
                if (collectionType.isArrayType()) {
                    this.kind = 0;
                    this.collection.computeConversion(this.scope, collectionType, collectionType);
                    this.collectionElementType = ((ArrayBinding)collectionType).elementsType();
                    if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                        this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                    }
                    int compileTimeTypeID = this.collectionElementType.id;
                    if (elementType.isBaseType()) {
                        if (!this.collectionElementType.isBaseType()) {
                            compileTimeTypeID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 1024;
                            if (elementType.isBaseType()) {
                                this.elementVariableImplicitWidening |= (elementType.id << 4) + compileTimeTypeID;
                                this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, elementType);
                            }
                        } else {
                            this.elementVariableImplicitWidening = (elementType.id << 4) + compileTimeTypeID;
                        }
                    } else if (this.collectionElementType.isBaseType()) {
                        int boxedID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                        this.elementVariableImplicitWidening = 0x200 | compileTimeTypeID << 4 | compileTimeTypeID;
                        compileTimeTypeID = boxedID;
                        this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, elementType);
                    }
                } else if (collectionType instanceof ReferenceBinding && (iterableType = ((ReferenceBinding)collectionType).findSuperTypeErasingTo(38, false)) != null) {
                    this.iteratorReceiverType = collectionType.erasure();
                    if (((ReferenceBinding)this.iteratorReceiverType).findSuperTypeErasingTo(38, false) == null) {
                        this.iteratorReceiverType = iterableType;
                        this.collection.computeConversion(this.scope, iterableType, collectionType);
                    } else {
                        this.collection.computeConversion(this.scope, collectionType, collectionType);
                    }
                    TypeBinding[] arguments = null;
                    switch (iterableType.kind()) {
                        case 1028: {
                            this.kind = 1;
                            this.collectionElementType = this.scope.getJavaLangObject();
                            if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                                this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                            }
                            break block32;
                        }
                        case 2052: {
                            arguments = iterableType.typeVariables();
                            break;
                        }
                        case 260: {
                            arguments = ((ParameterizedTypeBinding)iterableType).arguments;
                            break;
                        }
                        default: {
                            break block32;
                        }
                    }
                    if (arguments.length == 1) {
                        this.kind = 2;
                        this.collectionElementType = arguments[0];
                        if (!this.collectionElementType.isCompatibleWith(elementType) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, elementType)) {
                            this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, elementType);
                        }
                        int compileTimeTypeID = this.collectionElementType.id;
                        if (elementType.isBaseType()) {
                            if (!this.collectionElementType.isBaseType()) {
                                compileTimeTypeID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                                this.elementVariableImplicitWidening = 1024;
                                if (elementType.isBaseType()) {
                                    this.elementVariableImplicitWidening |= (elementType.id << 4) + compileTimeTypeID;
                                }
                            } else {
                                this.elementVariableImplicitWidening = (elementType.id << 4) + compileTimeTypeID;
                            }
                        } else if (this.collectionElementType.isBaseType()) {
                            int boxedID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 0x200 | compileTimeTypeID << 4 | compileTimeTypeID;
                            compileTimeTypeID = boxedID;
                        }
                    }
                }
            }
            switch (this.kind) {
                case 0: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)TypeBinding.INT, 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(Constant.NotAConstant);
                    this.maxVariable = new LocalVariableBinding(SecretMaxVariableName, (TypeBinding)TypeBinding.INT, 0, false);
                    this.scope.addLocalVariable(this.maxVariable);
                    this.maxVariable.setConstant(Constant.NotAConstant);
                    this.collectionVariable = new LocalVariableBinding(SecretCollectionVariableName, collectionType, 0, false);
                    this.scope.addLocalVariable(this.collectionVariable);
                    this.collectionVariable.setConstant(Constant.NotAConstant);
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)this.scope.getJavaUtilIterator(), 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(Constant.NotAConstant);
                    break;
                }
                default: {
                    this.scope.problemReporter().invalidTypeForCollection(this.collection);
                }
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.elementVariable.traverse(visitor, this.scope);
            this.collection.traverse(visitor, this.scope);
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

