/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class HelpUIResources {
    public static URL getImagePath(String name) {
        IPath path = new Path("$nl$/icons/").append(name);
        return Platform.find((Bundle)HelpUIPlugin.getDefault().getBundle(), (IPath)path);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        URL imagePath = HelpUIResources.getImagePath(name);
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(name);
        if (desc == null) {
            desc = ImageDescriptor.createFromURL((URL)imagePath);
            registry.put(name, desc);
        }
        return desc;
    }

    public static ImageDescriptor getImageDescriptor(String bundleId, String name) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(name);
        if (desc == null) {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            URL url = Platform.find((Bundle)bundle, (IPath)new Path(name));
            desc = ImageDescriptor.createFromURL((URL)url);
            registry.put(name, desc);
        }
        return desc;
    }

    public static Image getImage(String name) {
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        HelpUIResources.getImageDescriptor(name);
        return registry.get(name);
    }

    public static Image getImage(URL url) {
        String name;
        ImageRegistry registry = HelpUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = registry.getDescriptor(name = url.toString());
        if (desc == null) {
            desc = ImageDescriptor.createFromURL((URL)url);
            registry.put(name, desc);
        }
        return registry.get(name);
    }
}

