/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREsComboBlock;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JavaJRETab
extends JavaLaunchTab {
    protected JREsComboBlock fJREBlock;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    protected boolean fUseDynamicArea = true;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ILaunchConfiguration fLaunchConfiguration;
    protected boolean fIsInitializing = false;
    private IPropertyChangeListener fCheckListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            JavaJRETab.this.handleSelectedJREChanged();
        }
    };
    protected static final String EMPTY_STRING = "";

    public void dispose() {
        super.dispose();
        if (this.fJREBlock != null) {
            this.fJREBlock.removePropertyChangeListener(this.fCheckListener);
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topComp = new Composite(parent, 0);
        this.setControl((Control)topComp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_JRE_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        topComp.setLayoutData((Object)gd);
        topComp.setFont(font);
        this.fJREBlock = new JREsComboBlock();
        this.fJREBlock.setDefaultJREDescriptor(this.getDefaultJREDescriptor());
        this.fJREBlock.setSpecificJREDescriptor(this.getSpecificJREDescriptor());
        this.fJREBlock.createControl(topComp);
        Control control = this.fJREBlock.getControl();
        this.fJREBlock.addPropertyChangeListener(this.fCheckListener);
        gd = new GridData(768);
        control.setLayoutData((Object)gd);
        Composite dynTabComp = new Composite(topComp, 0);
        dynTabComp.setFont(font);
        this.setDynamicTabHolder(dynTabComp);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fIsInitializing = true;
        this.getControl().setRedraw(false);
        this.setLaunchConfiguration(configuration);
        this.updateJREFromConfig(configuration);
        this.fJREBlock.setDefaultJREDescriptor(this.getDefaultJREDescriptor());
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(configuration);
        }
        this.getControl().setRedraw(true);
        this.fIsInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fJREBlock.isDefaultJRE()) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        } else {
            IPath containerPath = this.fJREBlock.getPath();
            String portablePath = null;
            if (containerPath != null) {
                portablePath = containerPath.toPortableString();
            }
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, portablePath);
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab == null) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
        } else {
            dynamicTab.performApply(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IStatus status = this.fJREBlock.getStatus();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.JavaJRETab__JRE_1;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    protected void updateJREFromConfig(ILaunchConfiguration config) {
        try {
            String path = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            if (path != null) {
                this.fJREBlock.setPath(Path.fromPortableString((String)path));
                return;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        String vmName = null;
        String vmTypeID = null;
        try {
            vmTypeID = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            vmName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.selectJRE(vmTypeID, vmName);
    }

    protected void handleSelectedJREChanged() {
        this.loadDynamicJREArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (!this.fIsInitializing && wc != null) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            }
        } else {
            if (wc == null) {
                try {
                    wc = this.getLaunchConfiguration().isWorkingCopy() ? ((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration()).getOriginal().getWorkingCopy() : this.getLaunchConfiguration().getWorkingCopy();
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.errorDialog(LauncherMessages.JavaJRETab_Unable_to_initialize_defaults_for_selected_JRE_1, e);
                    return;
                }
            }
            if (!this.fIsInitializing) {
                this.getDynamicTab().setDefaults(wc);
                this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void selectJRE(String typeID, String vmName) {
        if (typeID == null) {
            this.fJREBlock.setUseDefaultJRE();
        } else {
            this.fJREBlock.setPath(JavaRuntime.newJREContainerPath((String)typeID, (String)vmName));
        }
    }

    protected ILaunchConfigurationTab getTabForCurrentJRE() {
        IVMInstall vm;
        IPath path;
        if (!this.fJREBlock.isDefaultJRE() && (path = this.fJREBlock.getPath()) != null && JavaRuntime.getExecutionEnvironmentId((IPath)path) == null && (vm = this.fJREBlock.getJRE()) != null) {
            String vmInstallTypeID = vm.getVMInstallType().getId();
            return JDIDebugUIPlugin.getDefault().getVMInstallTypePage(vmInstallTypeID);
        }
        return null;
    }

    protected void loadDynamicJREArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        if (this.isUseDynamicJREArea()) {
            this.setDynamicTab(this.getTabForCurrentJRE());
            if (this.getDynamicTab() == null) {
                return;
            }
            this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            this.getDynamicTab().createControl(this.getDynamicTabHolder());
            this.getDynamicTabHolder().layout();
        }
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
    }

    public void setVMSpecificArgumentsVisible(boolean visible) {
        this.fUseDynamicArea = visible;
    }

    protected boolean isUseDynamicJREArea() {
        return this.fUseDynamicArea;
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                IJavaProject project = JavaJRETab.this.getJavaProject();
                String name = LauncherMessages.JavaJRETab_7;
                if (project == null) {
                    IVMInstall vm = JavaRuntime.getDefaultVMInstall();
                    if (vm != null) {
                        name = vm.getName();
                    }
                    return MessageFormat.format(LauncherMessages.JavaJRETab_8, name);
                }
                try {
                    IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)project);
                    if (vm != null) {
                        name = vm.getName();
                    }
                }
                catch (CoreException coreException) {}
                return MessageFormat.format(LauncherMessages.JavaJRETab_9, name);
            }
        };
    }

    protected JREDescriptor getSpecificJREDescriptor() {
        return null;
    }

    protected IJavaProject getJavaProject() {
        if (this.getLaunchConfiguration() != null) {
            try {
                IProject project;
                String name = this.getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (name != null && name.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)).exists()) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fJREBlock.refresh();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

