/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.ClassPrepareBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.ExceptionBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.LineBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.MethodBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointTypeChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public abstract class BreakpointRenameParticipant
extends RenameParticipant {
    private IJavaElement fElement;

    protected boolean initialize(Object element) {
        if (!(element instanceof IJavaElement) || !this.accepts((IJavaElement)element)) {
            return false;
        }
        this.fElement = (IJavaElement)element;
        return true;
    }

    protected IJavaElement getOriginalElement() {
        return this.fElement;
    }

    protected abstract boolean accepts(IJavaElement var1);

    public String getName() {
        return RefactoringMessages.BreakpointRenameParticipant_0;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList changes = new ArrayList();
        IResource resource = this.getBreakpointContainer();
        IMarker[] markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        this.gatherChanges(markers, changes, this.getArguments().getNewName());
        if (changes.size() > 1) {
            return new CompositeChange(RefactoringMessages.BreakpointRenameParticipant_1, changes.toArray(new Change[changes.size()]));
        }
        if (changes.size() == 1) {
            return (Change)changes.get(0);
        }
        return null;
    }

    protected abstract void gatherChanges(IMarker[] var1, List var2, String var3) throws CoreException, OperationCanceledException;

    protected IResource getBreakpointContainer() {
        return this.fElement.getResource();
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected Change createTypeChange(IJavaBreakpoint breakpoint, IType destType, IType originalType) throws CoreException {
        if (breakpoint instanceof IJavaWatchpoint) {
            return new WatchpointTypeChange((IJavaWatchpoint)breakpoint, destType, originalType);
        }
        if (breakpoint instanceof IJavaClassPrepareBreakpoint) {
            return new ClassPrepareBreakpointTypeChange((IJavaClassPrepareBreakpoint)breakpoint, destType, originalType);
        }
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            return new MethodBreakpointTypeChange((IJavaMethodBreakpoint)breakpoint, destType, originalType);
        }
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            return new ExceptionBreakpointTypeChange((IJavaExceptionBreakpoint)breakpoint, destType, originalType);
        }
        if (breakpoint instanceof IJavaLineBreakpoint) {
            return new LineBreakpointTypeChange((IJavaLineBreakpoint)breakpoint, destType, originalType);
        }
        return null;
    }

    protected boolean isContained(IJavaElement container, IType type) {
        IType parent = type;
        while (parent != null) {
            if (parent.equals(container)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

