/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.AddVMDialog;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryContentProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryLabelProvider;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VMLibraryBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected IVMInstall fVmInstall;
    protected IVMInstallType fVmInstallType;
    protected File fHome;
    protected TreeViewer fLibraryViewer;
    protected LibraryContentProvider fLibraryContentProvider;
    protected Button fDefaultButton;
    protected AddVMDialog fDialog = null;
    protected boolean fInCallback = false;
    protected static final String DIALOG_SETTINGS_PREFIX = "VMLibraryBlock";
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    private Button fEditButton;

    public VMLibraryBlock(AddVMDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fLibraryViewer = new TreeViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = new LibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_7);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fEditButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_8);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fLibraryViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (VMLibraryBlock.this.fEditButton.isEnabled()) {
                    VMLibraryBlock.this.edit((IStructuredSelection)VMLibraryBlock.this.fLibraryViewer.getSelection());
                }
            }
        });
        this.fRemoveButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_4);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_5);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        this.fDefaultButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_9);
        this.fDefaultButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    public void restoreDefaultLibraries() {
        LibraryLocation[] libs = null;
        File installLocation = this.getHomeDirectory();
        libs = installLocation == null ? new LibraryLocation[]{} : this.getVMInstallType().getDefaultLibraryLocations(installLocation);
        this.fLibraryContentProvider.setLibraries(libs);
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.fDialog.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void initializeFrom(IVMInstall vm, IVMInstallType type) {
        this.setVMInstall(vm);
        this.setVMInstallType(type);
        if (vm != null) {
            this.setHomeDirectory(vm.getInstallLocation());
            this.fLibraryContentProvider.setLibraries(JavaRuntime.getLibraryLocations((IVMInstall)this.getVMInstall()));
        }
        this.update();
    }

    public void setHomeDirectory(File file) {
        this.fHome = file;
    }

    protected File getHomeDirectory() {
        return this.fHome;
    }

    public void update() {
        this.updateButtons();
        StatusInfo status = new StatusInfo();
        if (this.fLibraryContentProvider.getLibraries().length == 0) {
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, JREMessages.VMLibraryBlock_Libraries_cannot_be_empty__1, null);
        }
        this.fDialog.setSystemLibraryStatus((IStatus)status);
        this.fDialog.updateStatusLine();
    }

    public void performApply(IVMInstall vm) {
        if (this.isDefaultLocations()) {
            vm.setLibraryLocations(null);
        } else {
            LibraryLocation[] libs = this.fLibraryContentProvider.getLibraries();
            vm.setLibraryLocations(libs);
        }
    }

    protected boolean isDefaultLocations() {
        LibraryLocation[] def;
        LibraryLocation[] libraryLocations = this.fLibraryContentProvider.getLibraries();
        IVMInstall install = this.getVMInstall();
        if (install == null || libraryLocations == null) {
            return true;
        }
        File installLocation = install.getInstallLocation();
        if (installLocation != null && (def = this.getVMInstallType().getDefaultLibraryLocations(installLocation)).length == libraryLocations.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)libraryLocations[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void setVMInstall(IVMInstall vm) {
        this.fVmInstall = vm;
    }

    protected IVMInstall getVMInstall() {
        return this.fVmInstall;
    }

    private void setVMInstallType(IVMInstallType type) {
        this.fVmInstallType = type;
    }

    protected IVMInstallType getVMInstallType() {
        return this.fVmInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fEditButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDefaultButton) {
            this.restoreDefaultLibraries();
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        IDialogSettings dialogSettings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.fLibraryViewer.getControl().getShell(), 2);
        dialog.setText(JREMessages.VMLibraryBlock_10);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        LibraryLocation[] libs = new LibraryLocation[nChosen];
        int i = 0;
        while (i < nChosen) {
            libs[i] = new LibraryLocation(filterPath.append(fileNames[i]).makeAbsolute(), (IPath)Path.EMPTY, (IPath)Path.EMPTY);
            ++i;
        }
        dialogSettings.put(LAST_PATH_SETTING, filterPath.toOSString());
        this.fLibraryContentProvider.add(libs, selection);
    }

    private void edit(IStructuredSelection selection) {
        LibraryContentProvider.SubElement firstElement = (LibraryContentProvider.SubElement)selection.getFirstElement();
        LibraryLocation library = firstElement.getParent();
        if (firstElement.getType() == 1) {
            URL[] urls = BuildPathDialogAccess.configureJavadocLocation((Shell)this.fLibraryViewer.getControl().getShell(), (String)library.getSystemLibraryPath().toOSString(), (URL)library.getJavadocLocation());
            if (urls != null) {
                this.fLibraryContentProvider.setJavadoc(urls[0], selection);
            }
        } else {
            IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)library.getSystemLibraryPath());
            entry.setSourceAttachmentPath(library.getSystemLibrarySourcePath());
            entry.setSourceAttachmentRootPath(library.getPackageRootPath());
            IClasspathEntry classpathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)this.fLibraryViewer.getControl().getShell(), (IClasspathEntry)entry.getClasspathEntry());
            if (classpathEntry != null) {
                this.fLibraryContentProvider.setSourcePath(classpathEntry.getSourceAttachmentPath(), classpathEntry.getSourceAttachmentRootPath(), selection);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        this.fAddButton.setEnabled(true);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        boolean enableUp = true;
        boolean enableDown = true;
        boolean allSource = true;
        boolean allJavadoc = true;
        LibraryLocation[] libraries = this.fLibraryContentProvider.getLibraries();
        if (selection.isEmpty() || libraries.length == 0) {
            enableDown = false;
            enableUp = false;
        } else {
            LibraryLocation first = libraries[0];
            LibraryLocation last = libraries[libraries.length - 1];
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                LibraryLocation lib;
                Object element = iter.next();
                if (element instanceof LibraryLocation) {
                    lib = (LibraryLocation)element;
                    allJavadoc = false;
                    allSource = false;
                } else {
                    LibraryContentProvider.SubElement subElement = (LibraryContentProvider.SubElement)element;
                    lib = subElement.getParent();
                    if (subElement.getType() == 1) {
                        allSource = false;
                    } else {
                        allJavadoc = false;
                    }
                }
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
        this.fEditButton.setEnabled(!selection.isEmpty() && (allSource || allJavadoc));
    }
}

