/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources.internal.workbench;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.navigator.AdaptabilityUtility;
import org.eclipse.ui.internal.navigator.dnd.IDropValidator;
import org.eclipse.ui.internal.navigator.dnd.NavigatorDropActionDelegate;
import org.eclipse.ui.navigator.ICommonDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class ResourceDropAction
extends NavigatorDropActionDelegate
implements IDropValidator,
IOverwriteQuery {
    private boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    protected static final Class IRESOURCE_CLASS;
    private CopyFilesAndFoldersOperation copyOperation;
    private CopyFilesAndFoldersOperation moveOperation;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRESOURCE_CLASS = clazz;
    }

    private IStatus error(String message) {
        return this.error(message, null);
    }

    private IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.ui", 0, message, exception);
    }

    private IContainer getActualTarget(ICommonDropAdapter dropAdapter, IResource mouseTarget) {
        if (dropAdapter.getFeedbackEnabled() && (dropAdapter.getCurrentLocation() == 1 || dropAdapter.getCurrentLocation() == 2)) {
            return mouseTarget.getParent();
        }
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    private IResource[] getSelectedResources() {
        IResource[] selectedResources = null;
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectionList = ((IStructuredSelection)selection).toList();
            selectedResources = selectionList.toArray(new IResource[selectionList.size()]);
        }
        return selectedResources;
    }

    private IStatus info(String message) {
        return new Status(1, "org.eclipse.ui", 0, message, null);
    }

    private void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    private IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, ResourceNavigatorMessages.getString((String)"DropAdapter.ok"), null);
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = ResourceNavigatorMessages.getString((String)"DropAdapter.title");
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }

    private IStatus performFileDrop(ICommonDropAdapter dropAdapter, Object data) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, ResourceNavigatorMessages.getString((String)"DropAdapter.problemImporting"), null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter, dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer()));
        try {
            final IContainer target = this.getActualTarget(dropAdapter, this.getResource(dropAdapter.getCurrentTarget()));
            final String[] names = (String[])data;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ResourceDropAction.this.getShell().forceActive();
                    CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(ResourceDropAction.this.getShell());
                    operation.copyFiles(names, target);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return problems;
    }

    private IStatus performResourceCopy(ICommonDropAdapter dropAdapter, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.getString((String)"DropAdapter.problemsMoving"), null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter, dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer()));
        IContainer target = this.getActualTarget(dropAdapter, this.getResource(dropAdapter.getCurrentTarget()));
        this.getCopyOperation().copyResources(sources, target);
        this.copyOperation = null;
        return problems;
    }

    private IStatus performResourceMove(ICommonDropAdapter dropAdapter, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.getString((String)"DropAdapter.problemsMoving"), null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter, dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer()));
        IContainer target = this.getActualTarget(dropAdapter, this.getResource(dropAdapter.getCurrentTarget()));
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), ResourceNavigatorMessages.getString((String)"MoveResourceAction.title"), ResourceNavigatorMessages.getString((String)"MoveResourceAction.checkMoveMessage"));
        sources = checker.checkReadOnlyResources(sources);
        this.getMoveOperation().copyResources(sources, target);
        this.moveOperation = null;
        return problems;
    }

    public String queryOverwrite(String pathString) {
        if (this.alwaysOverwrite) {
            return "ALL";
        }
        final String[] returnCode = new String[]{"CANCEL"};
        final String msg = ResourceNavigatorMessages.format((String)"DropAdapter.overwriteQuery", (Object[])new Object[]{pathString});
        final String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(ResourceDropAction.this.getShell(), ResourceNavigatorMessages.getString((String)"DropAdapter.question"), null, msg, 3, options, 0);
                dialog.open();
                int returnVal = dialog.getReturnCode();
                String[] returnCodes = new String[]{"YES", "ALL", "NO", "CANCEL"};
                returnCode[0] = returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
            }
        });
        if (returnCode[0] == "ALL") {
            this.alwaysOverwrite = true;
        }
        return returnCode[0];
    }

    public boolean validateDrop(ICommonDropAdapter dropAdapter, Object target, int operation, TransferData transferType) {
        return this.validateTarget(dropAdapter, target, transferType).isOK();
    }

    public boolean run(ICommonDropAdapter dropAdapter, Object data, Object target) {
        this.alwaysOverwrite = false;
        if (dropAdapter.getCurrentTarget() == null || data == null) {
            return false;
        }
        boolean result = false;
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = dropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])data;
        } else if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(dropAdapter, data);
            result = status.isOK();
        }
        if (resources != null) {
            status = dropAdapter.getCurrentOperation() == 1 ? this.performResourceCopy(dropAdapter, resources) : this.performResourceMove(dropAdapter, resources);
        }
        this.openError(status);
        return result;
    }

    private IStatus validateTarget(ICommonDropAdapter dropAdapter, Object target, TransferData transferType) {
        if (!(target instanceof IResource)) {
            return this.info(ResourceNavigatorMessages.getString((String)"DropAdapter.targetMustBeResource"));
        }
        IResource resource = this.getResource(dropAdapter.getCurrentTarget());
        if (!resource.isAccessible()) {
            return this.error(ResourceNavigatorMessages.getString((String)"DropAdapter.canNotDropIntoClosedProject"));
        }
        IContainer destination = this.getActualTarget(dropAdapter, resource);
        if (destination.getType() == 8) {
            return this.error(ResourceNavigatorMessages.getString((String)"DropAdapter.resourcesCanNotBeSiblings"));
        }
        String message = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources == null) {
                message = ResourceNavigatorMessages.getString((String)"DropAdapter.dropOperationErrorOther");
            } else {
                CopyFilesAndFoldersOperation operation = this.lastValidOperation == 1 ? this.getCopyOperation() : this.getMoveOperation();
                message = operation.validateDestination(destination, selectedResources);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            message = this.getCopyOperation().validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return this.error(message);
        }
        return this.ok();
    }

    private CopyFilesAndFoldersOperation getMoveOperation() {
        if (this.moveOperation == null) {
            this.moveOperation = new MoveFilesAndFoldersOperation(this.getShell());
        }
        return this.moveOperation;
    }

    private CopyFilesAndFoldersOperation getCopyOperation() {
        if (this.copyOperation == null) {
            this.copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
        }
        return this.copyOperation;
    }

    protected IResource getResource(Object target) {
        return (IResource)AdaptabilityUtility.getAdapter((Object)target, (Class)IRESOURCE_CLASS);
    }
}

