/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.internal.ui.contexts.DebugWindowContextService;
import org.eclipse.debug.internal.ui.contexts.IDebugContextService;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextProvider;
import org.eclipse.debug.internal.ui.views.ViewContextManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugContextManager
implements IDebugContextManager {
    private static DebugContextManager fgDefault;
    private Map fServices = new HashMap();
    private ListenerList fGlobalListeners = new ListenerList();

    private DebugContextManager() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowListener());
    }

    public static IDebugContextManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new DebugContextManager();
            DebugModelContextBindingManager.getDefault();
            ViewContextManager.getDefault();
        }
        return fgDefault;
    }

    public void addDebugContextProvider(IDebugContextProvider provider) {
        IWorkbenchPart part = provider.getPart();
        IWorkbenchWindow window = part.getSite().getWorkbenchWindow();
        DebugWindowContextService service = this.createService(window);
        service.addProvider(provider);
    }

    protected DebugWindowContextService createService(IWorkbenchWindow window) {
        DebugWindowContextService service = (DebugWindowContextService)this.fServices.get(window);
        if (service == null) {
            service = new DebugWindowContextService(window);
            this.fServices.put(window, service);
            Object[] listeners = this.fGlobalListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IDebugContextListener listener = (IDebugContextListener)listeners[i];
                service.addDebugContextListener(listener);
                ++i;
            }
        }
        return service;
    }

    protected IDebugContextService getService(IWorkbenchWindow window) {
        return (DebugWindowContextService)this.fServices.get(window);
    }

    public void removeDebugContextProvider(IDebugContextProvider provider) {
        IWorkbenchPart part = provider.getPart();
        IWorkbenchWindow window = part.getSite().getWorkbenchWindow();
        DebugWindowContextService service = (DebugWindowContextService)this.fServices.get(window);
        if (service != null) {
            service.removeProvider(provider);
        }
    }

    public void addDebugContextListener(IDebugContextListener listener, IWorkbenchWindow window) {
        DebugWindowContextService service = this.createService(window);
        service.addDebugContextListener(listener);
    }

    public void removeDebugContextListener(IDebugContextListener listener, IWorkbenchWindow window) {
        IDebugContextService service = this.getService(window);
        if (service != null) {
            service.removeDebugContextListener(listener);
        }
    }

    public void addDebugContextListener(IDebugContextListener listener, IWorkbenchWindow window, String partId) {
        DebugWindowContextService service = this.createService(window);
        service.addDebugContextListener(listener, partId);
    }

    public void removeDebugContextListener(IDebugContextListener listener, IWorkbenchWindow window, String partId) {
        IDebugContextService service = this.getService(window);
        if (service != null) {
            service.removeDebugContextListener(listener, partId);
        }
    }

    public ISelection getActiveContext(IWorkbenchWindow window) {
        IDebugContextService service = this.getService(window);
        if (service != null) {
            return service.getActiveContext();
        }
        return null;
    }

    public ISelection getActiveContext(IWorkbenchWindow window, String partId) {
        IDebugContextService service = this.getService(window);
        if (service != null) {
            return service.getActiveContext(partId);
        }
        return null;
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.fGlobalListeners.add((Object)listener);
        DebugWindowContextService[] services = this.getServices();
        int i = 0;
        while (i < services.length) {
            DebugWindowContextService service = services[i];
            service.addDebugContextListener(listener);
            ++i;
        }
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.fGlobalListeners.remove((Object)listener);
        DebugWindowContextService[] services = this.getServices();
        int i = 0;
        while (i < services.length) {
            DebugWindowContextService service = services[i];
            service.removeDebugContextListener(listener);
            ++i;
        }
    }

    private DebugWindowContextService[] getServices() {
        Collection sevices = this.fServices.values();
        return sevices.toArray(new DebugWindowContextService[sevices.size()]);
    }

    private class WindowListener
    implements IWindowListener {
        WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            DebugWindowContextService service = (DebugWindowContextService)DebugContextManager.this.fServices.remove(window);
            if (service != null) {
                service.dispose();
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

