/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveScopeResourcesHandler
implements IStatusHandler {
    Object[] fSaves = null;
    static /* synthetic */ Class class$0;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Object[] objects;
        ILaunchConfiguration config = null;
        IProject[] projects = null;
        if (source instanceof Object[] && (objects = (Object[])source).length == 2) {
            config = (ILaunchConfiguration)objects[0];
            projects = (IProject[])objects[1];
        }
        if (config != null && DebugUITools.isPrivate(config)) {
            return Boolean.TRUE;
        }
        if (projects != null) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String save = store.getString(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
            int ret = this.showSaveDialog(projects, !save.equals("never"), save.equals("prompt"));
            if (ret == 0) {
                this.doSave();
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        DebugUIPlugin.preLaunchSave();
        return Boolean.TRUE;
    }

    protected IEditorPart[] getScopedDirtyEditors(IProject[] projects) {
        ArrayList<IEditorPart> dirtyparts = new ArrayList<IEditorPart>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int l = 0;
        while (l < windows.length) {
            IWorkbenchPage[] pages = windows[l].getPages();
            int i = 0;
            while (i < pages.length) {
                IEditorPart[] eparts = pages[i].getDirtyEditors();
                int j = 0;
                while (j < eparts.length) {
                    IResource resource;
                    IEditorInput iEditorInput = eparts[j].getEditorInput();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
                        int k = 0;
                        while (k < projects.length) {
                            if (projects[k].equals((Object)resource.getProject()) & !dirtyparts.contains(eparts[j])) {
                                dirtyparts.add(eparts[j]);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        return dirtyparts.toArray(new IEditorPart[dirtyparts.size()]);
    }

    protected void doSave() {
        if (this.fSaves != null) {
            int i = 0;
            while (i < this.fSaves.length) {
                ((IEditorPart)this.fSaves[i]).doSave((IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    protected int showSaveDialog(IProject[] projects, boolean save, boolean prompt) {
        if (save) {
            Object[] editors = this.getScopedDirtyEditors(projects);
            if (prompt && editors.length > 0) {
                ListSelectionDialog lsd = new ListSelectionDialog(DebugUIPlugin.getShell(), (Object)new AdaptableList((IAdaptable[])editors), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), LaunchConfigurationsMessages.SaveScopeResourcesHandler_2);
                lsd.setInitialSelections(editors);
                lsd.setTitle(LaunchConfigurationsMessages.SaveScopeResourcesHandler_3);
                if (lsd.open() == 1) {
                    return 1;
                }
                this.fSaves = lsd.getResult();
            } else {
                this.fSaves = editors;
            }
        }
        return 0;
    }
}

