/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.model.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.ui.progress.WorkbenchJob;

abstract class AsynchronousModelRequestMonitor
implements IAsynchronousRequestMonitor {
    private ModelNode fNode;
    private AsynchronousModel fModel;
    private boolean fCanceled = false;
    private IStatus fStatus = null;
    protected WorkbenchJob fViewerUpdateJob = new WorkbenchJob("AsynchronousModelRequestMonitor.fViewerUpdateJob"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            AsynchronousModelRequestMonitor.this.getModel().viewerUpdateScheduled(AsynchronousModelRequestMonitor.this);
            AsynchronousModelRequestMonitor.this.getModel().requestComplete(AsynchronousModelRequestMonitor.this);
            if (!AsynchronousModelRequestMonitor.this.isCanceled() && !AsynchronousModelRequestMonitor.this.getNode().isDisposed()) {
                if (AsynchronousModelRequestMonitor.this.fStatus != null && !AsynchronousModelRequestMonitor.this.fStatus.isOK()) {
                    AsynchronousModelRequestMonitor.this.getModel().getViewer().handlePresentationFailure(AsynchronousModelRequestMonitor.this, AsynchronousModelRequestMonitor.this.fStatus);
                }
                AsynchronousModelRequestMonitor.this.performUpdate();
            }
            AsynchronousModelRequestMonitor.this.getModel().viewerUpdateComplete(AsynchronousModelRequestMonitor.this);
            return Status.OK_STATUS;
        }
    };

    AsynchronousModelRequestMonitor(ModelNode node, AsynchronousModel model) {
        this.fNode = node;
        this.fModel = model;
        this.fViewerUpdateJob.setSystem(true);
    }

    protected AsynchronousModel getModel() {
        return this.fModel;
    }

    protected ModelNode getNode() {
        return this.fNode;
    }

    protected boolean contains(ModelNode node) {
        if (node == this.getNode()) {
            return true;
        }
        ModelNode parentNode = this.getNode().getParentNode();
        while (parentNode != null) {
            if (parentNode.equals(this.getNode())) {
                return true;
            }
            parentNode = parentNode.getParentNode();
        }
        return false;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public void beginTask(String name, int totalWork) {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.fCanceled;
    }

    public void setCanceled(boolean value) {
        this.fCanceled = true;
        this.getModel().requestCanceled(this);
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
    }

    public final void done() {
        if (!this.isCanceled()) {
            this.fViewerUpdateJob.schedule();
        }
    }

    protected void scheduleViewerUpdate(long ms) {
        if (!this.isCanceled()) {
            this.fViewerUpdateJob.schedule(ms);
        }
    }

    protected abstract void performUpdate();

    protected abstract boolean contains(AsynchronousModelRequestMonitor var1);
}

