/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.elements.adapters.AsynchronousDebugLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.IUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.LabelRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelSelectionPolicyAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AsynchronousViewer
extends StructuredViewer {
    public static boolean DEBUG_CACHE;
    private Map fElementsToWidgets = new HashMap();
    private Map fWidgetsToElements = new HashMap();
    private List fPendingUpdates = new ArrayList();
    private Map fImageCache = new HashMap();
    private Map fFontCache = new HashMap();
    private Map fColorCache = new HashMap();
    private IPresentationContext fContext;
    private ISelection fPendingSelection;
    private ISelection fCurrentSelection;
    private IUpdatePolicy fUpdatePolicy;
    private Map fModelProxies = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected AsynchronousViewer() {
        this.setContentProvider((IContentProvider)new NullContentProvider());
    }

    public synchronized void dispose() {
        Iterator images = this.fImageCache.values().iterator();
        while (images.hasNext()) {
            Image image = (Image)images.next();
            image.dispose();
        }
        this.fImageCache.clear();
        Iterator fonts = this.fFontCache.values().iterator();
        while (fonts.hasNext()) {
            Font font = (Font)fonts.next();
            font.dispose();
        }
        this.fFontCache.clear();
        Iterator colors = this.fColorCache.values().iterator();
        while (colors.hasNext()) {
            Color color = (Color)colors.next();
            color.dispose();
        }
        this.fColorCache.clear();
        this.disposeAllModelProxies();
        if (this.fUpdatePolicy != null) {
            this.fUpdatePolicy.dispose();
        }
        this.unmapAllElements();
        this.fPendingUpdates.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllModelProxies() {
        Map map = this.fModelProxies;
        synchronized (map) {
            Iterator updatePolicies = this.fModelProxies.values().iterator();
            while (updatePolicies.hasNext()) {
                IModelProxy proxy = (IModelProxy)updatePolicies.next();
                if (this.fUpdatePolicy instanceof IModelChangedListener) {
                    proxy.removeModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
                }
                proxy.dispose();
            }
            this.fModelProxies.clear();
        }
    }

    public void update(Object element) {
        if (element == this.getInput()) {
            return;
        }
        Widget[] items = this.getWidgets(element);
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                this.updateLabel(element, items[i]);
                ++i;
            }
        }
    }

    protected void updateLabel(Object element, Widget item) {
        IAsynchronousLabelAdapter adapter;
        if (item instanceof Item && (adapter = this.getLabelAdapter(element)) != null) {
            LabelRequestMonitor labelUpdate = new LabelRequestMonitor(item, this);
            this.schedule(labelUpdate);
            adapter.retrieveLabel(element, this.getPresentationContext(), labelUpdate);
        }
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    protected IAsynchronousLabelAdapter getLabelAdapter(Object element) {
        IAsynchronousLabelAdapter adapter = null;
        if (element instanceof IAsynchronousLabelAdapter) {
            adapter = (IAsynchronousLabelAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IAsynchronousLabelAdapter)adaptable.getAdapter((Class)clazz);
        }
        if (adapter == null) {
            return new AsynchronousDebugLabelAdapter();
        }
        return adapter;
    }

    protected IModelProxyFactoryAdapter getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactoryAdapter adapter = null;
        if (element instanceof IModelProxyFactoryAdapter) {
            adapter = (IModelProxyFactoryAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IModelProxyFactoryAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(IAsynchronousRequestMonitor update) {
        AsynchronousRequestMonitor absUpdate = (AsynchronousRequestMonitor)update;
        List list = this.fPendingUpdates;
        synchronized (list) {
            ListIterator updates = this.fPendingUpdates.listIterator();
            while (updates.hasNext()) {
                AsynchronousRequestMonitor pendingUpdate = (AsynchronousRequestMonitor)updates.next();
                if (!absUpdate.contains(pendingUpdate)) continue;
                pendingUpdate.setCanceled(true);
                updates.remove();
            }
            this.fPendingUpdates.add(update);
        }
    }

    protected synchronized Widget[] getWidgets(Object element) {
        if (element == null) {
            return null;
        }
        return (Widget[])this.fElementsToWidgets.get(element);
    }

    protected synchronized Object getElement(Widget widget) {
        return this.fWidgetsToElements.get(widget);
    }

    protected synchronized void unmapAllElements() {
        Iterator iterator = this.fElementsToWidgets.keySet().iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            Widget[] widgets = this.getWidgets(element);
            if (widgets == null) continue;
            int i = 0;
            while (i < widgets.length) {
                Widget widget = widgets[i];
                if (widget instanceof Item) {
                    Item item = (Item)widget;
                    item.dispose();
                }
                ++i;
            }
        }
        this.fElementsToWidgets.clear();
        this.fWidgetsToElements.clear();
        this.disposeAllModelProxies();
        if (DEBUG_CACHE) {
            System.out.println("unmapped all elements");
            System.out.println("\tfWidgetsToElements.size() " + this.fWidgetsToElements.size());
            System.out.println("\tfElementsToWidgets.size() " + this.fElementsToWidgets.size());
        }
    }

    protected synchronized void cancelPendingUpdates() {
        Iterator updates = this.fPendingUpdates.iterator();
        while (updates.hasNext()) {
            IAsynchronousRequestMonitor update = (IAsynchronousRequestMonitor)updates.next();
            update.setCanceled(true);
        }
        this.fPendingUpdates.clear();
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (this.fUpdatePolicy == null) {
            this.fUpdatePolicy = this.createUpdatePolicy();
            this.fUpdatePolicy.init(this);
        }
        this.cancelPendingUpdates();
    }

    protected void map(Object element, Widget item) {
        item.setData(element);
        Widget[] widgets = this.getWidgets(element);
        this.fWidgetsToElements.put(item, element);
        if (widgets == null) {
            this.fElementsToWidgets.put(element, new Widget[]{item});
        } else {
            Widget[] old = widgets;
            Widget[] items = new Widget[old.length + 1];
            System.arraycopy(old, 0, items, 0, old.length);
            items[old.length] = item;
            this.fElementsToWidgets.put(element, items);
        }
        this.installModelProxy(element);
        if (DEBUG_CACHE) {
            System.out.println("mapped " + element + " to " + item + "(hashcode: " + item.hashCode() + ")");
            System.out.println("\tfWidgetsToElements.size() " + this.fWidgetsToElements.size());
            System.out.println("\tfElementsToWidgets.size() " + this.fElementsToWidgets.size());
        }
    }

    protected void remap(Object element, Widget item) {
        item.setData(element);
        this.installModelProxy(element);
        this.fWidgetsToElements.put(item, element);
        Widget[] widgets = (Widget[])this.fElementsToWidgets.remove(element);
        if (widgets == null) {
            this.fElementsToWidgets.put(element, new Widget[]{item});
        } else {
            Widget[] newArray = new Widget[widgets.length + 1];
            System.arraycopy(widgets, 0, newArray, 0, widgets.length);
            newArray[widgets.length] = item;
            this.fElementsToWidgets.put(element, newArray);
        }
        if (DEBUG_CACHE) {
            System.out.println("remapped " + element + " to " + item + "(hashcode: " + item.hashCode() + ")");
            System.out.println("\tfWidgetsToElements.size() " + this.fWidgetsToElements.size());
            System.out.println("\tfElementsToWidgets.size() " + this.fElementsToWidgets.size());
        }
    }

    public abstract IUpdatePolicy createUpdatePolicy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installModelProxy(Object element) {
        Map map = this.fModelProxies;
        synchronized (map) {
            IModelProxy proxy;
            IModelProxyFactoryAdapter modelProxyFactory;
            if (!this.fModelProxies.containsKey(element) && (modelProxyFactory = this.getModelProxyFactoryAdapter(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
                proxy.init(this.getPresentationContext());
                this.fModelProxies.put(element, proxy);
                if (this.fUpdatePolicy instanceof IModelChangedListener) {
                    proxy.addModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
                }
                proxy.installed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeModelProxy(Object element) {
        Map map = this.fModelProxies;
        synchronized (map) {
            IModelProxy proxy = (IModelProxy)this.fModelProxies.remove(element);
            if (proxy != null) {
                if (this.fUpdatePolicy instanceof IModelChangedListener) {
                    proxy.removeModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
                }
                proxy.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateComplete(IAsynchronousRequestMonitor update) {
        List list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(update);
        }
    }

    protected synchronized void unmap(Object kid, Widget widget) {
        if (kid == null) {
            return;
        }
        Widget[] widgets = this.getWidgets(kid);
        if (widgets != null) {
            int i = 0;
            while (i < widgets.length) {
                Widget item = widgets[i];
                if (item == widget) {
                    if (widgets.length == 1) {
                        this.fElementsToWidgets.remove(kid);
                        this.disposeModelProxy(kid);
                    } else {
                        Widget[] newItems = new Widget[widgets.length - 1];
                        System.arraycopy(widgets, 0, newItems, 0, i);
                        if (i < newItems.length) {
                            System.arraycopy(widgets, i + 1, newItems, i, newItems.length - i);
                        }
                        this.fElementsToWidgets.put(kid, newItems);
                    }
                }
                ++i;
            }
        }
        this.fWidgetsToElements.remove(widget);
        if (DEBUG_CACHE) {
            System.out.println("unmapped " + kid + " to " + widget + "(hashcode: " + widget.hashCode() + ")");
            System.out.println("\tfWidgetsToElements.size() " + this.fWidgetsToElements.size());
            System.out.println("\tfElementsToWidgets.size() " + this.fElementsToWidgets.size());
        }
    }

    Image[] getImages(ImageDescriptor[] descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            return new Image[0];
        }
        Image[] images = new Image[descriptors.length];
        int i = 0;
        while (i < images.length) {
            images[i] = this.getImage(descriptors[i]);
            ++i;
        }
        return images;
    }

    Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.fImageCache.get(descriptor);
        if (image == null) {
            image = new Image((Device)this.getControl().getDisplay(), descriptor.getImageData());
            this.fImageCache.put(descriptor, image);
        }
        return image;
    }

    Font[] getFonts(FontData[] fontDatas) {
        if (fontDatas == null) {
            return new Font[0];
        }
        Font[] fonts = new Font[fontDatas.length];
        int i = 0;
        while (i < fonts.length) {
            fonts[i] = this.getFont(fontDatas[i]);
            ++i;
        }
        return fonts;
    }

    Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        Font font = (Font)this.fFontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)this.getControl().getDisplay(), fontData);
            this.fFontCache.put(fontData, font);
        }
        return font;
    }

    Color[] getColor(RGB[] rgb) {
        if (rgb == null) {
            return new Color[0];
        }
        Color[] colors = new Color[rgb.length];
        int i = 0;
        while (i < colors.length) {
            colors[i] = this.getColor(rgb[i]);
            ++i;
        }
        return colors;
    }

    Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = (Color)this.fColorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getControl().getDisplay(), rgb);
            this.fColorCache.put(rgb, color);
        }
        return color;
    }

    public void setContext(IPresentationContext context) {
        this.fContext = context;
    }

    protected Widget doFindItem(Object element) {
        Widget[] widgets = this.getWidgets(element);
        if (widgets != null && widgets.length > 0) {
            return widgets[0];
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        this.updateLabel(element, item);
    }

    protected void internalRefresh(Object element) {
        Widget[] items = this.getWidgets(element);
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            this.internalRefresh(element, items[i]);
            ++i;
        }
    }

    protected void internalRefresh(Object element, Widget item) {
        this.updateLabel(element, item);
    }

    public synchronized void setSelection(ISelection selection, boolean reveal) {
        this.setSelection(selection, reveal, false);
    }

    public synchronized void setSelection(ISelection selection, final boolean reveal, boolean force) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (!this.acceptsSelection(selection)) {
            selection = this.getEmptySelection();
        }
        if (!force && !this.overrideSelection(this.fCurrentSelection, selection)) {
            return;
        }
        this.fPendingSelection = selection;
        if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
            this.attemptSelection(reveal);
        } else {
            WorkbenchJob job = new WorkbenchJob("attemptSelection"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AsynchronousViewer.this.attemptSelection(reveal);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicyAdapter selectionPolicy = this.getSelectionPolicy(current);
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed() || this.fCurrentSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fCurrentSelection;
    }

    protected void handleSelect(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateSelection(this.newSelectionFromWidget());
        }
    }

    protected void handlePostSelect(SelectionEvent e) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.newSelectionFromWidget());
        this.firePostSelectionChanged(event);
    }

    protected abstract ISelection newSelectionFromWidget();

    protected IModelSelectionPolicyAdapter getSelectionPolicy(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelSelectionPolicyAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IModelSelectionPolicyAdapter)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    protected final void setSelectionToWidget(ISelection selection, boolean reveal) {
        throw new IllegalArgumentException("This method should not be called");
    }

    protected final void setSelectionToWidget(List l, boolean reveal) {
        throw new IllegalArgumentException("This method should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSelection(boolean reveal) {
        if (this.fPendingSelection != null && !this.fPendingSelection.isEmpty()) {
            ISelection currentSelection = null;
            AsynchronousViewer asynchronousViewer = this;
            synchronized (asynchronousViewer) {
                ISelection remaining = this.doAttemptSelectionToWidget(this.fPendingSelection, reveal);
                if (!this.fPendingSelection.equals(remaining) || this.fPendingSelection.isEmpty() && this.fPendingSelection.equals(remaining)) {
                    this.fPendingSelection = remaining;
                    currentSelection = this.newSelectionFromWidget();
                    if (this.isSuppressEqualSelections() && currentSelection.equals(this.fCurrentSelection)) {
                        return;
                    }
                }
            }
            if (currentSelection != null) {
                this.updateSelection(currentSelection);
            }
        }
    }

    protected boolean isSuppressEqualSelections() {
        return true;
    }

    protected abstract ISelection doAttemptSelectionToWidget(ISelection var1, boolean var2);

    protected abstract boolean acceptsSelection(ISelection var1);

    protected abstract ISelection getEmptySelection();

    protected void handlePresentationFailure(IAsynchronousRequestMonitor monitor, IStatus status) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void preservingSelection(Runnable updateCode) {
        if (this.fPendingSelection != null && !this.fPendingSelection.isEmpty()) {
            updateCode.run();
            return;
        }
        ISelection oldSelection = null;
        try {
            oldSelection = this.fCurrentSelection;
            updateCode.run();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (oldSelection == null) {
                oldSelection = new StructuredSelection();
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.restoreSelection(oldSelection);
                throw throwable;
            }
            ISelection tempSelection = oldSelection;
            WorkbenchJob job = new WorkbenchJob("attemptSelection", tempSelection){
                private final /* synthetic */ ISelection val$tempSelection;
                {
                    this.val$tempSelection = iSelection;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!AsynchronousViewer.this.getControl().isDisposed()) {
                        AsynchronousViewer.this.restoreSelection(this.val$tempSelection);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            throw throwable;
        }
        {
            Object var3_5 = null;
            if (oldSelection == null) {
                oldSelection = new StructuredSelection();
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.restoreSelection(oldSelection);
                return;
            }
            ISelection tempSelection = oldSelection;
            WorkbenchJob job = new /* invalid duplicate definition of identical inner class */;
            job.setSystem(true);
            job.schedule();
            return;
        }
    }

    protected synchronized void restoreSelection(ISelection oldSelection) {
        this.doAttemptSelectionToWidget(oldSelection, false);
        this.fCurrentSelection = this.newSelectionFromWidget();
        if (!this.fCurrentSelection.equals(oldSelection)) {
            this.handleInvalidSelection(oldSelection, this.fCurrentSelection);
        }
    }

    abstract void setColors(Widget var1, RGB[] var2, RGB[] var3);

    abstract void setLabels(Widget var1, String[] var2, ImageDescriptor[] var3);

    abstract void setFonts(Widget var1, FontData[] var2);

    protected abstract Widget getParent(Widget var1);

    protected synchronized void updateSelection(ISelection selection) {
        this.fCurrentSelection = selection;
        super.updateSelection(selection);
    }

    protected abstract void setChildren(Widget var1, List var2);

    protected abstract void add(Widget var1, Object var2);

    protected boolean hasPendingUpdates() {
        return !this.fPendingUpdates.isEmpty();
    }

    private class NullContentProvider
    implements IStructuredContentProvider {
        NullContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return null;
        }
    }
}

