/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.TreePath;
import org.eclipse.debug.internal.ui.viewers.TreeSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractViewerState {
    private List fSavedExpansion = null;
    private IPath[] fSelection;

    public AbstractViewerState(AsynchronousTreeModelViewer viewer) {
        this.saveState(viewer);
    }

    public void saveState(AsynchronousTreeModelViewer viewer) {
        ArrayList expanded = new ArrayList();
        this.fSavedExpansion = null;
        TreeItem[] items = viewer.getTree().getItems();
        try {
            int i = 0;
            while (i < items.length) {
                this.collectExpandedItems(items[i], expanded);
                ++i;
            }
            if (expanded.size() > 0) {
                this.fSavedExpansion = expanded;
            }
        }
        catch (DebugException debugException) {
            this.fSavedExpansion = null;
        }
        TreeItem[] selection = viewer.getTree().getSelection();
        this.fSelection = new IPath[selection.length];
        try {
            int i = 0;
            while (i < selection.length) {
                this.fSelection[i] = this.encodeElement(selection[i]);
                if (this.fSelection[i] == null) {
                    this.fSelection = null;
                    return;
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            this.fSelection = null;
        }
    }

    protected boolean collectExpandedItems(TreeItem item, List expanded) throws DebugException {
        if (item.getExpanded()) {
            boolean childExpanded = false;
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                childExpanded = this.collectExpandedItems(items[i], expanded) || childExpanded;
                ++i;
            }
            if (!childExpanded) {
                IPath path = this.encodeElement(item);
                expanded.add(path);
            }
        } else {
            return false;
        }
        return true;
    }

    protected abstract IPath encodeElement(TreeItem var1) throws DebugException;

    public void restoreState(AsynchronousTreeModelViewer viewer) {
        boolean expansionComplete = true;
        if (this.fSavedExpansion != null && this.fSavedExpansion.size() > 0) {
            int i = 0;
            while (i < this.fSavedExpansion.size()) {
                IPath path = (IPath)this.fSavedExpansion.get(i);
                if (path != null) {
                    try {
                        TreePath treePath = this.decodePath(path, viewer);
                        if (treePath != null) {
                            viewer.expand((ISelection)new TreeSelection(new TreePath[]{treePath}));
                            if (treePath.getSegmentCount() - 1 != path.segmentCount()) {
                                expansionComplete = false;
                            }
                        } else {
                            expansionComplete = false;
                        }
                    }
                    catch (DebugException debugException) {}
                }
                ++i;
            }
            if (expansionComplete) {
                this.fSavedExpansion = null;
            }
        }
        boolean selectionComplete = true;
        if (this.fSelection != null && this.fSelection.length > 0) {
            ArrayList<TreePath> selection = new ArrayList<TreePath>(this.fSelection.length);
            int i = 0;
            while (i < this.fSelection.length) {
                IPath path = this.fSelection[i];
                try {
                    TreePath obj = this.decodePath(path, viewer);
                    if (obj != null && obj.getSegmentCount() - 1 == path.segmentCount()) {
                        selection.add(obj);
                    } else {
                        selectionComplete = false;
                    }
                }
                catch (DebugException debugException) {}
                ++i;
            }
            if (selection.size() > 0) {
                TreePath[] treePaths = selection.toArray(new TreePath[0]);
                viewer.setSelection((ISelection)new TreeSelection(treePaths));
            }
            if (selectionComplete) {
                this.fSelection = null;
            }
        }
    }

    protected abstract TreePath decodePath(IPath var1, AsynchronousTreeModelViewer var2) throws DebugException;
}

