/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.AddToFavoritesAction;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.actions.FindElementAction;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextProvider;
import org.eclipse.debug.internal.ui.model.viewers.AsynchronousTreeModelViewer;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.viewers.PresentationContext;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class LaunchView
extends AbstractDebugView
implements ISelectionChangedListener,
IPerspectiveListener2,
IPageListener,
IShowInTarget,
IShowInSource,
IShowInTargetList,
IPartListener2 {
    public static final String ID_CONTEXT_ACTIVITY_BINDINGS = "contextActivityBindings";
    private boolean fIsActive = true;
    private IDebugEditorPresentation fEditorPresentation = null;
    private EditLaunchConfigurationAction fEditConfigAction = null;
    private AddToFavoritesAction fAddToFavoritesAction = null;
    private EditSourceLookupPathAction fEditSourceAction = null;
    private LookupSourceAction fLookupAction = null;
    private ContextProvider fProvider = new ContextProvider();
    static /* synthetic */ Class class$0;

    protected String getHelpContextId() {
        return IDebugHelpContextIds.DEBUG_VIEW;
    }

    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction((IShellProvider)this.getSite(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.fAddToFavoritesAction = new AddToFavoritesAction();
        this.fEditSourceAction = new EditSourceLookupPathAction(this);
        this.fLookupAction = new LookupSourceAction(this);
        this.setAction(FIND_ACTION, (IAction)new FindElementAction((AsynchronousTreeModelViewer)this.getViewer()));
        Runnable r = new Runnable(){

            public void run() {
                LaunchView.this.initializeSelection();
            }
        };
        this.asyncExec(r);
    }

    protected Viewer createViewer(Composite parent) {
        LaunchViewer viewer = new LaunchViewer(parent, this);
        viewer.setContext(new PresentationContext((IWorkbenchPart)this));
        viewer.setInput(DebugPlugin.getDefault().getLaunchManager());
        viewer.addSelectionChangedListener(this);
        viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LaunchView.this.handleDeleteKeyPressed();
                }
            }
        });
        DelegatingModelPresentation presentation = new DelegatingModelPresentation();
        this.fEditorPresentation = presentation;
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setInput(DebugPlugin.getDefault().getLaunchManager());
        DebugContextManager.getDefault().addDebugContextProvider(this.fProvider);
        return viewer;
    }

    private void handleDeleteKeyPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Iterator iter = selection.iterator();
        boolean itemsToTerminate = false;
        while (iter.hasNext()) {
            ITerminate terminable;
            Object item = iter.next();
            if (!(item instanceof ITerminate) || !(terminable = (ITerminate)item).canTerminate() || terminable.isTerminated()) continue;
            itemsToTerminate = true;
            break;
        }
        if (itemsToTerminate && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)DebugUIViewsMessages.LaunchView_Terminate_and_Remove_1, (String)DebugUIViewsMessages.LaunchView_Terminate_and_remove_selected__2)) {
            return;
        }
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, DebugUIViewsMessages.LaunchView_Exceptions_occurred_attempting_to_terminate_and_remove_3, null);
        iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                LaunchView.terminateAndRemove(iter.next());
            }
            catch (DebugException exception) {
                status.merge(exception.getStatus());
            }
        }
        if (!status.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIViewsMessages.LaunchView_Terminate_and_Remove_4, DebugUIViewsMessages.LaunchView_Terminate_and_remove_failed_5, (IStatus)status);
            } else {
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void terminateAndRemove(Object element) throws DebugException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 147->151)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeSelection() {
        if (!this.isAvailable()) {
            return;
        }
        Job initJob = new Job(DebugUIViewsMessages.LaunchView_2){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunchManager launchManager = (ILaunchManager)LaunchView.this.getViewer().getInput();
                ILaunch[] launches = launchManager.getLaunches();
                if (launches.length == 0) {
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            5.access$0(this.this$1).getViewer().setSelection((ISelection)new StructuredSelection());
                        }
                    };
                    LaunchView.this.asyncExec(runnable);
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ LaunchView access$0(5 var0) {
                return var0.LaunchView.this;
            }
        };
        initJob.schedule();
    }

    private void commonInit(IViewSite site) {
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.commonInit(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.commonInit(site);
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextProvider(this.fProvider);
        this.fProvider.dispose();
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (viewer instanceof AsynchronousTreeModelViewer) {
                AsynchronousTreeModelViewer asyncTreeViewer = (AsynchronousTreeModelViewer)viewer;
                asyncTreeViewer.dispose();
            }
        }
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener2)this);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.removePageListener((IPageListener)this);
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fProvider.activate(event.getSelection());
        this.updateObjects();
    }

    protected void possibleContextChange(Object element) {
        this.fProvider.possibleContextChange(element);
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o == null || o instanceof IStackFrame) {
            return;
        }
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        viewer.refresh(o);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)this.fEditorPresentation).getPresentation(id);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add(this.getAction(FIND_ACTION));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        IStructuredSelection selection = (IStructuredSelection)this.getSite().getSelectionProvider().getSelection();
        this.updateAndAdd(menu, this.fEditConfigAction, selection);
        this.updateAndAdd(menu, this.fAddToFavoritesAction, selection);
        this.updateAndAdd(menu, this.fEditSourceAction, selection);
        this.updateAndAdd(menu, this.fLookupAction, selection);
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        action.setEnabled(action.isApplicableForSelection());
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void updateAndAdd(IMenuManager menu, SelectionListenerAction action, IStructuredSelection selection) {
        action.selectionChanged(selection);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            this.getViewer().setSelection(selection, true);
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        Object sourceElement;
        IStructuredSelection selection;
        if (this.isActive() && !(selection = (IStructuredSelection)this.getViewer().getSelection()).isEmpty() && (sourceElement = null) instanceof IAdaptable) {
            IAdaptable iAdaptable = sourceElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) {
                return new ShowInContext(null, (ISelection)new StructuredSelection(sourceElement));
            }
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.setActive(true);
            this.getSite().getPage().showActionSet(IDebugUIConstants.DEBUG_ACTION_SET);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
    }

    class ContextProvider
    implements IDebugContextProvider {
        private ListenerList fListeners = new ListenerList();
        private ISelection fContext = null;

        ContextProvider() {
        }

        protected void dispose() {
            this.fContext = null;
            this.fListeners.clear();
        }

        public IWorkbenchPart getPart() {
            return LaunchView.this;
        }

        public void addDebugContextListener(IDebugContextListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeDebugContextListener(IDebugContextListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public synchronized ISelection getActiveContext() {
            return this.fContext;
        }

        protected synchronized void activate(ISelection selection) {
            this.fContext = selection;
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IDebugContextListener listener = (IDebugContextListener)listeners[i];
                Platform.run((ISafeRunnable)new ISafeRunnable(this, listener){
                    final /* synthetic */ ContextProvider this$1;
                    private final /* synthetic */ IDebugContextListener val$listener;
                    {
                        this.this$1 = contextProvider;
                        this.val$listener = iDebugContextListener;
                    }

                    public void run() throws Exception {
                        this.val$listener.contextActivated(ContextProvider.access$0(this.this$1), this.this$1.getPart());
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }

        protected synchronized void possibleContextChange(Object element) {
            IStructuredSelection ss;
            if (this.fContext instanceof IStructuredSelection && (ss = (IStructuredSelection)this.fContext).size() == 1 && ss.getFirstElement().equals(element)) {
                Object[] listeners = this.fListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IDebugContextListener listener = (IDebugContextListener)listeners[i];
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, listener){
                        final /* synthetic */ ContextProvider this$1;
                        private final /* synthetic */ IDebugContextListener val$listener;
                        {
                            this.this$1 = contextProvider;
                            this.val$listener = iDebugContextListener;
                        }

                        public void run() throws Exception {
                            this.val$listener.contextChanged(ContextProvider.access$0(this.this$1), this.this$1.getPart());
                        }

                        public void handleException(Throwable exception) {
                            DebugUIPlugin.log(exception);
                        }
                    });
                    ++i;
                }
            }
        }

        static /* synthetic */ ISelection access$0(ContextProvider contextProvider) {
            return contextProvider.fContext;
        }
    }
}

