/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewer;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewerContentManager;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.IContentChangeComputer;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentManager;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingPresentationContext;

public class TableRenderingContentManager
extends AsynchronousTableViewerContentManager
implements IVirtualContentManager,
IContentChangeComputer {
    private Hashtable fCache = new Hashtable();
    private Vector fOrderedCache = new Vector();

    public TableRenderingContentManager(AsynchronousTableViewer viewer) {
        super(viewer);
    }

    public int indexOf(Object key) {
        if (key instanceof BigInteger) {
            BigInteger address = (BigInteger)key;
            Object[] items = this.getElements();
            int i = 0;
            while (i < items.length) {
                MemorySegment line;
                if (items[i] != null && items[i] instanceof MemorySegment && (line = (MemorySegment)((Object)items[i])).containsAddress(address)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int columnOf(Object element, Object key) {
        BigInteger address;
        MemorySegment line;
        if (element instanceof MemorySegment && key instanceof BigInteger && (line = (MemorySegment)((Object)element)).containsAddress(address = (BigInteger)key) && this.getAddressableUnitsPerColumn() > 0) {
            BigInteger offset = address.subtract(line.getAddress());
            int colAddressableUnit = this.getAddressableUnitsPerColumn();
            int col = offset.intValue() / colAddressableUnit + 1;
            if (col == 0) {
                col = 1;
            }
            return col;
        }
        return -1;
    }

    public Object getKey(int idx) {
        Object elmt = this.getElement(idx);
        if (elmt instanceof MemorySegment) {
            return ((MemorySegment)((Object)elmt)).getAddress();
        }
        return null;
    }

    public Object getKey(Object element) {
        int idx = this.indexOfElement(element);
        if (idx >= 0) {
            return this.getKey(idx);
        }
        return null;
    }

    public Object getKey(int idx, int col) {
        Object element = this.getElement(idx);
        if (element != null && element instanceof MemorySegment) {
            int offset;
            MemorySegment segment = (MemorySegment)((Object)element);
            BigInteger rowAddress = segment.getAddress();
            if (col > 0) {
                int addressableUnit = this.getAddressableUnitsPerColumn();
                offset = (col - 1) * addressableUnit;
            } else {
                offset = 0;
            }
            return rowAddress.add(BigInteger.valueOf(offset));
        }
        return null;
    }

    private int getAddressableUnitsPerColumn() {
        TableRenderingPresentationContext context;
        AsynchronousTableViewer viewer = this.getTableViewer();
        if (viewer.getPresentationContext() instanceof TableRenderingPresentationContext && (context = (TableRenderingPresentationContext)viewer.getPresentationContext()).getTableRendering() != null) {
            return context.getTableRendering().getAddressableUnitPerColumn();
        }
        return -1;
    }

    public void cache(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object obj = elements[i];
            if (obj instanceof MemorySegment) {
                this.cache(((MemorySegment)((Object)obj)).getAddress(), obj);
            }
            ++i;
        }
    }

    private void cache(Object key, Object element) {
        this.fCache.put(key, element);
        this.fOrderedCache.add(element);
    }

    public Object[] compare(Object[] newElements) {
        if (this.fCache.isEmpty()) {
            return newElements;
        }
        int j = 0;
        while (j < newElements.length) {
            MemorySegment newSegment;
            MemorySegment oldSegment;
            Object obj = newElements[j];
            if (obj instanceof MemorySegment && (oldSegment = (MemorySegment)((Object)this.fCache.get((newSegment = (MemorySegment)((Object)obj)).getAddress()))) != null && oldSegment.getNumAddressableUnits() == newSegment.getNumAddressableUnits()) {
                MemoryByte[] newBytes = newSegment.getBytes();
                MemoryByte[] oldBytes = oldSegment.getBytes();
                int i = 0;
                while (i < newBytes.length) {
                    newBytes[i].setHistoryKnown(true);
                    if (newBytes[i].getValue() != oldBytes[i].getValue()) {
                        newBytes[i].setChanged(true);
                    }
                    ++i;
                }
            }
            ++j;
        }
        return newElements;
    }

    public void clearCache() {
        this.fCache.clear();
        this.fOrderedCache.clear();
    }

    public boolean isEmpty() {
        return this.fCache.isEmpty();
    }

    public void handleViewerChanged() {
        this.rebuildCache();
        this.rebuildContent();
    }

    private void rebuildCache() {
        if (this.isEmpty()) {
            return;
        }
        ArrayList segments = new ArrayList();
        Enumeration enumeration = this.fOrderedCache.elements();
        BigInteger address = ((MemorySegment)((Object)this.fOrderedCache.get(0))).getAddress();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof MemorySegment)) continue;
            segments.add(element);
        }
        MemoryByte[] bytes = this.convertSegmentsToBytes(segments.toArray(new MemorySegment[0]));
        int bytesPerLine = -1;
        int numAddressableUnitPerLine = -1;
        if (this.getTableViewer().getPresentationContext() instanceof TableRenderingPresentationContext) {
            TableRenderingPresentationContext context = (TableRenderingPresentationContext)this.getTableViewer().getPresentationContext();
            AbstractAsyncTableRendering rendering = context.getTableRendering();
            bytesPerLine = rendering.getBytesPerLine();
            numAddressableUnitPerLine = rendering.getAddressableUnitPerLine();
        }
        this.clearCache();
        MemorySegment[] newSegments = this.convertMemoryBytesToSegments(address, bytes, bytesPerLine, numAddressableUnitPerLine);
        int i = 0;
        while (i < newSegments.length) {
            this.cache(newSegments[i].getAddress(), (Object)newSegments[i]);
            ++i;
        }
    }

    private void rebuildContent() {
        ArrayList<Object> segments = new ArrayList<Object>();
        Object[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof MemorySegment) {
                segments.add(element);
            }
            ++i;
        }
        MemoryByte[] bytes = this.convertSegmentsToBytes(segments.toArray(new MemorySegment[segments.size()]));
        int bytesPerLine = -1;
        int numAddressableUnitPerLine = -1;
        if (this.getTableViewer().getPresentationContext() instanceof TableRenderingPresentationContext) {
            TableRenderingPresentationContext context = (TableRenderingPresentationContext)this.getTableViewer().getPresentationContext();
            AbstractAsyncTableRendering rendering = context.getTableRendering();
            bytesPerLine = rendering.getBytesPerLine();
            numAddressableUnitPerLine = rendering.getAddressableUnitPerLine();
        }
        BigInteger address = (BigInteger)this.getKey(0);
        MemorySegment[] newSegments = this.convertMemoryBytesToSegments(address, bytes, bytesPerLine, numAddressableUnitPerLine);
        this.remove(this.getElements());
        this.add((Object[])newSegments);
    }

    private MemoryByte[] convertSegmentsToBytes(MemorySegment[] segments) {
        ArrayList<MemoryByte> toReturn = new ArrayList<MemoryByte>();
        int i = 0;
        while (i < segments.length) {
            MemoryByte[] temp = segments[i].getBytes();
            int j = 0;
            while (j < temp.length) {
                toReturn.add(temp[j]);
                ++j;
            }
            ++i;
        }
        return toReturn.toArray(new MemoryByte[0]);
    }

    private MemorySegment[] convertMemoryBytesToSegments(BigInteger address, MemoryByte[] bytes, int bytesPerLine, int numAddressableUnitPerLine) {
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>();
        if (bytesPerLine > 0 && numAddressableUnitPerLine > 0) {
            int idx = 0;
            while (idx < bytes.length && idx + bytesPerLine < bytes.length) {
                MemoryByte[] newBytes = new MemoryByte[bytesPerLine];
                System.arraycopy(bytes, idx, newBytes, 0, bytesPerLine);
                MemorySegment segment = new MemorySegment(address, newBytes, numAddressableUnitPerLine);
                segments.add(segment);
                address = address.add(BigInteger.valueOf(bytesPerLine));
                idx += bytesPerLine;
            }
        }
        return segments.toArray(new MemorySegment[segments.size()]);
    }
}

