/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class TableRenderingPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        if (this.getElement() instanceof AbstractBaseTableRendering) {
            AbstractBaseTableRendering rendering = (AbstractBaseTableRendering)this.getElement();
            GridLayout compositeLayout = new GridLayout();
            compositeLayout.numColumns = 2;
            compositeLayout.makeColumnsEqualWidth = false;
            composite.setLayout((Layout)compositeLayout);
            GridData comositeSpec = new GridData();
            comositeSpec.grabExcessVerticalSpace = true;
            comositeSpec.grabExcessHorizontalSpace = true;
            comositeSpec.horizontalAlignment = 4;
            comositeSpec.verticalAlignment = 2;
            composite.setLayoutData((Object)comositeSpec);
            String label = rendering.getLabel();
            if (label.startsWith("&&")) {
                label = label.replaceFirst("&&", "&");
            }
            this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_1, label);
            MemoryByte[] bytes = rendering.getSelectedAsBytes();
            if (bytes.length > 0) {
                boolean isChanged;
                if (rendering.getSelectedAddress() != null) {
                    String selectedAddress = "0x" + rendering.getSelectedAddress().toString(16).toUpperCase();
                    StringBuffer content = new StringBuffer(selectedAddress);
                    this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_2, content.toString());
                }
                String length = String.valueOf(String.valueOf(rendering.getAddressableUnitPerColumn())) + " " + DebugUIMessages.TableRenderingPropertiesPage_3;
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_4, length);
                String selectedContent = rendering.getSelectedAsString();
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_5, selectedContent);
                int addressableSize = rendering.getAddressableSize() * 8;
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_6, String.valueOf(String.valueOf(addressableSize)) + " " + DebugUIMessages.TableRenderingPropertiesPage_8);
                boolean endianessKnown = bytes[0].isEndianessKnown();
                int endianess = 2;
                if (endianessKnown) {
                    endianess = bytes[0].isBigEndian() ? 1 : 0;
                }
                boolean allBytesKnown = bytes[0].isHistoryKnown();
                boolean allBytesUnchanged = !bytes[0].isChanged();
                boolean allBytesReadable = bytes[0].isReadable();
                boolean allBytesWritable = bytes[0].isWritable();
                if (bytes.length > 1) {
                    int i = 1;
                    while (i < bytes.length) {
                        if (endianessKnown) {
                            int byteEndianess;
                            int n = byteEndianess = bytes[i].isBigEndian() ? 1 : 0;
                            if (endianess != 2 && endianess != byteEndianess) {
                                endianess = 2;
                            }
                        }
                        if (!bytes[i].isHistoryKnown()) {
                            allBytesKnown = false;
                        }
                        if (bytes[i].isChanged()) {
                            allBytesUnchanged = false;
                        }
                        if (!bytes[i].isReadable()) {
                            allBytesReadable = false;
                        }
                        if (!bytes[i].isWritable()) {
                            allBytesWritable = false;
                        }
                        ++i;
                    }
                }
                boolean bl = isChanged = allBytesKnown && !allBytesUnchanged;
                if (allBytesKnown) {
                    this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_9, String.valueOf(isChanged));
                } else {
                    this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_10, DebugUIMessages.TableRenderingPropertiesPage_11);
                }
                String dataEndian = DebugUIMessages.TableRenderingPropertiesPage_12;
                if (endianessKnown) {
                    dataEndian = endianess == 1 ? DebugUIMessages.TableRenderingPropertiesPage_13 : (endianess == 0 ? DebugUIMessages.TableRenderingPropertiesPage_14 : DebugUIMessages.TableRenderingPropertiesPage_15);
                }
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_16, dataEndian);
                if (rendering instanceof AbstractIntegerRendering) {
                    AbstractIntegerRendering intRendering = (AbstractIntegerRendering)rendering;
                    String displayEndian = DebugUIMessages.TableRenderingPropertiesPage_17;
                    endianess = intRendering.getDisplayEndianess();
                    displayEndian = endianess == 1 ? DebugUIMessages.TableRenderingPropertiesPage_18 : (endianess == 0 ? DebugUIMessages.TableRenderingPropertiesPage_19 : (endianessKnown ? dataEndian : DebugUIMessages.TableRenderingPropertiesPage_20));
                    this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_21, displayEndian);
                }
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_22, String.valueOf(allBytesReadable));
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_23, String.valueOf(allBytesWritable));
            } else {
                String selectedAddress = "0x" + rendering.getSelectedAddress().toString(16).toUpperCase();
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_25, selectedAddress);
                int unitsPerLine = rendering.getAddressableUnitPerLine();
                this.addProperty(composite, DebugUIMessages.TableRenderingPropertiesPage_26, String.valueOf(unitsPerLine));
            }
        }
        return composite;
    }

    private void addProperty(Composite composite, String labelStr, String contentStr) {
        Label label = new Label(composite, 0);
        label.setText(labelStr);
        Label text = new Label(composite, 64);
        text.setText(contentStr);
    }
}

