/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.*;

public class CVSHistoryFilterAction extends Action {
	private TableViewer viewer;
	private CVSHistoryFilter filter;
	private CVSHistoryPage page;

	public CVSHistoryFilterAction(CVSHistoryPage page) {
		this.page = page;
	}

	/**
	 * @see IViewActionDelegate#init(IViewPart)
	 */
	public void init(TableViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run() {
		CVSHistoryFilterDialog historyDialog = new CVSHistoryFilterDialog(viewer.getControl().getShell());
		if (filter != null) {
			historyDialog.setFilter(filter);
		}
		if (historyDialog.open() == Window.CANCEL) {
			return;
		}
		if (filter != null) {
			viewer.removeFilter(filter);
		}
		filter = historyDialog.getFilter();
		/*//don't add the filter if it is blank
		 if (!(filter.hasAuthor() || filter.hasDate() || filter.hasComment())) {
		 return;
		 }*/
		viewer.addFilter(filter);

		page.setSorter(filter.showLocal());
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}
}
