/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

public class ScopeAnalyzer {
    public static final int METHODS = 1;
    public static final int VARIABLES = 2;
    public static final int TYPES = 4;
    public static final int CHECK_VISIBILITY = 16;
    private ArrayList fRequestor = new ArrayList();
    private HashSet fNamesAdded = new HashSet();
    private HashSet fTypesVisited = new HashSet();
    private CompilationUnit fRoot;

    public ScopeAnalyzer(CompilationUnit root) {
        this.fRoot = root;
    }

    protected void addResult(IBinding binding) {
        String signature = ScopeAnalyzer.getSignature(binding);
        if (signature != null && this.fNamesAdded.add(signature)) {
            this.fRequestor.add(binding);
        }
    }

    private void clearLists() {
        this.fRequestor.clear();
        this.fNamesAdded.clear();
        this.fTypesVisited.clear();
    }

    private static String getSignature(IBinding binding) {
        if (binding != null) {
            switch (binding.getKind()) {
                case 4: {
                    StringBuffer buf = new StringBuffer();
                    buf.append('M');
                    buf.append(binding.getName()).append('(');
                    ITypeBinding[] parameters = ((IMethodBinding)binding).getParameterTypes();
                    int i = 0;
                    while (i < parameters.length) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        ITypeBinding paramType = parameters[i].getErasure();
                        buf.append(paramType.getQualifiedName());
                        ++i;
                    }
                    buf.append(')');
                    return buf.toString();
                }
                case 3: {
                    return String.valueOf('V') + binding.getName();
                }
                case 2: {
                    return String.valueOf('T') + binding.getName();
                }
            }
        }
        return null;
    }

    static final boolean hasFlag(int property, int flags) {
        return (flags & property) != 0;
    }

    private void addInherited(ITypeBinding binding, int flags) {
        ITypeBinding superClass;
        IMethodBinding curr;
        int i;
        if (!this.fTypesVisited.add(binding)) {
            return;
        }
        if (ScopeAnalyzer.hasFlag(2, flags)) {
            IVariableBinding[] variableBindings = binding.getDeclaredFields();
            i = 0;
            while (i < variableBindings.length) {
                this.addResult((IBinding)variableBindings[i]);
                ++i;
            }
        }
        if (ScopeAnalyzer.hasFlag(1, flags)) {
            IMethodBinding[] methodBindings = binding.getDeclaredMethods();
            i = 0;
            while (i < methodBindings.length) {
                curr = methodBindings[i];
                if (!curr.isSynthetic() && !curr.isConstructor()) {
                    this.addResult((IBinding)curr);
                }
                ++i;
            }
        }
        if (ScopeAnalyzer.hasFlag(4, flags)) {
            ITypeBinding[] typeBindings = binding.getDeclaredTypes();
            i = 0;
            while (i < typeBindings.length) {
                curr = typeBindings[i];
                this.addResult((IBinding)curr);
                ++i;
            }
        }
        if ((superClass = binding.getSuperclass()) != null) {
            this.addInherited(superClass, flags);
        } else if (binding.isArray()) {
            this.addInherited(this.fRoot.getAST().resolveWellKnownType("java.lang.Object"), flags);
        }
        ITypeBinding[] interfaces = binding.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            this.addInherited(interfaces[i2], flags);
            ++i2;
        }
    }

    private void addTypeDeclarations(ITypeBinding binding, int flags) {
        if (ScopeAnalyzer.hasFlag(4, flags) && !binding.isAnonymous()) {
            this.addResult((IBinding)binding);
            ITypeBinding[] typeParameters = binding.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                this.addResult((IBinding)typeParameters[i]);
                ++i;
            }
        }
        this.addInherited(binding, flags);
        if (binding.isLocal()) {
            this.addOuterDeclarationsForLocalType(binding, flags);
        } else {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass != null) {
                this.addTypeDeclarations(declaringClass, flags);
            } else if (ScopeAnalyzer.hasFlag(4, flags) && this.fRoot.findDeclaringNode((IBinding)binding) != null) {
                List types = this.fRoot.types();
                int i = 0;
                while (i < types.size()) {
                    this.addResult((IBinding)((AbstractTypeDeclaration)types.get(i)).resolveBinding());
                    ++i;
                }
            }
        }
    }

    private void addOuterDeclarationsForLocalType(ITypeBinding localBinding, int flags) {
        ASTNode node = this.fRoot.findDeclaringNode((IBinding)localBinding);
        if (node == null) {
            return;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
            this.addLocalDeclarations(node.getParent(), flags);
            ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType(node.getParent());
            if (parentTypeBinding != null) {
                this.addTypeDeclarations(parentTypeBinding, flags);
            }
        }
    }

    private static ITypeBinding getBinding(Expression node) {
        if (node != null) {
            return node.resolveTypeBinding();
        }
        return null;
    }

    private static ITypeBinding getQualifier(SimpleName selector) {
        ASTNode normalizedNode;
        ASTNode parent = selector.getParent();
        switch (parent.getNodeType()) {
            case 32: {
                MethodInvocation decl = (MethodInvocation)parent;
                if (selector == decl.getName()) {
                    return ScopeAnalyzer.getBinding(decl.getExpression());
                }
                return null;
            }
            case 40: {
                QualifiedName qualifiedName = (QualifiedName)parent;
                if (selector == qualifiedName.getName()) {
                    return ScopeAnalyzer.getBinding((Expression)qualifiedName.getQualifier());
                }
                return null;
            }
            case 22: {
                FieldAccess fieldAccess = (FieldAccess)parent;
                if (selector == fieldAccess.getName()) {
                    return ScopeAnalyzer.getBinding(fieldAccess.getExpression());
                }
                return null;
            }
            case 47: 
            case 48: {
                ITypeBinding curr = Bindings.getBindingOfParentType(parent);
                return curr.getSuperclass();
            }
        }
        if (parent instanceof Type && (normalizedNode = ASTNodes.getNormalizedNode(parent)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)normalizedNode.getParent();
            return ScopeAnalyzer.getBinding(creation.getExpression());
        }
        return null;
    }

    public IBinding[] getDeclarationsInScope(SimpleName selector, int flags) {
        block7: {
            try {
                ITypeBinding binding;
                if (selector.getLocationInParent() != SwitchCase.EXPRESSION_PROPERTY || (binding = ((SwitchStatement)selector.getParent().getParent()).getExpression().resolveTypeBinding()) == null || !binding.isEnum()) break block7;
                IVariableBinding[] iVariableBindingArray = this.getEnumContants(binding);
                Object var5_6 = null;
                this.clearLists();
                return iVariableBindingArray;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.clearLists();
                throw throwable;
            }
        }
        ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType((ASTNode)selector);
        if (parentTypeBinding != null) {
            ITypeBinding binding = ScopeAnalyzer.getQualifier(selector);
            if (binding == null && parentTypeBinding != null) {
                this.addLocalDeclarations((ASTNode)selector, flags);
                this.addTypeDeclarations(parentTypeBinding, flags);
            } else {
                this.addInherited(binding, flags);
            }
            if (ScopeAnalyzer.hasFlag(16, flags)) {
                this.filterNonVisible(parentTypeBinding);
            }
        }
        IBinding[] iBindingArray = this.fRequestor.toArray(new IBinding[this.fRequestor.size()]);
        Object var5_7 = null;
        this.clearLists();
        return iBindingArray;
    }

    private IVariableBinding[] getEnumContants(ITypeBinding binding) {
        IVariableBinding[] declaredFields = binding.getDeclaredFields();
        ArrayList<IVariableBinding> res = new ArrayList<IVariableBinding>(declaredFields.length);
        int i = 0;
        while (i < declaredFields.length) {
            IVariableBinding curr = declaredFields[i];
            if (curr.isEnumConstant()) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new IVariableBinding[res.size()]);
    }

    public IBinding[] getDeclarationsInScope(int offset, int flags) {
        NodeFinder finder = new NodeFinder(offset, 0);
        this.fRoot.accept((ASTVisitor)finder);
        ASTNode node = finder.getCoveringNode();
        if (node == null) {
            return null;
        }
        if (node instanceof SimpleName) {
            return this.getDeclarationsInScope((SimpleName)node, flags);
        }
        try {
            this.addLocalDeclarations(node, offset, flags);
            ITypeBinding binding = Bindings.getBindingOfParentType(node);
            if (binding != null) {
                this.addTypeDeclarations(binding, flags);
            }
            if (ScopeAnalyzer.hasFlag(16, flags)) {
                this.filterNonVisible(binding);
            }
            IBinding[] iBindingArray = this.fRequestor.toArray(new IBinding[this.fRequestor.size()]);
            Object var6_7 = null;
            this.clearLists();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.clearLists();
            throw throwable;
        }
    }

    private void filterNonVisible(ITypeBinding binding) {
        int i = this.fRequestor.size() - 1;
        while (i >= 0) {
            if (!ScopeAnalyzer.isVisible((IBinding)this.fRequestor.get(i), binding)) {
                this.fRequestor.remove(i);
            }
            --i;
        }
    }

    private static ITypeBinding getDeclaringType(IBinding binding) {
        switch (binding.getKind()) {
            case 3: {
                return ((IVariableBinding)binding).getDeclaringClass();
            }
            case 4: {
                return ((IMethodBinding)binding).getDeclaringClass();
            }
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.getDeclaringClass() != null) {
                    return typeBinding;
                }
                return typeBinding;
            }
        }
        return null;
    }

    public static boolean isVisible(IBinding binding, ITypeBinding context) {
        if (binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
            return true;
        }
        ITypeBinding declaring = ScopeAnalyzer.getDeclaringType(binding);
        if (declaring == null) {
            return false;
        }
        int modifiers = binding.getModifiers();
        if (Modifier.isPublic((int)modifiers) || declaring.isInterface()) {
            return true;
        }
        if (Modifier.isProtected((int)modifiers) || !Modifier.isPrivate((int)modifiers)) {
            if (declaring.getPackage() == context.getPackage()) {
                return true;
            }
            return ScopeAnalyzer.isTypeInScope(declaring, context, Modifier.isProtected((int)modifiers));
        }
        return ScopeAnalyzer.isTypeInScope(declaring, context, false);
    }

    private static boolean isTypeInScope(ITypeBinding declaring, ITypeBinding context, boolean includeHierarchy) {
        ITypeBinding curr = context;
        while (curr != null && curr != declaring) {
            if (includeHierarchy && Bindings.isSuperType(declaring, curr)) {
                return true;
            }
            curr = curr.getDeclaringClass();
        }
        return curr == declaring;
    }

    public IBinding[] getDeclarationsAfter(int offset, int flags) {
        ASTNode node;
        block5: {
            NodeFinder finder = new NodeFinder(offset, 0);
            this.fRoot.accept((ASTVisitor)finder);
            node = finder.getCoveringNode();
            if (node != null) break block5;
            IBinding[] iBindingArray = null;
            Object var7_7 = null;
            this.clearLists();
            return iBindingArray;
        }
        try {
            Statement declaration = ASTResolving.findParentStatement(node);
            while (declaration instanceof Statement && declaration.getNodeType() != 8) {
                declaration = declaration.getParent();
            }
            if (declaration instanceof Block) {
                DeclarationsAfterVisitor visitor = new DeclarationsAfterVisitor(node.getStartPosition(), flags);
                declaration.accept((ASTVisitor)visitor);
            }
            IBinding[] iBindingArray = this.fRequestor.toArray(new IBinding[this.fRequestor.size()]);
            Object var7_8 = null;
            this.clearLists();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.clearLists();
            throw throwable;
        }
    }

    private void addLocalDeclarations(ASTNode node, int flags) {
        this.addLocalDeclarations(node, node.getStartPosition(), flags);
    }

    private void addLocalDeclarations(ASTNode node, int offset, int flags) {
        BodyDeclaration declaration;
        if ((ScopeAnalyzer.hasFlag(2, flags) || ScopeAnalyzer.hasFlag(4, flags)) && ((declaration = ASTResolving.findParentBodyDeclaration(node)) instanceof MethodDeclaration || declaration instanceof Initializer)) {
            ScopeAnalyzerVisitor visitor = new ScopeAnalyzerVisitor(offset, flags);
            declaration.accept((ASTVisitor)visitor);
        }
    }

    private class ScopeAnalyzerVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private int fFlags;

        public ScopeAnalyzerVisitor(int position, int flags) {
            this.fPosition = position;
            this.fFlags = flags;
        }

        private boolean isInside(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            return start <= this.fPosition && this.fPosition < end;
        }

        public boolean visit(MethodDeclaration node) {
            if (this.isInside((ASTNode)node)) {
                Block body = node.getBody();
                if (body != null) {
                    body.accept((ASTVisitor)this);
                }
                this.visitBackwards(node.parameters());
                if (node.getAST().apiLevel() >= 3) {
                    this.visitBackwards(node.typeParameters());
                }
            }
            return false;
        }

        public boolean visit(TypeParameter node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && node.getStartPosition() < this.fPosition) {
                ScopeAnalyzer.this.addResult(node.getName().resolveBinding());
            }
            return true;
        }

        public boolean visit(SwitchCase node) {
            SwitchStatement switchStatement;
            ITypeBinding binding;
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && !node.isDefault() && this.isInside((ASTNode)node.getExpression()) && (binding = (switchStatement = (SwitchStatement)node.getParent()).getExpression().resolveTypeBinding()) != null && binding.isEnum()) {
                IVariableBinding[] declaredFields = binding.getDeclaredFields();
                int i = 0;
                while (i < declaredFields.length) {
                    IVariableBinding curr = declaredFields[i];
                    if (curr.isEnumConstant()) {
                        ScopeAnalyzer.this.addResult((IBinding)curr);
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean visit(Initializer node) {
            return this.isInside((ASTNode)node);
        }

        public boolean visit(Statement node) {
            return this.isInside((ASTNode)node);
        }

        public boolean visit(ASTNode node) {
            return false;
        }

        public boolean visit(Block node) {
            if (this.isInside((ASTNode)node)) {
                this.visitBackwards(node.statements());
            }
            return false;
        }

        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && node.getStartPosition() < this.fPosition) {
                ScopeAnalyzer.this.addResult((IBinding)node.resolveBinding());
            }
            return true;
        }

        public boolean visit(VariableDeclarationStatement node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        public boolean visit(CatchClause node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                node.getException().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ForStatement node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                this.visitBackwards(node.initializers());
            }
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && node.getStartPosition() + node.getLength() < this.fPosition) {
                if (node.getAST().apiLevel() == 2) {
                    ScopeAnalyzer.this.addResult((IBinding)node.getTypeDeclaration().resolveBinding());
                } else {
                    ScopeAnalyzer.this.addResult(node.getDeclaration().getName().resolveBinding());
                }
                return false;
            }
            return this.isInside((ASTNode)node);
        }

        private void visitBackwards(List list) {
            int i = list.size() - 1;
            while (i >= 0) {
                ASTNode curr = (ASTNode)list.get(i);
                if (curr.getStartPosition() < this.fPosition) {
                    curr.accept((ASTVisitor)this);
                }
                --i;
            }
        }
    }

    private class DeclarationsAfterVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private int fFlags;

        public DeclarationsAfterVisitor(int position, int flags) {
            this.fPosition = position;
            this.fFlags = flags;
        }

        public boolean visit(ASTNode node) {
            return true;
        }

        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && this.fPosition < node.getStartPosition()) {
                ScopeAnalyzer.this.addResult((IBinding)node.resolveBinding());
            }
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && this.fPosition < node.getStartPosition()) {
                if (node.getAST().apiLevel() == 2) {
                    ScopeAnalyzer.this.addResult((IBinding)node.getTypeDeclaration().resolveBinding());
                } else {
                    ScopeAnalyzer.this.addResult(node.getDeclaration().getName().resolveBinding());
                }
            }
            return false;
        }
    }
}

