/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;

class AccessorClassCreator {
    private final ICompilationUnit fCu;
    private final String fAccessorClassName;
    private final IPath fAccessorPath;
    private final IPath fResourceBundlePath;
    private final IPackageFragment fAccessorPackage;
    private final boolean fIsEclipseNLS;
    private final NLSSubstitution[] fNLSSubstitutions;

    private AccessorClassCreator(ICompilationUnit cu, String accessorClassname, IPath accessorPath, IPackageFragment accessorPackage, IPath resourceBundlePath, boolean isEclipseNLS, NLSSubstitution[] nlsSubstitutions) {
        this.fCu = cu;
        this.fAccessorClassName = accessorClassname;
        this.fAccessorPath = accessorPath;
        this.fAccessorPackage = accessorPackage;
        this.fResourceBundlePath = resourceBundlePath;
        this.fIsEclipseNLS = isEclipseNLS;
        this.fNLSSubstitutions = nlsSubstitutions;
    }

    public static Change create(ICompilationUnit cu, String accessorClassname, IPath accessorPath, IPackageFragment accessorPackage, IPath resourceBundlePath, boolean isEclipseNLS, NLSSubstitution[] nlsSubstitutions, IProgressMonitor pm) throws CoreException {
        AccessorClassCreator accessorClass = new AccessorClassCreator(cu, accessorClassname, accessorPath, accessorPackage, resourceBundlePath, isEclipseNLS, nlsSubstitutions);
        return new CreateTextFileChange(accessorPath, accessorClass.createAccessorCUSource(pm), null, "java");
    }

    private String createAccessorCUSource(IProgressMonitor pm) throws CoreException {
        IProject project = AccessorClassCreator.getFileHandle(this.fAccessorPath).getProject();
        String lineDelimiter = StubUtility.getLineDelimiterPreference(project);
        return CodeFormatterUtil.format(8, this.getUnformattedSource(pm), 0, null, lineDelimiter, this.fCu.getJavaProject());
    }

    private static IFile getFileHandle(IPath filePath) {
        if (filePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    private String getUnformattedSource(IProgressMonitor pm) throws CoreException {
        String string;
        block7: {
            ICompilationUnit newCu = null;
            try {
                String classContent;
                String cuContent;
                newCu = WorkingCopyUtil.getNewWorkingCopy(this.fAccessorPackage, this.fAccessorPath.lastSegment());
                String typeComment = null;
                String fileComment = null;
                IJavaProject project = newCu.getJavaProject();
                String lineDelim = StubUtility.getLineDelimiterUsed(project);
                if (StubUtility.doAddComments(project)) {
                    typeComment = CodeGeneration.getTypeComment(newCu, this.fAccessorClassName, lineDelim);
                    fileComment = CodeGeneration.getFileComment(newCu, lineDelim);
                }
                if ((cuContent = CodeGeneration.getCompilationUnitContent(newCu, fileComment, typeComment, classContent = this.createClass(lineDelim), lineDelim)) == null) {
                    StringBuffer buf = new StringBuffer();
                    if (fileComment != null) {
                        buf.append(fileComment).append(lineDelim);
                    }
                    if (!this.fAccessorPackage.isDefaultPackage()) {
                        buf.append("package ").append(this.fAccessorPackage.getElementName()).append(';');
                    }
                    buf.append(lineDelim).append(lineDelim);
                    if (typeComment != null) {
                        buf.append(typeComment).append(lineDelim);
                    }
                    buf.append(classContent);
                    cuContent = buf.toString();
                }
                newCu.getBuffer().setContents(cuContent);
                this.addImportsToAccessorCu(newCu, pm);
                string = newCu.getSource();
                Object var10_11 = null;
                if (newCu == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var10_12 = null;
                    if (newCu == null) break block8;
                    newCu.discardWorkingCopy();
                }
                throw throwable;
            }
            newCu.discardWorkingCopy();
        }
        return string;
    }

    private void addImportsToAccessorCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        ImportRewrite is = StubUtility.createImportRewrite(newCu, true);
        if (this.fIsEclipseNLS) {
            is.addImport("org.eclipse.osgi.util.NLS");
        } else {
            is.addImport("java.util.MissingResourceException");
            is.addImport("java.util.ResourceBundle");
        }
        TextEdit edit = is.rewriteImports(pm);
        JavaModelUtil.applyEdit(newCu, edit, false, null);
    }

    private String createClass(String lineDelim) throws CoreException {
        if (this.fIsEclipseNLS) {
            return "public class " + this.fAccessorClassName + " extends NLS {" + "private static final String " + "BUNDLE_NAME" + " = \"" + this.getResourceBundleName() + "\"; " + NLSElement.createTagText(1) + lineDelim + this.createConstructor(lineDelim) + lineDelim + this.createStaticInitializer(lineDelim) + lineDelim + this.createStaticFields(lineDelim) + lineDelim + "}" + lineDelim;
        }
        return "public class " + this.fAccessorClassName + " {" + "private static final String " + "BUNDLE_NAME" + " = \"" + this.getResourceBundleName() + "\"; " + NLSElement.createTagText(1) + lineDelim + lineDelim + "private static final ResourceBundle " + this.getResourceBundleConstantName() + "= ResourceBundle.getBundle(" + "BUNDLE_NAME" + ");" + lineDelim + lineDelim + this.createConstructor(lineDelim) + lineDelim + this.createGetStringMethod(lineDelim) + lineDelim + "}" + lineDelim;
    }

    private String getResourceBundleConstantName() {
        return "RESOURCE_BUNDLE";
    }

    private String createStaticFields(String lineDelim) {
        StringBuffer buf = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i < this.fNLSSubstitutions.length) {
            NLSSubstitution substitution = this.fNLSSubstitutions[i];
            int newState = substitution.getState();
            if (substitution.hasStateChanged() && newState == 0 && substitution.getInitialState() == 2) {
                if (count > 0) {
                    buf.append(lineDelim);
                }
                this.appendStaticField(buf, substitution);
            }
            ++i;
        }
        return buf.toString();
    }

    private void appendStaticField(StringBuffer buf, NLSSubstitution substitution) {
        buf.append("public static String ");
        buf.append(substitution.getKey());
        buf.append(';');
    }

    private String createGetStringMethod(String lineDelim) throws CoreException {
        String bodyStatement = "try {" + lineDelim + "return " + this.getResourceBundleConstantName() + ".getString(key);" + lineDelim + "} catch (MissingResourceException e) {" + lineDelim + "return '!' + key + '!';" + lineDelim + "}";
        String methodBody = CodeGeneration.getMethodBodyContent(this.fCu, this.fAccessorClassName, "getString", false, bodyStatement, lineDelim);
        if (methodBody == null) {
            methodBody = "";
        }
        return "public static String getString(String key) {" + lineDelim + methodBody + lineDelim + '}';
    }

    private String createStaticInitializer(String lineDelim) throws CoreException {
        return "static {" + lineDelim + "// initialize resource bundle" + lineDelim + "NLS.initializeMessages(BUNDLE_NAME, " + this.fAccessorClassName + ".class);" + lineDelim + "}";
    }

    private String createConstructor(String lineDelim) {
        return "private " + this.fAccessorClassName + "(){" + lineDelim + '}';
    }

    private String getPropertyFileName() {
        return this.fResourceBundlePath.lastSegment();
    }

    private String getPropertyFileNameWithoutExtension() {
        String fileName = this.getPropertyFileName();
        return fileName.substring(0, fileName.indexOf(".properties"));
    }

    private String getResourceBundleName() throws CoreException {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourceBundlePath.removeLastSegments(1));
        if (res != null && res.exists()) {
            IJavaElement el = JavaCore.create((IResource)res);
            if (el instanceof IPackageFragment) {
                IPackageFragment p = (IPackageFragment)el;
                return String.valueOf(p.getElementName()) + '.' + this.getPropertyFileNameWithoutExtension();
            }
            if (el instanceof IPackageFragmentRoot || el instanceof IJavaProject) {
                return this.getPropertyFileNameWithoutExtension();
            }
        }
        throw new CoreException((IStatus)new StatusInfo(4, "Resourcebundle not specified"));
    }
}

