/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CreateFileChange
extends JDTChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;

    public CreateFileChange(IPath path, String source, String encoding) {
        this(path, source, encoding, -1L);
    }

    public CreateFileChange(IPath path, String source, String encoding, long stampToRestore) {
        Assert.isNotNull(path, "path");
        Assert.isNotNull(source, "source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull(encoding, "encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        if (this.fChangeName == null) {
            return String.valueOf(NLSChangesMessages.createFile_Create_file) + this.fPath.toString();
        }
        return this.fChangeName;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected String getSource() {
        return this.fSource;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_unknownLocation, file.getFullPath().toString()));
            return result;
        }
        IFileInfo jFile = EFS.getStore((URI)location).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_exists, file.getFullPath().toString()));
            return result;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        InputStream is = null;
        try {
            pm.beginTask(NLSChangesMessages.createFile_creating_resource, 3);
            this.initializeEncoding();
            IFile file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
            try {
                is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                file.create(is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (this.fStampToRestore != -1L) {
                    file.revertModificationStamp(this.fStampToRestore);
                }
                if (this.fExplicitEncoding) {
                    file.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
                DeleteFileChange deleteFileChange = new DeleteFileChange(file);
                Object var5_5 = null;
                try {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException((Throwable)ioe, 985);
                    }
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return deleteFileChange;
            }
            catch (UnsupportedEncodingException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                pm.done();
                throw throwable2;
            }
            try {}
            catch (IOException ioe) {
                throw new JavaModelException((Throwable)ioe, 985);
            }
            if (is != null) {
                is.close();
            }
            Object var9_14 = null;
            pm.done();
            throw throwable;
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        IFile iFile;
        pm.beginTask("", 1);
        try {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iFile;
    }

    private void initializeEncoding() {
        block8: {
            if (this.fEncoding == null) {
                this.fExplicitEncoding = false;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
                if (file != null) {
                    try {
                        if (file.exists()) {
                            this.fEncoding = file.getCharset(false);
                            if (this.fEncoding == null) {
                                this.fEncoding = file.getCharset(true);
                            } else {
                                this.fExplicitEncoding = true;
                            }
                            break block8;
                        }
                        this.fEncoding = file.getCharset(true);
                    }
                    catch (CoreException coreException) {
                        this.fEncoding = ResourcesPlugin.getEncoding();
                        this.fExplicitEncoding = true;
                    }
                } else {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            }
        }
        Assert.isNotNull(this.fEncoding);
    }
}

