/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.GenericRefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.osgi.util.NLS;

public final class RenameEnumConstProcessor
extends RenameFieldProcessor {
    public static final String ID_RENAME_ENUM_CONSTANT = "org.eclipse.jdt.ui.rename.enum.constant";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameEnumConstProcessor";

    public RenameEnumConstProcessor(IField field) {
        super(field);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameEnumConstAvailable(this.getField());
    }

    public String canEnableGetterRenaming() throws CoreException {
        return "";
    }

    public String canEnableSetterRenaming() throws CoreException {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus result = Checks.checkEnumConstantName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.getField(), newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_another_name);
        }
        if (this.getField().getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_const_already_defined);
        }
        return result;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameEnumConstRefactoring_name, new String[]{this.getCurrentElementName(), this.getNewElementName()});
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        Object change = super.createChange(monitor);
        if (change != null) {
            CompositeChange composite = new CompositeChange("", new Change[]{change}){

                public final RefactoringDescriptor getRefactoringDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    IField field = RenameEnumConstProcessor.this.getField();
                    arguments.put("input", field.getHandleIdentifier());
                    arguments.put("name", RenameEnumConstProcessor.this.getNewElementName());
                    arguments.put("references", Boolean.valueOf(RenameEnumConstProcessor.this.fUpdateReferences).toString());
                    arguments.put("textual", Boolean.valueOf(RenameEnumConstProcessor.this.fUpdateTextualMatches).toString());
                    String project = null;
                    IJavaProject javaProject = field.getJavaProject();
                    if (javaProject != null) {
                        project = javaProject.getElementName();
                    }
                    int flags = 65538;
                    IType declaring = field.getDeclaringType();
                    try {
                        if (!Flags.isPrivate((int)declaring.getFlags())) {
                            flags |= 4;
                        }
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                    }
                    return new RefactoringDescriptor(RenameEnumConstProcessor.ID_RENAME_ENUM_CONSTANT, project, Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description, new String[]{field.getElementName(), JavaElementLabels.getElementLabel(field.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), RenameEnumConstProcessor.this.getNewElementName()}), RenameEnumConstProcessor.this.getComment(), arguments, flags);
                }
            };
            composite.markAsSynthetic();
            change = composite;
        }
        return change;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String matches;
        if (arguments instanceof GenericRefactoringArguments) {
            IJavaElement element;
            GenericRefactoringArguments generic = (GenericRefactoringArguments)arguments;
            String handle = generic.getAttribute("input");
            if (handle != null) {
                element = JavaCore.create((String)handle);
                if (element == null || !element.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_RENAME_ENUM_CONSTANT));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
            }
            this.fField = (IField)element;
            String name = generic.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
            }
            this.setNewElementName(name);
            String references = generic.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"references"));
            }
            this.setUpdateReferences(Boolean.valueOf(references));
            matches = generic.getAttribute("textual");
            if (matches == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"textual"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setUpdateTextualMatches(Boolean.valueOf(matches));
        return new RefactoringStatus();
    }
}

