/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.scripting;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringInstanceCreator;
import org.eclipse.ltk.core.refactoring.participants.GenericRefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.osgi.util.NLS;

public final class InlineMethodRefactoringInstanceCreator
extends RefactoringInstanceCreator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Refactoring createRefactoring(RefactoringDescriptor descriptor) throws CoreException {
        String handle;
        int selectionStart = -1;
        int selectionLength = -1;
        ICompilationUnit unit = null;
        CompilationUnit node = null;
        RefactoringArguments arguments = this.createArguments(descriptor);
        if (!(arguments instanceof GenericRefactoringArguments)) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments, null));
        GenericRefactoringArguments generic = (GenericRefactoringArguments)arguments;
        String selection = generic.getAttribute("selection");
        if (selection != null) {
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{selection, "selection"}), null));
            selectionStart = offset;
            selectionLength = length;
        }
        if ((handle = generic.getAttribute("input")) == null) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"), null));
        IJavaElement element = JavaCore.create((String)handle);
        if (element == null || !element.exists()) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)"org.eclipse.jdt.ui.inline.method"), null));
        }
        if (element instanceof ICompilationUnit) {
            unit = (ICompilationUnit)element;
            if (selection == null) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"selection"), null));
            }
        } else {
            if (!(element instanceof IMethod)) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{handle, "input"}), null));
            IMethod method = (IMethod)element;
            try {
                ISourceRange range = method.getNameRange();
                if (range == null) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{handle, "input"}), null));
                }
                selectionStart = range.getOffset();
                selectionLength = range.getLength();
            }
            catch (JavaModelException exception) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)"org.eclipse.jdt.ui.inline.method"), (Throwable)exception));
            }
            unit = method.getCompilationUnit();
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(unit);
        node = (CompilationUnit)parser.createAST(null);
        return InlineMethodRefactoring.create(unit, node, selectionStart, selectionLength);
    }
}

