/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;

public class TypeInfoFilter {
    private String fText;
    private IJavaSearchScope fSearchScope;
    private boolean fIsWorkspaceScope;
    private int fElementKind;
    private ITypeInfoFilterExtension fFilterExtension;
    private TypeInfo.TypeInfoAdapter fAdapter = new TypeInfo.TypeInfoAdapter();
    private PatternMatcher fPackageMatcher;
    private PatternMatcher fNameMatcher;
    private static final int TYPE_MODIFIERS = 25088;

    public TypeInfoFilter(String text, IJavaSearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
        this.fText = text;
        this.fSearchScope = scope;
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope());
        this.fElementKind = elementKind;
        this.fFilterExtension = extension;
        int index = text.lastIndexOf(".");
        if (index == -1) {
            this.fNameMatcher = new PatternMatcher(text, true);
        } else {
            this.fPackageMatcher = new PatternMatcher(text.substring(0, index), 2);
            String name = text.substring(index + 1);
            if (name.length() == 0) {
                name = "*";
            }
            this.fNameMatcher = new PatternMatcher(name, true);
        }
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        if (!this.fText.startsWith(text)) {
            return false;
        }
        return this.fText.indexOf(46, text.length()) == -1;
    }

    public boolean isCamcelCasePattern() {
        return this.fNameMatcher.getMatchKind() == 128;
    }

    public String getPackagePattern() {
        if (this.fPackageMatcher == null) {
            return null;
        }
        return this.fPackageMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        return this.fNameMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(TypeInfo type) {
        return Strings.startsWithIgnoreCase(type.getTypeName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(TypeInfo type) {
        if (!this.matchesPackage(type) || !this.matchesFilterExtension(type)) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesHistoryElement(TypeInfo type) {
        if (!(this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesFilterExtension(TypeInfo type) {
        if (this.fFilterExtension == null) {
            return true;
        }
        this.fAdapter.setInfo(type);
        return this.fFilterExtension.select(this.fAdapter);
    }

    private boolean matchesName(TypeInfo type) {
        return this.fNameMatcher.matches(type.getTypeName());
    }

    private boolean matchesPackage(TypeInfo type) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.matches(type.getPackageName());
    }

    private boolean matchesScope(TypeInfo type) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return type.isEnclosed(this.fSearchScope);
    }

    private boolean matchesModifiers(TypeInfo type) {
        if (this.fElementKind == 0) {
            return true;
        }
        int modifiers = type.getModifiers() & 0x6200;
        switch (this.fElementKind) {
            case 5: {
                return modifiers == 0;
            }
            case 8: {
                return Flags.isAnnotation((int)modifiers);
            }
            case 6: {
                return Flags.isInterface((int)modifiers);
            }
            case 7: {
                return Flags.isEnum((int)modifiers);
            }
            case 10: {
                return modifiers == 0 || Flags.isInterface((int)modifiers);
            }
            case 9: {
                return modifiers == 0 || Flags.isEnum((int)modifiers);
            }
        }
        return false;
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String pattern, boolean ignoreCase) {
            this(pattern, 131);
        }

        public PatternMatcher(String pattern, int allowedModes) {
            this.initializePatternAndMatchKind(pattern);
            this.fMatchKind &= allowedModes;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String text) {
            if (this.fMatchKind == 2) {
                return this.fStringMatcher.match(text);
            }
            if (this.fMatchKind == 128) {
                return SearchPattern.camelCaseMatch((String)this.fPattern, (String)text);
            }
            if (this.fMatchKind == 0) {
                return this.fPattern.equalsIgnoreCase(text);
            }
            return Strings.startsWithIgnoreCase(text, this.fPattern);
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.fMatchKind = 0;
                this.fPattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (last) {
                    case '<': {
                        this.fPattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case ' ': {
                        this.fPattern = pattern.trim();
                        break;
                    }
                    case '*': {
                        this.fPattern = pattern;
                        break;
                    }
                    default: {
                        this.fPattern = String.valueOf(pattern) + '*';
                    }
                }
                return;
            }
            if (last == '<') {
                this.fMatchKind = 0;
                this.fPattern = pattern.substring(0, length - 1);
                return;
            }
            if (last == ' ') {
                this.fMatchKind = 0;
                this.fPattern = pattern.trim();
                return;
            }
            if (SearchUtils.isCamelCasePattern(pattern)) {
                this.fMatchKind = 128;
                this.fPattern = pattern;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = pattern;
        }
    }
}

