/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ResourceBundle;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompoundEditExitStrategy;
import org.eclipse.jdt.internal.ui.javaeditor.ICompoundEditListener;
import org.eclipse.jdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class JavaMoveLinesAction
extends TextEditorAction {
    private final boolean fUpwards;
    private final boolean fCopy;
    private final SharedState fSharedState;
    static /* synthetic */ Class class$0;

    public static JavaMoveLinesAction[] createMoveCopyActionSet(ResourceBundle bundle, CompilationUnitEditor editor) {
        SharedState state = new SharedState(editor);
        JavaMoveLinesAction[] actions = new JavaMoveLinesAction[]{new JavaMoveLinesAction(bundle, "Editor.MoveLinesUp.", true, false, state), new JavaMoveLinesAction(bundle, "Editor.MoveLinesDown.", false, false, state), new JavaMoveLinesAction(bundle, "Editor.CopyLineUp.", true, true, state), new JavaMoveLinesAction(bundle, "Editor.CopyLineDown.", false, true, state)};
        return actions;
    }

    public void setEditor(ITextEditor editor) {
        Assert.isTrue((boolean)(editor instanceof CompilationUnitEditor));
        super.setEditor(editor);
        if (this.fSharedState != null) {
            this.fSharedState.fEditor = (CompilationUnitEditor)editor;
        }
    }

    private JavaMoveLinesAction(ResourceBundle bundle, String prefix, boolean upwards, boolean copy, SharedState state) {
        super(bundle, prefix, (ITextEditor)state.fEditor);
        this.fUpwards = upwards;
        this.fCopy = copy;
        this.fSharedState = state;
        this.update();
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ISourceViewer viewer) {
        int min = selection.getOffset();
        int max = min + selection.getLength();
        IDocument document = viewer.getDocument();
        IRegion visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
        int visOffset = visible.getOffset();
        try {
            int visEnd;
            if (visOffset > min) {
                if (document.getLineOfOffset(visOffset) != selection.getStartLine()) {
                    return false;
                }
                if (!this.isWhitespace(document.get(min, visOffset - min))) {
                    this.showStatus();
                    return false;
                }
            }
            if ((visEnd = visOffset + visible.getLength()) < max) {
                if (document.getLineOfOffset(visEnd) != selection.getEndLine()) {
                    return false;
                }
                if (!this.isWhitespace(document.get(visEnd, max - visEnd))) {
                    this.showStatus();
                    return false;
                }
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ISourceViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN < 0 || skippedLineN >= document.getNumberOfLines()) {
            return null;
        }
        try {
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runWithEvent(Event event) {
        block26: {
            block24: {
                if (this.fSharedState.fEditor == null) {
                    return;
                }
                if (!this.validateEditorInputState()) {
                    return;
                }
                ISourceViewer viewer = this.fSharedState.fEditor.getViewer();
                if (viewer == null) {
                    return;
                }
                IDocument document = viewer.getDocument();
                if (document == null) {
                    return;
                }
                StyledText widget = viewer.getTextWidget();
                if (widget == null) {
                    return;
                }
                Point p = viewer.getSelectedRange();
                if (p == null) {
                    return;
                }
                TextSelection sel = new TextSelection(document, p.x, p.y);
                ITextSelection skippedLine = this.getSkippedLine(document, (ITextSelection)sel);
                if (skippedLine == null) {
                    return;
                }
                try {
                    try {
                        int offset;
                        String insertion;
                        ITextSelection movingArea;
                        block28: {
                            block27: {
                                movingArea = this.getMovingSelection(document, (ITextSelection)sel, viewer);
                                if (!this.containedByVisibleRegion(movingArea, viewer)) break block27;
                                if (this.containedByVisibleRegion(skippedLine, viewer)) break block28;
                            }
                            Object var18_9 = null;
                            this.fSharedState.fIsChanging = false;
                            if (!this.fCopy) return;
                            this.fSharedState.endCompoundEdit();
                            return;
                        }
                        String moving = movingArea.getText();
                        String skipped = skippedLine.getText();
                        if (moving == null) break block24;
                        if (skipped == null) {
                            break block24;
                        }
                        if (this.fUpwards) {
                            String delim = document.getLineDelimiter(skippedLine.getEndLine());
                            Assert.isNotNull((Object)delim);
                            if (this.fCopy) {
                                insertion = String.valueOf(moving) + delim;
                                offset = movingArea.getOffset();
                            } else {
                                insertion = String.valueOf(moving) + delim + skipped;
                                offset = skippedLine.getOffset();
                            }
                        } else {
                            String delim = document.getLineDelimiter(movingArea.getEndLine());
                            Assert.isNotNull((Object)delim);
                            if (this.fCopy) {
                                insertion = String.valueOf(moving) + delim;
                                offset = skippedLine.getOffset();
                            } else {
                                insertion = String.valueOf(skipped) + delim + moving;
                                offset = movingArea.getOffset();
                            }
                        }
                        int lenght = this.fCopy ? 0 : insertion.length();
                        ILineRange selectionBefore = this.getLineRange(document, movingArea);
                        if (this.fCopy) {
                            this.fSharedState.endCompoundEdit();
                        }
                        this.fSharedState.beginCompoundEdit();
                        this.fSharedState.fIsChanging = true;
                        widget.setCaretOffset(0);
                        document.replace(offset, lenght, insertion);
                        Object selectionAfter = this.fUpwards && this.fCopy ? selectionBefore : (this.fUpwards ? new LineRange(selectionBefore.getStartLine() - 1, selectionBefore.getNumberOfLines()) : (this.fCopy ? new LineRange(selectionBefore.getStartLine() + selectionBefore.getNumberOfLines(), selectionBefore.getNumberOfLines()) : new LineRange(selectionBefore.getStartLine() + 1, selectionBefore.getNumberOfLines())));
                        this.fSharedState.fResult = IndentUtil.indentLines(document, selectionAfter, this.getProject(), this.fSharedState.fResult);
                        IRegion region = this.getRegion(document, (ILineRange)selectionAfter);
                        this.selectAndReveal((ITextViewer)viewer, region.getOffset(), region.getLength());
                        break block26;
                    }
                    catch (BadLocationException badLocationException) {
                        Object var18_11 = null;
                        this.fSharedState.fIsChanging = false;
                        if (!this.fCopy) return;
                        this.fSharedState.endCompoundEdit();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_12 = null;
                    this.fSharedState.fIsChanging = false;
                    if (!this.fCopy) throw throwable;
                    this.fSharedState.endCompoundEdit();
                    throw throwable;
                }
            }
            Object var18_10 = null;
            this.fSharedState.fIsChanging = false;
            if (!this.fCopy) return;
            this.fSharedState.endCompoundEdit();
            return;
        }
        Object var18_13 = null;
        this.fSharedState.fIsChanging = false;
        if (!this.fCopy) return;
        this.fSharedState.endCompoundEdit();
    }

    private IJavaProject getProject() {
        IEditorInput editorInput = this.fSharedState.fEditor.getEditorInput();
        ICompilationUnit unit = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (unit != null) {
            return unit.getJavaProject();
        }
        return null;
    }

    private ILineRange getLineRange(IDocument document, ITextSelection selection) throws BadLocationException {
        int offset = selection.getOffset();
        int startLine = document.getLineOfOffset(offset);
        int endOffset = offset + selection.getLength();
        int endLine = document.getLineOfOffset(endOffset);
        int nLines = endLine - startLine + 1;
        return new LineRange(startLine, nLines);
    }

    private IRegion getRegion(IDocument document, ILineRange lineRange) throws BadLocationException {
        int startLine = lineRange.getStartLine();
        int offset = document.getLineOffset(startLine);
        int numberOfLines = lineRange.getNumberOfLines();
        if (numberOfLines < 1) {
            return new Region(offset, 0);
        }
        int endLine = startLine + numberOfLines - 1;
        int endOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
        return new Region(offset, endOffset - offset);
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private void showStatus() {
        IEditorStatusLine status;
        CompilationUnitEditor compilationUnitEditor = this.fSharedState.fEditor;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((status = (IEditorStatusLine)compilationUnitEditor.getAdapter(clazz)) == null) {
            return;
        }
        status.setMessage(false, JavaEditorMessages.Editor_MoveLines_IllegalMove_status, null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    private static final class SharedState {
        public CompilationUnitEditor fEditor;
        public IndentUtil.IndentResult fResult = null;
        boolean fIsChanging = false;
        private boolean fEditInProgress = false;
        private final CompoundEditExitStrategy fExitStrategy;
        static /* synthetic */ Class class$0;

        public SharedState(CompilationUnitEditor editor) {
            this.fEditor = editor;
            this.fExitStrategy = new CompoundEditExitStrategy(new String[]{"org.eclipse.ui.edit.text.moveLineUp", "org.eclipse.ui.edit.text.moveLineDown", "org.eclipse.ui.edit.text.copyLineUp", "org.eclipse.ui.edit.text.copyLineDown"});
            this.fExitStrategy.addCompoundListener(new ICompoundEditListener(this){
                final /* synthetic */ SharedState this$1;
                {
                    this.this$1 = sharedState;
                }

                public void endCompoundEdit() {
                    this.this$1.endCompoundEdit();
                }
            });
        }

        public void beginCompoundEdit() {
            IRewriteTarget target;
            if (this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fEditInProgress = true;
            this.fExitStrategy.arm((ITextViewer)this.fEditor.getViewer());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                target.beginCompoundChange();
            }
        }

        public void endCompoundEdit() {
            IRewriteTarget target;
            if (!this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fExitStrategy.disarm();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                target.endCompoundChange();
            }
            this.fResult = null;
            this.fEditInProgress = false;
        }
    }
}

