/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.model.JavaProjectSettings;
import org.eclipse.jdt.internal.ui.model.ModelMessages;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class JavaModelLabelProvider
extends AppearanceAwareLabelProvider {
    private final RefactoringHistoryLabelProvider fHistoryLabelProvider = new RefactoringHistoryLabelProvider(new RefactoringHistoryControlConfiguration(null, false, false));
    private final String fPreferencesLabel;
    private final String fRefactoringsLabel;
    private Image fSettingsImage = null;

    public JavaModelLabelProvider() {
        this(ModelMessages.JavaModelLabelProvider_project_preferences_label, ModelMessages.JavaModelLabelProvider_refactorings_label);
    }

    public JavaModelLabelProvider(String preferences, String refactorings) {
        super(36421324767273L, 3);
        Assert.isNotNull((Object)preferences);
        Assert.isNotNull((Object)refactorings);
        this.fPreferencesLabel = preferences;
        this.fRefactoringsLabel = refactorings;
    }

    public void dispose() {
        super.dispose();
        this.fHistoryLabelProvider.dispose();
        if (this.fSettingsImage != null && !this.fSettingsImage.isDisposed()) {
            this.fSettingsImage.dispose();
            this.fSettingsImage = null;
        }
    }

    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image == null) {
            if (element instanceof RefactoringHistory) {
                image = this.fHistoryLabelProvider.getImage(element);
            } else if (element instanceof RefactoringDescriptorProxy) {
                image = this.fHistoryLabelProvider.getImage(element);
            } else if (element instanceof JavaProjectSettings) {
                if (this.fSettingsImage == null || this.fSettingsImage.isDisposed()) {
                    this.fSettingsImage = JavaPluginImages.DESC_OBJS_PROJECT_SETTINGS.createImage();
                }
                image = this.fSettingsImage;
            }
            return this.decorateImage(image, element);
        }
        return image;
    }

    public String getText(Object element) {
        String text = super.getText(element);
        if (text == null || "".equals(text)) {
            if (element instanceof RefactoringHistory) {
                text = this.fRefactoringsLabel;
            } else if (element instanceof RefactoringDescriptorProxy) {
                text = this.fHistoryLabelProvider.getText(element);
            } else if (element instanceof JavaProjectSettings) {
                text = this.fPreferencesLabel;
            }
            return this.decorateText(text, element);
        }
        return text;
    }
}

