/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.LinkedFix;
import org.eclipse.jdt.internal.corext.fix.PositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class FixCorrectionProposal
extends LinkedCorrectionProposal
implements ICompletionProposalExtension2,
IStatusLineProposal {
    private final IFix fFix;
    private final ICleanUp fCleanUp;
    private CompilationUnit fCompilationUnit;

    public FixCorrectionProposal(IFix fix, ICleanUp cleanUp, int relevance, Image image, IInvocationContext context) {
        super(fix.getDescription(), fix.getCompilationUnit(), (ASTRewrite)null, relevance, image);
        this.fFix = fix;
        this.fCleanUp = cleanUp;
        this.fCompilationUnit = context.getASTRoot();
    }

    public ICleanUp getCleanUp() {
        return this.fCleanUp;
    }

    protected TextChange createTextChange() throws CoreException {
        IFix fix = this.fFix;
        TextChange createChange = fix.createChange();
        if (fix instanceof LinkedFix) {
            LinkedFix linkedFix = (LinkedFix)fix;
            PositionGroup[] positionGroups = linkedFix.getPositionGroups();
            int i = 0;
            while (i < positionGroups.length) {
                PositionGroup group = positionGroups[i];
                String groupId = group.getGroupId();
                ITrackedNodePosition firstPosition = group.getFirstPosition();
                ITrackedNodePosition[] positions = group.getPositions();
                int j = 0;
                while (j < positions.length) {
                    this.addLinkedPosition(positions[j], positions[j] == firstPosition, groupId);
                    ++j;
                }
                String[] proposals = group.getProposals();
                String[] displayStrings = group.getDisplayStrings();
                int j2 = 0;
                while (j2 < proposals.length) {
                    String proposal = proposals[j2];
                    String displayString = displayStrings[j2];
                    if (proposal == null) {
                        proposal = displayString;
                    }
                    if (displayString == null) {
                        displayString = proposal;
                    }
                    this.addLinkedPositionProposal(groupId, displayString, proposal, null);
                    ++j2;
                }
                ++i;
            }
            ITrackedNodePosition endPosition = linkedFix.getEndPosition();
            if (endPosition != null) {
                this.setEndPosition(endPosition);
            }
        }
        if (createChange == null) {
            return new CompilationUnitChange("", this.getCompilationUnit());
        }
        return createChange;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        if (stateMask == 262144 && this.fCleanUp != null) {
            CleanUpRefactoring refactoring = new CleanUpRefactoring();
            refactoring.addCompilationUnit(this.getCompilationUnit());
            refactoring.addCleanUp(this.fCleanUp);
            int stopSeverity = RefactoringCore.getConditionCheckingFailedSeverity();
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            RefactoringExecutionHelper executer = new RefactoringExecutionHelper(refactoring, stopSeverity, false, shell, context);
            try {
                executer.perform();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                JavaPlugin.log(e);
            }
            return;
        }
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public String getStatusMessage() {
        if (this.fCleanUp == null) {
            return null;
        }
        int count = this.fCleanUp.maximalNumberOfFixes(this.fCompilationUnit);
        if (count == -1) {
            return CorrectionMessages.FixCorrectionProposal_HitCtrlEnter_description;
        }
        if (count < 2) {
            return "";
        }
        return Messages.format(CorrectionMessages.FixCorrectionProposal_hitCtrlEnter_variable_description, new Integer(count));
    }
}

