/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.UserLibraryPreferencePage;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UserLibraryWizardPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension,
IClasspathContainerPageExtension2 {
    private CheckedListDialogField fLibrarySelector;
    private CPUserLibraryElement fEditResult;
    private Set fUsedPaths;
    private boolean fIsEditMode;
    private IJavaProject fProject;

    public UserLibraryWizardPage() {
        super("UserLibraryWizardPage");
        this.setTitle(NewWizardMessages.UserLibraryWizardPage_title);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.updateDescription(null);
        this.fUsedPaths = new HashSet();
        this.fProject = UserLibraryPreferencePage.getPlaceholderProject();
        LibraryListAdapter adapter = new LibraryListAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.UserLibraryWizardPage_list_config_button};
        this.fLibrarySelector = new CheckedListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrarySelector.setDialogFieldListener(adapter);
        this.fLibrarySelector.setLabelText(NewWizardMessages.UserLibraryWizardPage_list_label);
        this.fEditResult = null;
        this.updateStatus(this.validateSetting(Collections.EMPTY_LIST));
    }

    private void updateDescription(IClasspathEntry containerEntry) {
        if (containerEntry == null || containerEntry.getPath().segmentCount() != 2) {
            this.setDescription(NewWizardMessages.UserLibraryWizardPage_description_new);
        } else {
            this.setDescription(Messages.format(NewWizardMessages.UserLibraryWizardPage_description_edit, containerEntry.getPath().segment(1)));
        }
    }

    private List updateLibraryList() {
        HashSet<String> oldNames = new HashSet<String>();
        HashSet<String> oldCheckedNames = new HashSet<String>();
        List oldElements = this.fLibrarySelector.getElements();
        int i = 0;
        while (i < oldElements.size()) {
            CPUserLibraryElement curr = (CPUserLibraryElement)oldElements.get(i);
            oldNames.add(curr.getName());
            if (this.fLibrarySelector.isChecked(curr)) {
                oldCheckedNames.add(curr.getName());
            }
            ++i;
        }
        ArrayList<CPUserLibraryElement> entriesToCheck = new ArrayList<CPUserLibraryElement>();
        String[] names = JavaCore.getUserLibraryNames();
        Arrays.sort(names, Collator.getInstance());
        ArrayList<CPUserLibraryElement> elements = new ArrayList<CPUserLibraryElement>(names.length);
        int i2 = 0;
        while (i2 < names.length) {
            String curr = names[i2];
            IPath path = new Path("org.eclipse.jdt.USER_LIBRARY").append(curr);
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.fProject);
                CPUserLibraryElement elem = new CPUserLibraryElement(curr, container, this.fProject);
                elements.add(elem);
                if (!oldCheckedNames.isEmpty()) {
                    if (oldCheckedNames.contains(curr)) {
                        entriesToCheck.add(elem);
                    }
                } else if (!oldNames.contains(curr)) {
                    entriesToCheck.add(elem);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i2;
        }
        this.fLibrarySelector.setElements(elements);
        return entriesToCheck;
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fLibrarySelector) {
            List list = this.fLibrarySelector.getCheckedElements();
            if (this.fIsEditMode) {
                if (list.size() > 1) {
                    if (this.fEditResult != null && list.remove(this.fEditResult)) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(this.fEditResult, false);
                    }
                    this.fEditResult = (CPUserLibraryElement)list.get(0);
                    int i = 1;
                    while (i < list.size()) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(list.get(i), false);
                        ++i;
                    }
                } else if (list.size() == 1) {
                    this.fEditResult = (CPUserLibraryElement)list.get(0);
                }
            }
            this.updateStatus(this.validateSetting(list));
        }
    }

    private IStatus validateSetting(List selected) {
        int nSelected = selected.size();
        if (nSelected == 0) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectentry);
        }
        if (this.fIsEditMode && nSelected > 1) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectonlyone);
        }
        int i = 0;
        while (i < selected.size()) {
            CPUserLibraryElement curr = (CPUserLibraryElement)selected.get(i);
            if (this.fUsedPaths.contains(curr.getPath())) {
                return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_alreadyoncp);
            }
            ++i;
        }
        return new StatusInfo();
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            HashMap<String, String> data = new HashMap<String, String>(3);
            if (this.fEditResult != null) {
                data.put("select_library", this.fEditResult.getName());
            }
            String id = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, data).open();
            List newEntries = this.updateLibraryList();
            if (newEntries.size() > 0) {
                if (this.fIsEditMode) {
                    this.fLibrarySelector.setChecked(newEntries.get(0), true);
                } else {
                    this.fLibrarySelector.setCheckedElements(newEntries);
                }
            }
        } else {
            this.fLibrarySelector.setCheckedElements(this.fLibrarySelector.getSelectedElements());
        }
    }

    private void doDoubleClicked(ListDialogField field) {
        Object elem;
        boolean state;
        List list = this.fLibrarySelector.getSelectedElements();
        if (!(list.size() != 1 || (state = this.fLibrarySelector.isChecked(elem = list.get(0))) && this.fIsEditMode)) {
            this.fLibrarySelector.setChecked(elem, !state);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrarySelector}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrarySelector.getListControl(null));
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        if (this.fEditResult != null) {
            return JavaCore.newContainerEntry((IPath)this.fEditResult.getPath());
        }
        return null;
    }

    public IClasspathEntry[] getNewContainers() {
        List selected = this.fLibrarySelector.getCheckedElements();
        IClasspathEntry[] res = new IClasspathEntry[selected.size()];
        int i = 0;
        while (i < res.length) {
            CPUserLibraryElement curr = (CPUserLibraryElement)selected.get(i);
            res[i] = JavaCore.newContainerEntry((IPath)curr.getPath());
            ++i;
        }
        return res;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.updateDescription(containerEntry);
        boolean bl = this.fIsEditMode = containerEntry != null;
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
        }
        String selected = null;
        if (containerEntry != null && containerEntry.getPath().segmentCount() == 2) {
            selected = containerEntry.getPath().segment(1);
        }
        this.updateLibraryList();
        if (selected != null) {
            List elements = this.fLibrarySelector.getElements();
            int i = 0;
            while (i < elements.size()) {
                CPUserLibraryElement curr = (CPUserLibraryElement)elements.get(i);
                if (curr.getName().equals(selected)) {
                    this.fLibrarySelector.setChecked(curr, true);
                    return;
                }
                ++i;
            }
        }
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            IClasspathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    private class LibraryListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        public void dialogFieldChanged(DialogField field) {
            UserLibraryWizardPage.this.doDialogFieldChanged(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            UserLibraryWizardPage.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
            UserLibraryWizardPage.this.doDoubleClicked(field);
        }
    }
}

