/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object element) {
        block6: {
            if (element instanceof IMethod) {
                try {
                    IMethod method = (IMethod)element;
                    if (!method.getJavaProject().isOnClasspath((IJavaElement)method)) {
                        return 0;
                    }
                    int flags = method.getFlags();
                    if (!(method.isConstructor() || Flags.isPrivate((int)flags) || Flags.isStatic((int)flags))) {
                        int res = this.getOverrideIndicators(method);
                        if (res != 0 && Flags.isSynchronized((int)flags)) {
                            return res | 4;
                        }
                        return res;
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block6;
                    JavaPlugin.log(e);
                }
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IMethod method) throws JavaModelException {
        int res;
        CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)method.getOpenable(), ASTProvider.WAIT_NO, null);
        if (astRoot != null && (res = this.findInHierarchyWithAST(astRoot, method)) != -1) {
            return res;
        }
        IType type = method.getDeclaringType();
        MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        IMethod defining = methodOverrideTester.findOverriddenMethod(method, true);
        if (defining != null) {
            if (JdtFlags.isAbstract((IMember)defining)) {
                return 256;
            }
            return 128;
        }
        return 0;
    }

    private int findInHierarchyWithAST(CompilationUnit astRoot, IMethod method) throws JavaModelException {
        IMethodBinding binding;
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, method.getNameRange());
        if (node instanceof SimpleName && node.getParent() instanceof MethodDeclaration && (binding = ((MethodDeclaration)node.getParent()).resolveBinding()) != null) {
            IMethodBinding defining = Bindings.findOverriddenMethod(binding, true);
            if (defining != null) {
                if (JdtFlags.isAbstract(defining)) {
                    return 256;
                }
                return 128;
            }
            return 0;
        }
        return -1;
    }

    protected int findInHierarchy(IType type, ITypeHierarchy hierarchy, String name, String[] paramTypes) throws JavaModelException {
        IMethod res;
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, false)) != null && !Flags.isPrivate((int)res.getFlags()) && JavaModelUtil.isVisibleInHierarchy((IMember)res, type.getPackageFragment())) {
            if (JdtFlags.isAbstract((IMember)res)) {
                return 256;
            }
            return 128;
        }
        IType[] interfaces = hierarchy.getSuperInterfaces(type);
        int i = 0;
        while (i < interfaces.length) {
            IMethod res2 = JavaModelUtil.findMethodInHierarchy(hierarchy, interfaces[i], name, paramTypes, false);
            if (res2 != null) {
                if (JdtFlags.isAbstract((IMember)res2)) {
                    return 256;
                }
                return 128;
            }
            ++i;
        }
        return 0;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if ((adornmentFlags & 0x100) != 0) {
            if ((adornmentFlags & 4) != 0) {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_SYNCH_AND_IMPLEMENTS);
            } else {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_IMPLEMENTS);
            }
        } else if ((adornmentFlags & 0x80) != 0) {
            if ((adornmentFlags & 4) != 0) {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_SYNCH_AND_OVERRIDES);
            } else {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_OVERRIDES);
            }
        }
    }
}

