/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class JUnitAddLibraryProposal
implements IJavaCompletionProposal {
    private final IInvocationContext fContext;

    public JUnitAddLibraryProposal(IInvocationContext context) {
        this.fContext = context;
    }

    public int getRelevance() {
        return 0;
    }

    public void apply(IDocument document) {
        IJavaProject project = this.fContext.getCompilationUnit().getJavaProject();
        try {
            JUnitAddLibraryProposal.addJUnitToBuildPath(JUnitPlugin.getActiveWorkbenchShell(), project);
            int offset = this.fContext.getSelectionOffset();
            int length = this.fContext.getSelectionLength();
            String s = document.get(offset, length);
            document.replace(offset, length, s);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)JUnitPlugin.getActiveWorkbenchShell(), (String)JUnitMessages.JUnitAddLibraryProposal_title, (String)JUnitMessages.JUnitAddLibraryProposal_cannotAdd, (IStatus)e.getStatus());
        }
        catch (BadLocationException badLocationException) {}
    }

    public static void addJUnitToBuildPath(Shell shell, IJavaProject project) throws JavaModelException {
        IProject junitProject = ResourcesPlugin.getWorkspace().getRoot().getProject("org.junit");
        IClasspathEntry entry = null;
        if (junitProject.exists()) {
            entry = JavaCore.newProjectEntry((IPath)junitProject.getFullPath());
        } else {
            IPath junitHome = new Path("JUNIT_HOME").append("junit.jar");
            IPath sourceHome = new Path("JUNIT_SRC_HOME").append("junitsrc.zip");
            entry = JavaCore.newVariableEntry((IPath)junitHome, (IPath)sourceHome, null);
        }
        JUnitAddLibraryProposal.addToClasspath(shell, project, entry);
    }

    private static void addToClasspath(Shell shell, final IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(entry)) {
                return;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        final IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = entry;
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawClasspath(newEntries, monitor);
                    }
                    catch (JavaModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                ErrorDialog.openError((Shell)shell, (String)WizardMessages.NewTestClassWizPage_cannot_add_title, (String)WizardMessages.NewTestClassWizPage_cannot_add_message, (IStatus)((CoreException)t).getStatus());
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }

    public String getAdditionalProposalInfo() {
        return JUnitMessages.JUnitAddLibraryProposal_info;
    }

    public String getDisplayString() {
        return JUnitMessages.JUnitAddLibraryProposal_label;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

