/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.internal.registry.osgi.EquinoxRegistryStrategy;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryProviderOSGI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.RegistryUtils;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext bundleContext;
    private static final String STORAGE_DIR = "org.eclipse.core.runtime";
    private Object masterRegistryKey = new Object();
    private Object userRegistryKey = new Object();
    private IExtensionRegistry defaultRegistry = null;
    private ServiceRegistration registryRegistration;
    private RegistryProviderOSGI defaultProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        this.processCommandLine();
        this.startRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopRegistry();
        bundleContext = null;
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    private void processCommandLine() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker environmentTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        environmentTracker.open();
        EnvironmentInfo environmentInfo = (EnvironmentInfo)environmentTracker.getService();
        environmentTracker.close();
        if (environmentInfo == null) {
            return;
        }
        String[] args = environmentInfo.getNonFrameworkArgs();
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-noregistrycache")) {
                System.getProperties().setProperty("eclipse.noRegistryCache", "true");
            } else if (args[i].equalsIgnoreCase("-noLazyRegistryCacheLoading")) {
                System.getProperties().setProperty("eclipse.noLazyRegistryCacheLoading", "true");
            }
            ++i;
        }
    }

    public void startRegistry() throws CoreException {
        String property = bundleContext.getProperty("eclipse.createRegistry");
        if (property != null && property.equalsIgnoreCase("false")) {
            return;
        }
        if ("true".equals(bundleContext.getProperty("eclipse.registry.nulltoken"))) {
            this.userRegistryKey = null;
        }
        Location configuration = OSGIUtils.getDefault().getConfigurationLocation();
        File theStorageDir = new File(String.valueOf(configuration.getURL().getPath()) + '/' + STORAGE_DIR);
        EquinoxRegistryStrategy registryStrategy = new EquinoxRegistryStrategy(theStorageDir, configuration.isReadOnly(), this.masterRegistryKey);
        this.defaultRegistry = RegistryFactory.createRegistry(registryStrategy, this.masterRegistryKey, this.userRegistryKey);
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registryRegistration = bundleContext.registerService(clazz.getName(), (Object)this.defaultRegistry, new Hashtable());
        this.defaultProvider = new RegistryProviderOSGI();
        RegistryUtils.setRegistryProvider(this.defaultProvider);
    }

    private void stopRegistry() {
        if (this.defaultRegistry != null) {
            this.defaultProvider.release();
            this.registryRegistration.unregister();
            this.defaultRegistry.stop(this.masterRegistryKey);
        }
    }
}

