/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.shared;

import java.util.ArrayList;
import org.eclipse.ui.internal.intro.shared.GroupData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageData {
    private String id;
    private ArrayList groups = new ArrayList();
    private GroupData hidden = null;

    public PageData(Element page) {
        this.id = page.getAttribute("id");
        NodeList children = page.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element element = (Element)child;
                if (element.getNodeName().equals("group")) {
                    this.addGroup(element);
                } else if (element.getNodeName().equals("hidden")) {
                    this.addGroup(element);
                }
            }
            ++i;
        }
    }

    private void addGroup(Element element) {
        GroupData gd = new GroupData(element);
        this.groups.add(gd);
    }

    public String getId() {
        return this.id;
    }

    public String resolveExtension(String extensionId) {
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gdata = (GroupData)this.groups.get(i);
            if (gdata.contains(extensionId)) {
                return String.valueOf(this.id) + "/" + gdata.getPath() + "/" + extensionId;
            }
            ++i;
        }
        if (this.hidden != null && this.hidden.contains(extensionId)) {
            return null;
        }
        if (this.groups.size() == 0) {
            return null;
        }
        GroupData last = (GroupData)this.groups.get(this.groups.size() - 1);
        return String.valueOf(this.id) + "/" + last.getPath() + "/" + "defaultAnchor";
    }
}

