/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.shared;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.shared.IntroData;
import org.eclipse.ui.intro.config.IntroConfigurer;
import org.eclipse.ui.intro.config.IntroElement;
import org.osgi.framework.Bundle;

public class SharedIntroConfigurer
extends IntroConfigurer {
    private ArrayList introData;

    public SharedIntroConfigurer() {
        this.initialize();
    }

    public String getVariable(String variableName) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String value = product.getProperty(variableName);
            if (value != null) {
                value = this.resolveVariable(product.getDefiningBundle(), value);
            }
            return value;
        }
        return null;
    }

    private String resolveVariable(Bundle bundle, String value) {
        if (value != null && value.startsWith("bundle:")) {
            try {
                String path = value.substring(7);
                URL url = bundle.getEntry(path);
                URL localURL = Platform.asLocalURL((URL)url);
                return localURL.toString();
            }
            catch (IOException iOException) {
                return value;
            }
        }
        return value;
    }

    public IntroElement[] getGroupChildren(String pageId, String groupId) {
        if (pageId.equals("root")) {
            if (groupId.equals("page-links")) {
                return this.getRootPageLinks(false);
            }
        } else if (pageId.equals("standby") && groupId.equals("page-links")) {
            return this.getRootPageLinks(true);
        }
        if (groupId.equals("page-links")) {
            return this.getNavLinks(pageId);
        }
        return new IntroElement[0];
    }

    private IntroElement[] getRootPageLinks(boolean standby) {
        ArrayList<IntroElement> links = new ArrayList<IntroElement>();
        String ids = this.getVariable("introRootPages");
        if (ids != null) {
            StringTokenizer stok = new StringTokenizer(ids, ",");
            while (stok.hasMoreTokens()) {
                String id = stok.nextToken().trim();
                IntroElement page = this.createRootPageLink(id);
                if (page == null) continue;
                links.add(page);
            }
        }
        return links.toArray(new IntroElement[links.size()]);
    }

    private IntroElement[] getNavLinks(String pageId) {
        ArrayList<IntroElement> links = new ArrayList<IntroElement>();
        String ids = this.getVariable("introRootPages");
        if (ids != null) {
            StringTokenizer stok = new StringTokenizer(ids, ",");
            while (stok.hasMoreTokens()) {
                String id = stok.nextToken().trim();
                IntroElement page = this.createNavLink(id, pageId);
                if (page == null) continue;
                links.add(page);
            }
        }
        return links.toArray(new IntroElement[links.size()]);
    }

    private IntroElement createRootPageLink(String id) {
        if (id.equals("overview")) {
            return this.createRootLink("Overview", "http://org.eclipse.ui.intro/showPage?id=overview", "overview", "overview_img", "css/graphics/root/overview.png", "Overview", "Find out what Eclipse is all about");
        }
        if (id.equals("firststeps")) {
            return this.createRootLink("First Steps", "http://org.eclipse.ui.intro/showPage?id=firststeps", "firststeps", "firststeps_img", "css/graphics/root/firststeps.png", "First Steps", "Make first steps");
        }
        if (id.equals("tutorials")) {
            return this.createRootLink("Tutorials", "http://org.eclipse.ui.intro/showPage?id=tutorials", "tutorials", "tutorials_img", "css/graphics/root/tutorials.png", "Tutorials", "Go through tutorials");
        }
        if (id.equals("samples")) {
            return this.createRootLink("Samples", "http://org.eclipse.ui.intro/showPage?id=samples", "samples", "samples_img", "css/graphics/root/samples.png", "Samples", "Try out the samples");
        }
        if (id.equals("whatsnew")) {
            return this.createRootLink("What's New", "http://org.eclipse.ui.intro/showPage?id=whatsnew", "whatsnew", "whatsnew_img", "css/graphics/root/whatsnew.png", "What's New", "Find out what is new");
        }
        if (id.equals("migrate")) {
            return this.createRootLink("Migrate", "http://org.eclipse.ui.intro/showPage?id=migrate", "migrate", "migrate_img", "css/graphics/root/migrate.png", "Migrate", "Migrate to the new release");
        }
        if (id.equals("webresources")) {
            return this.createRootLink("Web Resources", "http://org.eclipse.ui.intro/showPage?id=webresources", "webresources", "webresources_img", "css/graphics/root/webresources.png", "Web Resources", "Read more on the Web");
        }
        return null;
    }

    private IntroElement createNavLink(String id, String pageId) {
        if (id.equals("overview")) {
            return this.createNavLink("Overview", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        if (id.equals("firststeps")) {
            return this.createNavLink("First Steps", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        if (id.equals("tutorials")) {
            return this.createNavLink("Tutorials", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        if (id.equals("samples")) {
            return this.createNavLink("Samples", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        if (id.equals("whatsnew")) {
            return this.createNavLink("What's New", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        if (id.equals("migrate")) {
            return this.createNavLink("Migrate", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        if (id.equals("webresources")) {
            return this.createNavLink("Web Resources", "http://org.eclipse.ui.intro/showPage?id=" + id, id, "left");
        }
        return null;
    }

    private IntroElement createRootLink(String name, String url, String id, String imgId, String imgSrc, String imgAlt, String imgText) {
        IntroElement element = new IntroElement("link");
        element.setAttribute("label", name);
        element.setAttribute("url", url);
        element.setAttribute("id", id);
        IntroElement img = new IntroElement("img");
        img.setAttribute("id", imgId);
        img.setAttribute("style-id", "content-img");
        img.setAttribute("src", imgSrc);
        img.setAttribute("alt", imgAlt);
        IntroElement text = new IntroElement("text");
        text.setValue(imgText);
        element.addChild(img);
        element.addChild(text);
        return element;
    }

    private IntroElement createNavLink(String label, String url, String id, String styleId) {
        IntroElement element = new IntroElement("link");
        element.setAttribute("label", label);
        element.setAttribute("url", url);
        element.setAttribute("id", "id");
        element.setAttribute("style-id", styleId);
        return element;
    }

    private void initialize() {
        String dataFile = this.getVariable("introData");
        String pid = Platform.getProduct().getId();
        if (dataFile != null) {
            this.introData.add(new IntroData(pid, dataFile, true));
        }
        IConfigurationElement[] products = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.runtime.products");
        int i = 0;
        while (i < products.length) {
            IConfigurationElement product = products[i];
            IExtension extension = product.getDeclaringExtension();
            String uid = extension.getUniqueIdentifier();
            if (!pid.equals(uid)) {
                this.addIntroDataFor(uid, product);
            }
            ++i;
        }
    }

    private void addIntroDataFor(String pid, IConfigurationElement product) {
        IConfigurationElement[] children = product.getChildren("property");
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String name = child.getAttribute("name");
            if (name != null && name.equals("introData")) {
                String value = child.getAttribute("value");
                String bid = child.getDeclaringExtension().getNamespace();
                Bundle bundle = Platform.getBundle((String)bid);
                if (bundle != null) {
                    String dataFile = this.resolveVariable(bundle, value);
                    this.introData.add(new IntroData(pid, dataFile, false));
                }
            }
            ++i;
        }
    }
}

