/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class TagRule
extends MultiLineRule {
    public TagRule(IToken token) {
        super("<", ">", token);
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int c = scanner.read();
        if (sequence[0] == '<') {
            if (c == 63) {
                scanner.unread();
                return false;
            }
            if (c == 33) {
                scanner.unread();
                return false;
            }
        } else if (sequence[0] == '>') {
            scanner.unread();
        }
        return super.sequenceDetected(scanner, sequence, eofAllowed);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, true)) {
                    if (this.fEndSequence[0] == '>') {
                        return this.endOfTagDetected(scanner);
                    }
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                int i = 0;
                while (i < delimiters.length) {
                    if (!(c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter)) {
                        return true;
                    }
                    ++i;
                }
            }
            boolean bl = previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }

    private boolean endOfTagDetected(ICharacterScanner scanner) {
        int c;
        int scanAhead = 0;
        int endOfTagOffset = 0;
        while ((c = scanner.read()) != -1 && c != 60) {
            ++scanAhead;
            if (c != 62) continue;
            endOfTagOffset = scanAhead;
        }
        if (c == 60) {
            int rewind = scanAhead - endOfTagOffset + 1;
            int i = 0;
            while (i < rewind) {
                scanner.unread();
                ++i;
            }
        }
        return true;
    }
}

