/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class CachedManifest
extends Dictionary {
    private Dictionary manifest = null;
    private EclipseStorageHook storageHook;

    public CachedManifest(EclipseStorageHook storageHook) {
        this.storageHook = storageHook;
    }

    public Dictionary getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = this.storageHook.createCachedManifest(true);
            }
            catch (BundleException e) {
                String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CACHEDMANIFEST_UNEXPECTED_EXCEPTION, this.storageHook.getBaseData().getLocation());
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null);
                this.storageHook.getAdaptor().getFrameworkLog().log(entry);
                return null;
            }
        }
        return this.manifest;
    }

    public int size() {
        return this.getManifest().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration elements() {
        return this.getManifest().elements();
    }

    public Enumeration keys() {
        return this.getManifest().keys();
    }

    public Object get(Object key) {
        String keyString = (String)key;
        if ("Bundle-Version".equalsIgnoreCase(keyString)) {
            Version result = this.storageHook.getBaseData().getVersion();
            return result == null ? null : result.toString();
        }
        if ("Plugin-Class".equalsIgnoreCase(keyString)) {
            return this.storageHook.getPluginClass();
        }
        if ("Bundle-SymbolicName".equalsIgnoreCase(keyString)) {
            if ((this.storageHook.getBaseData().getType() & 8) == 0) {
                return this.storageHook.getBaseData().getSymbolicName();
            }
            return String.valueOf(this.storageHook.getBaseData().getSymbolicName()) + ';' + "singleton" + ":=true";
        }
        if ("Eclipse-BuddyPolicy".equalsIgnoreCase(keyString)) {
            return this.storageHook.getBuddyList();
        }
        if ("Eclipse-RegisterBuddy".equalsIgnoreCase(keyString)) {
            return this.storageHook.getRegisteredBuddyList();
        }
        Dictionary result = this.getManifest();
        return result == null ? null : result.get(key);
    }

    public Object remove(Object key) {
        return this.getManifest().remove(key);
    }

    public Object put(Object key, Object value) {
        return this.getManifest().put(key, value);
    }
}

