/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.PerspectiveTracker;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportExportWizard;

public class ExportResourcesAction
extends BaseSelectionListenerAction
implements ActionFactory.IWorkbenchAction {
    private static final int SIZING_WIZARD_WIDTH = 470;
    private static final int SIZING_WIZARD_HEIGHT = 550;
    private IWorkbenchWindow workbenchWindow;
    private PerspectiveTracker tracker;
    private final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                ExportResourcesAction.this.selectionChanged(structured);
            }
        }
    };

    public ExportResourcesAction(IWorkbenchWindow window) {
        this(window, WorkbenchMessages.ExportResourcesAction_text);
    }

    public ExportResourcesAction(IWorkbenchWindow window, String label) {
        super(label);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.tracker = new PerspectiveTracker(window, this);
        this.setActionDefinitionId("org.eclipse.ui.file.export");
        this.setToolTipText(WorkbenchMessages.ExportResourcesAction_toolTip);
        this.setId("export");
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.export_action_context");
        this.workbenchWindow.getSelectionService().addSelectionListener(this.selectionListener);
        this.setText(WorkbenchMessages.ExportResourcesAction_fileMenuText);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_EXPORT_WIZ"));
    }

    public ExportResourcesAction(IWorkbench workbench) {
        this(workbench.getActiveWorkbenchWindow());
    }

    public ExportResourcesAction(IWorkbench workbench, String label) {
        this(workbench.getActiveWorkbenchWindow(), label);
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        ImportExportWizard wizard = new ImportExportWizard("export");
        ISelection workbenchSelection = this.workbenchWindow.getSelectionService().getSelection();
        Object selectionToPass = workbenchSelection instanceof IStructuredSelection ? (IStructuredSelection)workbenchSelection : StructuredSelection.EMPTY;
        wizard.init(this.workbenchWindow.getWorkbench(), (IStructuredSelection)selectionToPass);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ImportExportAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ImportExportAction");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.workbenchWindow.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 550);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.export_wizard_context");
        dialog.open();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selectionChanged(selection);
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.tracker.dispose();
        this.workbenchWindow.getSelectionService().removeSelectionListener(this.selectionListener);
        this.workbenchWindow = null;
    }
}

