/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PatternFilter
extends ViewerFilter {
    private Map cache = new HashMap();
    private boolean includeLeadingWildcard = false;
    private StringMatcher matcher;

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null) {
            return elements;
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered == null) {
            filtered = super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementMatch(viewer, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    public void setPattern(String patternString) {
        this.cache.clear();
        if (patternString == null || patternString.equals("")) {
            this.matcher = null;
        } else {
            String pattern = String.valueOf(patternString) + "*";
            if (this.includeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this.matcher = new StringMatcher(pattern, true, false);
        }
    }

    protected boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(string);
    }

    protected boolean isElementSelectable(Object element) {
        return element != null;
    }

    protected boolean isElementMatch(Viewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.filter(viewer, element, children).length > 0;
        }
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.match(labelText);
    }
}

