/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.handlers.LegacyHandlerProxy;
import org.eclipse.ui.internal.handlers.LegacyHandlerWrapper;
import org.eclipse.ui.internal.services.RegistryPersistence;

final class HandlerPersistence
extends RegistryPersistence {
    private static final Collection handlerActivations = new ArrayList();
    private static final int INDEX_COMMAND_DEFINITIONS = 0;
    private static final int INDEX_HANDLER_DEFINITIONS = 1;
    private static final int INDEX_HANDLER_SUBMISSIONS = 2;
    private final IHandlerService handlerService;

    private static final void clearActivations(IHandlerService handlerService) {
        handlerService.deactivateHandlers(handlerActivations);
        handlerActivations.clear();
    }

    private static final void readDefaultHandlersFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IHandlerService handlerService) {
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = HandlerPersistence.readOptional(configurationElement, "id");
            if (commandId != null && (configurationElement.getAttribute("defaultHandler") != null || configurationElement.getChildren("defaultHandler").length != 0)) {
                handlerActivations.add(handlerService.activateHandler(commandId, (IHandler)new HandlerProxy(configurationElement, "defaultHandler")));
            }
            ++i;
        }
    }

    private static final void readHandlersFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IHandlerService handlerService) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            Expression enabledWhenExpression;
            Expression activeWhenExpression;
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = HandlerPersistence.readRequired(configurationElement, "commandId", warningsToLog, "Handlers need a command id");
            if (commandId != null && HandlerPersistence.checkClass(configurationElement, warningsToLog, "Handlers need a class", commandId) && (activeWhenExpression = HandlerPersistence.readWhenElement(configurationElement, "activeWhen", commandId, warningsToLog)) != ERROR_EXPRESSION && (enabledWhenExpression = HandlerPersistence.readWhenElement(configurationElement, "enabledWhen", commandId, warningsToLog)) != ERROR_EXPRESSION) {
                handlerActivations.add(handlerService.activateHandler(commandId, (IHandler)new HandlerProxy(configurationElement, "class", enabledWhenExpression, handlerService), activeWhenExpression));
            }
            ++i;
        }
        HandlerPersistence.logWarnings(warningsToLog, "Warnings while parsing the handlers from the 'org.eclipse.ui.handlers' extension point.");
    }

    private static final void readHandlerSubmissionsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IHandlerService handlerService) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = HandlerPersistence.readRequired(configurationElement, "commandId", warningsToLog, "Handler submissions need a command id");
            if (commandId != null) {
                handlerActivations.add(handlerService.activateHandler(commandId, new LegacyHandlerWrapper(new LegacyHandlerProxy(configurationElement))));
            }
            ++i;
        }
        HandlerPersistence.logWarnings(warningsToLog, "Warnings while parsing the handler submissions from the 'org.eclipse.ui.commands' extension point.");
    }

    HandlerPersistence(IHandlerService handlerService) {
        this.handlerService = handlerService;
    }

    public final void dispose() {
        super.dispose();
        HandlerPersistence.clearActivations(this.handlerService);
    }

    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        IExtensionDelta[] actionDefinitionDeltas;
        IExtensionDelta[] commandDeltas;
        IExtensionDelta[] handlerDeltas = event.getExtensionDeltas("org.eclipse.ui", "handlers");
        return handlerDeltas.length != 0 || (commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands")).length != 0 || (actionDefinitionDeltas = event.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length != 0;
    }

    protected final void read() {
        super.read();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int commandDefinitionCount = 0;
        int handlerDefinitionCount = 0;
        int handlerSubmissionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[3][];
        IConfigurationElement[] commandsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int i = 0;
        while (i < commandsExtensionPoint.length) {
            IConfigurationElement configurationElement = commandsExtensionPoint[i];
            String name = configurationElement.getName();
            if ("handlerSubmission".equals(name)) {
                HandlerPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, handlerSubmissionCount++);
            } else if ("command".equals(name)) {
                HandlerPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, commandDefinitionCount++);
            }
            ++i;
        }
        IConfigurationElement[] handlersExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.handlers");
        int i2 = 0;
        while (i2 < handlersExtensionPoint.length) {
            IConfigurationElement configurationElement = handlersExtensionPoint[i2];
            String name = configurationElement.getName();
            if ("handler".equals(name)) {
                HandlerPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, handlerDefinitionCount++);
            }
            ++i2;
        }
        HandlerPersistence.clearActivations(this.handlerService);
        HandlerPersistence.readDefaultHandlersFromRegistry(indexedConfigurationElements[0], commandDefinitionCount, this.handlerService);
        HandlerPersistence.readHandlerSubmissionsFromRegistry(indexedConfigurationElements[2], handlerSubmissionCount, this.handlerService);
        HandlerPersistence.readHandlersFromRegistry(indexedConfigurationElements[1], handlerDefinitionCount, this.handlerService);
    }
}

