/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.List;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.menus.ILayoutNode;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.LegacyContributionItem;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SWidget;

public class LegacyMenuManager
extends MenuManager {
    private final ILayoutNode layoutNode;
    private final WorkbenchWindow window;
    static /* synthetic */ Class class$0;

    public LegacyMenuManager(WorkbenchWindow window, ILayoutNode layoutNode) {
        if (window == null) {
            throw new NullPointerException("The window cannot be null");
        }
        if (layoutNode == null) {
            throw new NullPointerException("The layout node cannot be null");
        }
        this.window = window;
        this.layoutNode = layoutNode;
    }

    public final void add(IAction action) {
    }

    public final void add(IContributionItem contributionItem) {
        String itemId = contributionItem.getId();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)this.window.getService(clazz);
        if (contributionItem instanceof IContributionManager) {
            SMenu menu = menuService.getMenu(itemId);
            if (menu.isDefined()) {
                menu.addLocation(this.layoutNode.getLocation());
            }
        } else if (contributionItem.isGroupMarker() || contributionItem.isSeparator()) {
            SGroup group = menuService.getGroup(itemId);
            if (group.isDefined()) {
                group.addLocation(this.layoutNode.getLocation());
            }
        } else if (contributionItem instanceof ActionContributionItem) {
            SItem item = menuService.getItem(itemId);
            if (item.isDefined()) {
                item.addLocation(this.layoutNode.getLocation());
            }
        } else {
            SWidget widget = menuService.getWidget(itemId);
            if (widget.isDefined()) {
                widget.addLocation(this.layoutNode.getLocation());
            }
        }
    }

    public void addMenuListener(IMenuListener listener) {
    }

    public void appendToGroup(String groupName, IAction action) {
    }

    public void appendToGroup(String groupName, IContributionItem item) {
    }

    public void dispose() {
    }

    public void fill(Composite parent) {
    }

    public void fill(CoolBar parent, int index) {
    }

    public void fill(Menu parent, int index) {
    }

    public void fill(ToolBar parent, int index) {
    }

    public final IContributionItem find(String id) {
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            String itemId = item.getId();
            if (itemId != null && itemId.equalsIgnoreCase(id)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public final IMenuManager findMenuUsingPath(String path) {
        IContributionItem item = this.findUsingPath(path);
        if (item instanceof IMenuManager) {
            return (IMenuManager)item;
        }
        return null;
    }

    public final IContributionItem findUsingPath(String path) {
        String rest;
        String id;
        int separator = path.indexOf(47);
        if (separator == -1) {
            id = path;
            rest = null;
        } else {
            id = path.substring(0, separator);
            rest = path.substring(separator + 1);
        }
        IContributionItem item = this.find(id);
        if (rest == null) {
            return item;
        }
        if (item instanceof IMenuManager) {
            IMenuManager manager = (IMenuManager)item;
            return manager.findUsingPath(rest);
        }
        return null;
    }

    public String getId() {
        return null;
    }

    public final IContributionItem[] getItems() {
        List sortedChildren = this.layoutNode.getChildrenSorted();
        int length = sortedChildren.size();
        IContributionItem[] items = new IContributionItem[length];
        int i = 0;
        while (i < length) {
            ILayoutNode node = (ILayoutNode)sortedChildren.get(i);
            MenuElement element = node.getMenuElement();
            items[i] = element instanceof SMenu ? new LegacyMenuManager(this.window, node) : new LegacyContributionItem(node);
            ++i;
        }
        return items;
    }

    public IContributionManagerOverrides getOverrides() {
        return null;
    }

    public boolean getRemoveAllWhenShown() {
        return false;
    }

    public void insertAfter(String id, IAction action) {
    }

    public void insertAfter(String id, IContributionItem item) {
    }

    public void insertBefore(String id, IAction action) {
    }

    public void insertBefore(String id, IContributionItem item) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public final boolean isEmpty() {
        return this.layoutNode.isEmpty();
    }

    public final boolean isEnabled() {
        return true;
    }

    public final boolean isGroupMarker() {
        return this.layoutNode.getMenuElement() instanceof SGroup;
    }

    public final boolean isSeparator() {
        MenuElement element = this.layoutNode.getMenuElement();
        if (element instanceof SGroup) {
            SGroup group = (SGroup)element;
            try {
                return group.isSeparatorsVisible();
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    public void markDirty() {
    }

    public void prependToGroup(String groupName, IAction action) {
    }

    public void prependToGroup(String groupName, IContributionItem item) {
    }

    public IContributionItem remove(IContributionItem item) {
        return null;
    }

    public IContributionItem remove(String id) {
        return null;
    }

    public void removeAll() {
    }

    public void removeMenuListener(IMenuListener listener) {
    }

    public void saveWidgetState() {
    }

    public void setParent(IContributionManager parent) {
    }

    public void setRemoveAllWhenShown(boolean removeAll) {
    }

    public final void setVisible(boolean visible) {
        MenuElement element = this.layoutNode.getMenuElement();
        element.setVisible((Window)this.window, visible);
    }

    public void update() {
    }

    public void update(boolean force) {
    }

    public void update(String id) {
    }

    public void updateAll(boolean force) {
    }
}

