/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.menus.IWidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.internal.WorkbenchPlugin;

final class PulldownDelegateWidgetProxy
implements IWidget {
    private IConfigurationElement configurationElement;
    private IWorkbenchWindowPulldownDelegate delegate = null;
    private final String delegateAttributeName;
    private Widget widget = null;
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget == PulldownDelegateWidgetProxy.this.widget) {
                PulldownDelegateWidgetProxy.this.dispose();
                PulldownDelegateWidgetProxy.this.widget = null;
            }
        }
    };

    public PulldownDelegateWidgetProxy(IConfigurationElement configurationElement, String delegateAttributeName) {
        if (configurationElement == null) {
            throw new NullPointerException("The configuration element backing a handler proxy cannot be null");
        }
        if (delegateAttributeName == null) {
            throw new NullPointerException("The attribute containing the handler class must be known");
        }
        this.configurationElement = configurationElement;
        this.delegateAttributeName = delegateAttributeName;
    }

    public final void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public void fill(Composite parent) {
    }

    public void fill(CoolBar parent, int index) {
    }

    public final void fill(Menu parent, int index) {
        MenuItem menuItem = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
        menuItem.setData((Object)this);
        this.widget = menuItem;
        if (this.loadDelegate() && this.delegate instanceof IWorkbenchWindowPulldownDelegate2) {
            IWorkbenchWindowPulldownDelegate2 delegate2 = (IWorkbenchWindowPulldownDelegate2)this.delegate;
            MenuLoader loader = new MenuLoader(delegate2, parent);
            Platform.run((ISafeRunnable)loader);
            Menu subMenu = loader.getMenu();
            if (subMenu != null) {
                menuItem.setMenu(subMenu);
            }
        }
        menuItem.addDisposeListener(this.disposeListener);
    }

    public void fill(ToolBar parent, int index) {
        ToolItem toolItem = index >= 0 ? new ToolItem(parent, 4, index) : new ToolItem(parent, 4);
        this.widget = toolItem;
        toolItem.setData((Object)this);
        toolItem.addDisposeListener(this.disposeListener);
    }

    private final boolean loadDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (IWorkbenchWindowPulldownDelegate)this.configurationElement.createExecutableExtension(this.delegateAttributeName);
                this.configurationElement = null;
                return true;
            }
            catch (ClassCastException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied delegate was the wrong class", (Throwable)e);
                WorkbenchPlugin.log("The proxied delegate was the wrong class", (IStatus)status);
                return false;
            }
            catch (CoreException e) {
                String message = "The proxied delegate for '" + this.configurationElement.getAttribute(this.delegateAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                WorkbenchPlugin.log(message, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    public final String toString() {
        if (this.delegate == null) {
            return this.configurationElement.getAttribute(this.delegateAttributeName);
        }
        return this.delegate.toString();
    }

    private static final class MenuLoader
    implements ISafeRunnable {
        private final Control control;
        private final IWorkbenchWindowPulldownDelegate delegate;
        private Menu menu = null;
        private final Menu parent;

        MenuLoader(IWorkbenchWindowPulldownDelegate2 delegate, Menu parent) {
            this.delegate = delegate;
            this.parent = parent;
            this.control = null;
        }

        MenuLoader(IWorkbenchWindowPulldownDelegate delegate, Control parent) {
            this.delegate = delegate;
            this.parent = null;
            this.control = parent;
        }

        private Menu getMenu() {
            return this.menu;
        }

        public void handleException(Throwable exception) {
        }

        public void run() throws Exception {
            this.menu = this.parent == null ? this.delegate.getMenu(this.control) : ((IWorkbenchWindowPulldownDelegate2)this.delegate).getMenu(this.parent);
        }
    }
}

