/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

public final class SOrder {
    static final int NO_POSITION = -1;
    public static final int POSITION_START = 0;
    public static final int POSITION_END = 1;
    public static final int POSITION_BEFORE = 2;
    public static final int POSITION_AFTER = 3;
    private final int position;
    private final String relativeTo;

    public SOrder(int position) {
        this(position, null);
    }

    public SOrder(int position, String relativeTo) {
        if (position < 0 || position > 3) {
            throw new IllegalArgumentException("A location needs a valid position.  Got: " + position);
        }
        if (position == 3 || position == 2) {
            if (relativeTo == null) {
                throw new NullPointerException("A location positioned before or after needs an identifier of the menu element to which the position is relative");
            }
        } else if (relativeTo != null) {
            throw new IllegalArgumentException("A relative identifier was provided for a non-relative position");
        }
        this.position = position;
        this.relativeTo = relativeTo;
    }

    public final int getPosition() {
        return this.position;
    }

    public final String getRelativeTo() {
        return this.relativeTo;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SOrder(");
        switch (this.position) {
            case 3: {
                buffer.append("after");
                break;
            }
            case 2: {
                buffer.append("before");
                break;
            }
            case 1: {
                buffer.append("end");
                break;
            }
            case 0: {
                buffer.append("start");
                break;
            }
            default: {
                buffer.append("unknown");
            }
        }
        buffer.append(',');
        buffer.append(this.relativeTo);
        buffer.append(')');
        return buffer.toString();
    }
}

