/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLSearchParticipant
extends LuceneSearchParticipant {
    private Stack stack = new Stack();
    private SAXParser parser;

    protected abstract void handleStartElement(String var1, Attributes var2, IParsedXMLContent var3);

    protected abstract void handleEndElement(String var1, IParsedXMLContent var2);

    protected void handleStartDocument(IParsedXMLContent data) {
    }

    protected void handleEndDocument(IParsedXMLContent data) {
    }

    protected void handleProcessingInstruction(String type, IParsedXMLContent data) {
    }

    protected abstract void handleText(String var1, IParsedXMLContent var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        IStatus iStatus;
        InputStream stream = null;
        try {
            try {
                String summary;
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                this.stack.clear();
                ParsedXMLContent parsed = new ParsedXMLContent(index.getLocale());
                XMLHandler handler = new XMLHandler(parsed);
                stream = url.openStream();
                this.parser.parse(stream, (DefaultHandler)handler);
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = parsed.getTitle();
                if (title != null) {
                    this.addTitle(title, doc);
                }
                if ((summary = parsed.getSummary()) != null) {
                    doc.add(Field.UnIndexed((String)"summary", (String)summary));
                }
                iStatus = Status.OK_STATUS;
                Object var12_15 = null;
                if (stream == null) return iStatus;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.help.base", 4, "Exception occurred while adding document " + name + " to index.", (Throwable)e);
                Object var12_16 = null;
                if (stream == null) return status;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (stream == null) throw throwable;
            try {}
            catch (IOException iOException) {}
            stream.close();
            stream = null;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        stream.close();
        stream = null;
        return iStatus;
    }

    protected String getTopElement() {
        return (String)this.stack.peek();
    }

    protected String getElementStackPath() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.stack.size()) {
            if (i > 0) {
                buf.append("/");
            }
            buf.append((String)this.stack.get(i));
            ++i;
        }
        return buf.toString();
    }

    protected static interface IParsedXMLContent {
        public String getLocale();

        public void setTitle(String var1);

        public void addToSummary(String var1);

        public void addText(String var1);
    }

    private static class ParsedXMLContent
    implements IParsedXMLContent {
        private StringBuffer buffer = new StringBuffer();
        private StringBuffer summary = new StringBuffer();
        private String title;
        private String locale;
        private static int SUMMARY_LENGTH = 200;

        public ParsedXMLContent(String locale) {
            this.locale = locale;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void addToSummary(String text) {
            if (this.summary.length() >= SUMMARY_LENGTH) {
                return;
            }
            if (this.summary.length() > 0) {
                this.summary.append(" ");
            }
            this.summary.append(text);
            if (this.summary.length() > SUMMARY_LENGTH) {
                this.summary.delete(SUMMARY_LENGTH, this.summary.length());
            }
        }

        public void addText(String text) {
            if (this.buffer.length() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(text);
        }

        public Reader newContentReader() {
            return new StringReader(this.buffer.toString());
        }

        public String getSummary() {
            return this.summary.toString();
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        public ParsedXMLContent data;

        public XMLHandler(ParsedXMLContent data) {
            this.data = data;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XMLSearchParticipant.this.stack.push(qName);
            XMLSearchParticipant.this.handleStartElement(qName, attributes, this.data);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XMLSearchParticipant.this.handleEndElement(qName, this.data);
            String top = (String)XMLSearchParticipant.this.stack.peek();
            if (top != null && top.equals(qName)) {
                XMLSearchParticipant.this.stack.pop();
            }
        }

        public void startDocument() throws SAXException {
            XMLSearchParticipant.this.handleStartDocument(this.data);
        }

        public void endDocument() throws SAXException {
            XMLSearchParticipant.this.handleEndDocument(this.data);
        }

        public void processingInstruction(String target, String pidata) throws SAXException {
            XMLSearchParticipant.this.handleProcessingInstruction(target, this.data);
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            if (length == 0) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < length) {
                buff.append(characters[start + i]);
                ++i;
            }
            String text = buff.toString().trim();
            if (text.length() > 0) {
                XMLSearchParticipant.this.handleText(text, this.data);
            }
        }
    }
}

