/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class SystemTestExpression
extends Expression {
    private String fProperty;
    private String fExpectedValue;
    private static final String ATT_PROPERTY = "property";

    public SystemTestExpression(IConfigurationElement element) throws CoreException {
        this.fProperty = element.getAttribute(ATT_PROPERTY);
        Expressions.checkAttribute(ATT_PROPERTY, this.fProperty);
        this.fExpectedValue = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fExpectedValue);
    }

    public SystemTestExpression(String property, String expectedValue) {
        this.fProperty = property;
        this.fExpectedValue = expectedValue;
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        String str = System.getProperty(this.fProperty);
        if (str == null) {
            return EvaluationResult.FALSE;
        }
        return EvaluationResult.valueOf(str.equals(this.fExpectedValue));
    }

    public void collectExpressionInfo(ExpressionInfo info) {
        info.markSystemPropertyAccessed();
    }

    public String toString() {
        return "<systemTest property=\"" + this.fProperty + "\" value=\"" + this.fExpectedValue + "\"";
    }
}

