/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class RefactoringDescriptor
implements Comparable {
    public static final int BREAKING_CHANGE = 1;
    public static final String ELEMENT = "element";
    public static final String INPUT = "input";
    public static final int MULTI_CHANGE = 4;
    public static final String NAME = "name";
    public static final int NONE = 0;
    public static final int PROJECT_CHANGE = 8;
    public static final int STRUCTURAL_CHANGE = 2;
    public static final int USER_CHANGE = 256;
    private final Map fArguments;
    private String fComment;
    private final String fDescription;
    private final int fFlags;
    private final String fID;
    private final String fProject;
    private long fTimeStamp = -1L;

    public RefactoringDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        Assert.isTrue((id != null && !"".equals(id) ? 1 : 0) != 0);
        Assert.isTrue((description != null && !"".equals(description) ? 1 : 0) != 0);
        Assert.isTrue((project == null || !"".equals(project) ? 1 : 0) != 0);
        Assert.isNotNull((Object)arguments);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        this.fID = id;
        this.fProject = project;
        this.fDescription = description;
        this.fComment = comment;
        this.fArguments = Collections.unmodifiableMap(new HashMap(arguments));
        this.fFlags = flags;
    }

    public final int compareTo(Object object) {
        if (object instanceof RefactoringDescriptor) {
            RefactoringDescriptor descriptor = (RefactoringDescriptor)object;
            return (int)(this.fTimeStamp - descriptor.fTimeStamp);
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (object instanceof RefactoringDescriptor) {
            RefactoringDescriptor descriptor = (RefactoringDescriptor)object;
            return this.fTimeStamp == descriptor.fTimeStamp && this.fDescription.equals(descriptor.fDescription);
        }
        return false;
    }

    public final Map getArguments() {
        return this.fArguments;
    }

    public final String getComment() {
        return this.fComment != null ? this.fComment : "";
    }

    public final String getDescription() {
        return this.fDescription;
    }

    public final int getFlags() {
        return this.fFlags;
    }

    public final String getID() {
        return this.fID;
    }

    public final String getProject() {
        return this.fProject;
    }

    public final long getTimeStamp() {
        return this.fTimeStamp;
    }

    public final int hashCode() {
        int code = this.fDescription.hashCode();
        if (this.fTimeStamp >= 0L) {
            code = (int)((long)code + 17L * this.fTimeStamp);
        }
        return code;
    }

    public boolean isUnknown() {
        return false;
    }

    public final void setComment(String comment) {
        this.fComment = comment;
    }

    public final void setTimeStamp(long stamp) {
        Assert.isTrue((stamp >= 0L ? 1 : 0) != 0);
        this.fTimeStamp = stamp;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getClass().getName());
        if (this.isUnknown()) {
            buffer.append("[unknown refactoring]");
        } else {
            buffer.append("[timeStamp=");
            buffer.append(this.fTimeStamp);
            buffer.append(",id=");
            buffer.append(this.fID);
            buffer.append(",description=");
            buffer.append(this.fDescription);
            buffer.append(",project=");
            buffer.append(this.fProject);
            buffer.append(",arguments=");
            buffer.append(this.fArguments);
            buffer.append(",comment=");
            buffer.append(this.fComment);
            buffer.append(",flags=");
            buffer.append(this.fFlags);
            buffer.append("]");
        }
        return buffer.toString();
    }
}

