/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public abstract class RefactoringDescriptorProxy
extends PlatformObject
implements Comparable {
    public int compareTo(Object object) {
        if (object instanceof RefactoringDescriptorProxy) {
            RefactoringDescriptorProxy proxy = (RefactoringDescriptorProxy)object;
            return (int)(this.getTimeStamp() - proxy.getTimeStamp());
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (object instanceof RefactoringDescriptorProxy) {
            RefactoringDescriptorProxy proxy = (RefactoringDescriptorProxy)object;
            return this.getTimeStamp() == proxy.getTimeStamp() && this.getDescription().equals(proxy.getDescription());
        }
        return false;
    }

    public abstract String getDescription();

    public abstract String getProject();

    public abstract long getTimeStamp();

    public final int hashCode() {
        int code = this.getDescription().hashCode();
        long stamp = this.getTimeStamp();
        if (stamp >= 0L) {
            code = (int)((long)code + 17L * stamp);
        }
        return code;
    }

    public RefactoringDescriptor requestDescriptor(IProgressMonitor monitor) {
        return RefactoringHistoryService.getInstance().requestDescriptor(this, monitor);
    }
}

