/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class RefactoringStatusEntry {
    public static final int NO_CODE = -1;
    private final int fSeverity;
    private final String fMessage;
    private final int fCode;
    private final String fPluginId;
    private final RefactoringStatusContext fContext;
    private final Object fData;

    public RefactoringStatusEntry(int severity, String msg) {
        this(severity, msg, null);
    }

    public RefactoringStatusEntry(int severity, String msg, RefactoringStatusContext context) {
        this(severity, msg, context, null, -1, null);
    }

    public RefactoringStatusEntry(int severity, String msg, RefactoringStatusContext context, String pluginId, int code) {
        this(severity, msg, context, pluginId, code, null);
    }

    public RefactoringStatusEntry(int severity, String msg, RefactoringStatusContext context, String pluginId, int code, Object data) {
        Assert.isTrue((severity == 1 || severity == 2 || severity == 3 || severity == 4 ? 1 : 0) != 0);
        Assert.isNotNull((Object)msg);
        Assert.isTrue((code == -1 || code >= 0 ? 1 : 0) != 0);
        if (code != -1) {
            Assert.isTrue((pluginId != null ? 1 : 0) != 0);
        }
        this.fMessage = msg;
        this.fSeverity = severity;
        this.fContext = context;
        this.fPluginId = pluginId;
        this.fCode = code;
        this.fData = data;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public RefactoringStatusContext getContext() {
        return this.fContext;
    }

    public String getPluginId() {
        return this.fPluginId;
    }

    public int getCode() {
        return this.fCode;
    }

    public Object getData() {
        return this.fData;
    }

    public boolean isFatalError() {
        return this.fSeverity == 4;
    }

    public boolean isError() {
        return this.fSeverity == 3;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public String toString() {
        String contextString = this.fContext == null ? "<Unspecified context>" : this.fContext.toString();
        return "\n" + RefactoringStatus.getSeverityString(this.fSeverity) + ": " + this.fMessage + "\nContext: " + contextString + (this.fCode == -1 ? "\ncode: none" : "\nplug-in id: " + this.fPluginId + "code: " + this.fCode) + "\nData: " + this.fData;
    }
}

