/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.UndoableOperation2ChangeAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringSessionReader;
import org.xml.sax.InputSource;

public final class RefactoringHistoryService
implements IRefactoringHistoryService {
    private static RefactoringHistoryService fInstance = null;
    private static final int MAX_UNDO_STACK = 5;
    public static final String NAME_HISTORY_FILE = "refactorings.history";
    public static final String NAME_HISTORY_FOLDER = ".refactorings";
    public static final String NAME_INDEX_FILE = "refactorings.index";
    public static final String NAME_WORKSPACE_PROJECT = ".workspace";
    private static final NullRefactoringHistory NO_HISTORY = new NullRefactoringHistory();
    private static final String UNKNOWN_REFACTORING_ID = "org.eclipse.ltk.core.refactoring.unknown.refactoring";
    private final List fExecutionListeners = new ArrayList(2);
    private final List fHistoryListeners = new ArrayList(2);
    private IOperationHistoryListener fOperationListener = null;
    private long fOverrideTimeStamp = -1L;
    private LinkedList fRedoQueue = null;
    private int fReferenceCount = 0;
    private IResourceChangeListener fResourceListener = null;
    private RefactoringDescriptorStack fUndoStack = null;
    private final RefactoringDescriptor fUnknownDescriptor = new UnknownRefactoringDescriptor();
    private final RefactoringDescriptorProxy fUnknownProxy = new RefactoringDescriptorProxyAdapter(this.fUnknownDescriptor);

    public static RefactoringHistoryService getInstance() {
        if (fInstance == null) {
            fInstance = new RefactoringHistoryService();
        }
        return fInstance;
    }

    private RefactoringHistoryService() {
    }

    public void addExecutionListener(IRefactoringExecutionListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fExecutionListeners.contains(listener)) {
            this.fExecutionListeners.add(listener);
        }
    }

    public void addHistoryListener(IRefactoringHistoryListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fHistoryListeners.contains(listener)) {
            this.fHistoryListeners.add(listener);
        }
    }

    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.fOperationListener = new RefactoringOperationHistoryListener();
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.fOperationListener);
            this.fResourceListener = new WorkspaceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceListener, 7);
            this.fUndoStack = new RefactoringDescriptorStack();
            this.fRedoQueue = new LinkedList();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IRefactoringDescriptorDeleteQuery query, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        Assert.isNotNull((Object)query);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", proxies.length);
            int index = 0;
            while (index < proxies.length) {
                if (query.proceed(proxies[index]).isOK()) {
                    this.fireRefactoringDeletedEvent(proxies[index]);
                }
                monitor.worked(1);
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRefactoringHistory(IProject project, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)project);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100);
            String name = project.getName();
            IFileStore stateStore = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation());
            if (name.equals(NAME_WORKSPACE_PROJECT)) {
                IFileStore metaStore = stateStore.getChild(NAME_HISTORY_FOLDER).getChild(name);
                metaStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            } else {
                URI uri = project.getLocationURI();
                if (uri != null && project.isAccessible()) {
                    try {
                        IFileStore metaStore = stateStore.getChild(NAME_HISTORY_FOLDER).getChild(name);
                        metaStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        IFileStore projectStore = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                        projectStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        Object var8_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                        throw throwable;
                    }
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                }
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void disconnect() {
        if (this.fReferenceCount > 0) {
            this.fUndoStack.fManagerCache.clear();
            --this.fReferenceCount;
        }
        if (this.fReferenceCount == 0) {
            if (this.fOperationListener != null) {
                OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.fOperationListener);
            }
            if (this.fResourceListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceListener);
            }
            this.fUndoStack = null;
            this.fRedoQueue = null;
            this.fOperationListener = null;
        }
    }

    void fireAboutToPerformEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fExecutionListeners.size()) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)this.fExecutionListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public final void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 4, proxy));
                }
            });
            ++index;
        }
    }

    void fireAboutToRedoEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fExecutionListeners.size()) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)this.fExecutionListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 6, proxy));
                }
            });
            ++index;
        }
    }

    void fireAboutToUndoEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fExecutionListeners.size()) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)this.fExecutionListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 5, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringDeletedEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fHistoryListeners.size()) {
            final IRefactoringHistoryListener listener = (IRefactoringHistoryListener)this.fHistoryListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.historyNotification(new RefactoringHistoryEvent(RefactoringHistoryService.this, 3, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringPerformedEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fExecutionListeners.size()) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)this.fExecutionListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 1, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringRedoneEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fExecutionListeners.size()) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)this.fExecutionListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 3, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringUndoneEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        int index = 0;
        while (index < this.fExecutionListeners.size()) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)this.fExecutionListeners.get(index);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 2, proxy));
                }
            });
            ++index;
        }
    }

    public RefactoringHistory getProjectHistory(IProject project, IProgressMonitor monitor) {
        return this.getProjectHistory(project, 0L, Long.MAX_VALUE, 0, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringHistory getProjectHistory(IProject project, long start, long end, int flags, IProgressMonitor monitor) {
        block7: {
            RefactoringHistory refactoringHistory;
            block9: {
                RefactoringHistory refactoringHistory2;
                block8: {
                    Assert.isNotNull((Object)project);
                    Assert.isTrue((boolean)project.exists());
                    Assert.isTrue((start >= 0L ? 1 : 0) != 0);
                    Assert.isTrue((end >= 0L ? 1 : 0) != 0);
                    Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
                    if (!project.isOpen()) return NO_HISTORY;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 12);
                            String name = project.getName();
                            if (this.hasSharedRefactoringHistory(project)) {
                                URI uri = project.getLocationURI();
                                if (uri == null) break block7;
                                refactoringHistory2 = this.fUndoStack.getManager(EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER), name).readRefactoringHistory(start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 12));
                                Object var10_11 = null;
                                break block8;
                            }
                            refactoringHistory = this.fUndoStack.getManager(EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER).getChild(name), name).readRefactoringHistory(start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 12));
                            break block9;
                        }
                        catch (CoreException exception) {
                            RefactoringCorePlugin.log(exception);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return refactoringHistory2;
            }
            Object var10_12 = null;
            monitor.done();
            return refactoringHistory;
        }
        Object var10_14 = null;
        monitor.done();
        return NO_HISTORY;
    }

    public RefactoringHistory getRefactoringHistory(IProject[] projects, IProgressMonitor monitor) {
        return this.getRefactoringHistory(projects, 0L, Long.MAX_VALUE, 0, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringHistory getRefactoringHistory(IProject[] projects, long start, long end, int flags, IProgressMonitor monitor) {
        block13: {
            Assert.isNotNull((Object)projects);
            Assert.isTrue((boolean)(start >= 0L));
            Assert.isTrue((boolean)(end >= start));
            Assert.isTrue((boolean)(flags >= 0));
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                block14: {
                    monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 2 * projects.length);
                    set = new HashSet<RefactoringDescriptorProxy>();
                    v0 = flagged = flags > 0;
                    if (!flagged) break block14;
                    index = 0;
                    if (true) ** GOTO lbl60
                }
                index = 0;
                while (index < projects.length) {
                    project = projects[index];
                    if (project.isAccessible()) {
                        proxies = this.getProjectHistory(project, start, end, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 2)).getDescriptors();
                        offset = 0;
                        while (offset < proxies.length) {
                            set.add(proxies[offset]);
                            ++offset;
                        }
                    }
                    ++index;
                }
                break block13;
            }
            catch (Throwable var20_24) {
                var19_23 = null;
                monitor.done();
                throw var20_24;
            }
            do {
                if ((project = projects[index]).isAccessible()) {
                    proxies = this.getProjectHistory(project, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 1)).getDescriptors();
                    subMonitor = new SubProgressMonitor(monitor, 1);
                    try {
                        subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, proxies.length);
                        offset = 0;
                        while (offset < proxies.length) {
                            descriptor = proxies[offset].requestDescriptor((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                            if (descriptor != null && ((filter = descriptor.getFlags()) | flags) == filter) {
                                set.add(proxies[offset]);
                            }
                            ++offset;
                        }
                    }
                    catch (Throwable var18_20) {
                        var17_19 = null;
                        subMonitor.done();
                        throw var18_20;
                    }
                    {
                        var17_19 = null;
                    }
                    subMonitor.done();
                }
                ++index;
lbl60:
                // 2 sources

            } while (index < projects.length);
        }
        proxies = new RefactoringDescriptorProxy[set.size()];
        set.toArray(proxies);
        var21_21 = new RefactoringHistoryImplementation(proxies);
        var19_22 = null;
        monitor.done();
        return var21_21;
    }

    public RefactoringHistory getWorkspaceHistory(IProgressMonitor monitor) {
        return this.getWorkspaceHistory(0L, Long.MAX_VALUE, monitor);
    }

    public RefactoringHistory getWorkspaceHistory(long start, long end, IProgressMonitor monitor) {
        return this.getRefactoringHistory(ResourcesPlugin.getWorkspace().getRoot().getProjects(), start, end, 0, monitor);
    }

    public boolean hasSharedRefactoringHistory(IProject project) {
        Assert.isNotNull((Object)project);
        IScopeContext[] contexts = new IScopeContext[]{new ProjectScope(project)};
        String preference = Platform.getPreferencesService().getString(RefactoringCorePlugin.getPluginId(), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.FALSE.toString(), contexts);
        if (preference != null) {
            return Boolean.valueOf(preference);
        }
        return false;
    }

    public RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream, int flags) throws CoreException {
        Assert.isNotNull((Object)stream);
        try {
            return RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, null, 0L, Long.MAX_VALUE, flags);
        }
        catch (IOException exception) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
        }
    }

    public RefactoringHistory readRefactoringHistory(InputStream stream, int flags) throws CoreException {
        int index;
        Assert.isNotNull((Object)stream);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>();
        RefactoringSessionDescriptor descriptor = new RefactoringSessionReader().readSession(new InputSource(stream));
        if (descriptor != null) {
            RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
            if (flags > 0) {
                index = 0;
                while (index < descriptors.length) {
                    int current = descriptors[index].getFlags();
                    if ((current | flags) == current) {
                        list.add(descriptors[index]);
                    }
                    ++index;
                }
            } else {
                list.addAll(Arrays.asList(descriptors));
            }
        }
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[list.size()];
        index = 0;
        while (index < list.size()) {
            proxies[index] = new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)list.get(index));
            ++index;
        }
        return new RefactoringHistoryImplementation(proxies);
    }

    public void removeExecutionListener(IRefactoringExecutionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fExecutionListeners.remove(listener);
    }

    public void removeHistoryListener(IRefactoringHistoryListener listener) {
        Assert.isNotNull((Object)listener);
        this.fHistoryListeners.remove(listener);
    }

    public RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        Assert.isNotNull((Object)proxy);
        Assert.isNotNull((Object)this.fUndoStack);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.fUndoStack.requestDescriptor(proxy, monitor);
    }

    public void setOverrideTimeStamp(long stamp) {
        Assert.isTrue((stamp == -1L || stamp >= 0L ? 1 : 0) != 0);
        this.fOverrideTimeStamp = stamp;
    }

    public void setRefactoringComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxy);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fUndoStack.setComment(proxy, comment, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSharedRefactoringHistory(IProject project, boolean enable, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)project);
        Assert.isTrue((boolean)project.isAccessible());
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            block17: {
                monitor.beginTask("", 300);
                String name = project.getName();
                URI uri = project.getLocationURI();
                if (uri != null) {
                    block16: {
                        try {
                            if (enable) {
                                IFileStore source = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER).getChild(name);
                                if (source.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                    IFileStore destination = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                                    if (destination.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                        destination.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                    }
                                    destination.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                    source.copy(destination, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                    source.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                }
                            } else {
                                IFileStore source = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                                if (source.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                    IFileStore destination = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER).getChild(name);
                                    if (destination.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                        destination.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                    }
                                    destination.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                    source.copy(destination, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                    source.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                                }
                            }
                            Object var8_12 = null;
                            if (!enable) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var8_11 = null;
                            if (enable) {
                                project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                                throw throwable;
                            }
                            IFolder folder = project.getFolder(NAME_HISTORY_FOLDER);
                            if (!folder.exists()) throw throwable;
                            folder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                            throw throwable;
                        }
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        break block17;
                    }
                    IFolder folder = project.getFolder(NAME_HISTORY_FOLDER);
                    if (folder.exists()) {
                        folder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    }
                }
            }
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, OutputStream stream, int flags, boolean time, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        Assert.isNotNull((Object)stream);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100 * proxies.length);
            this.connect();
            ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>(proxies.length);
            int index = 0;
            while (true) {
                int current;
                block6: {
                    if (index < proxies.length) break block6;
                    RefactoringDescriptor[] descriptors = new RefactoringDescriptor[list.size()];
                    list.toArray(descriptors);
                    RefactoringHistoryManager.writeRefactoringDescriptors(stream, descriptors, time);
                    break;
                }
                RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (descriptor != null && ((current = descriptor.getFlags()) | flags) == current) {
                    list.add(descriptor);
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.disconnect();
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.disconnect();
            return;
        }
    }

    public void writeRefactoringSession(RefactoringSessionDescriptor descriptor, OutputStream stream, boolean time) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        Assert.isNotNull((Object)stream);
        RefactoringHistoryManager.writeRefactoringSession(stream, descriptor, time);
    }

    private static final class NullRefactoringHistory
    extends RefactoringHistory {
        private static final RefactoringDescriptorProxy[] NO_PROXIES = new RefactoringDescriptorProxy[0];

        NullRefactoringHistory() {
        }

        public RefactoringDescriptorProxy[] getDescriptors() {
            return NO_PROXIES;
        }

        public boolean isEmpty() {
            return true;
        }

        public RefactoringHistory removeAll(RefactoringHistory history) {
            return this;
        }
    }

    private final class RefactoringDescriptorStack {
        private static final int MAX_MANAGERS = 2;
        private final LinkedList fImplementation = new LinkedList();
        private final Map fManagerCache = new LinkedHashMap(this, 2, 0.75f, true){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ RefactoringDescriptorStack this$1;
            {
                this.this$1 = refactoringDescriptorStack;
            }

            protected final boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > 2;
            }
        };

        RefactoringDescriptorStack() {
        }

        private RefactoringHistoryManager getManager(IFileStore store, String name) {
            Assert.isNotNull((Object)store);
            RefactoringHistoryManager manager = (RefactoringHistoryManager)this.fManagerCache.get(store);
            if (manager == null) {
                manager = new RefactoringHistoryManager(store, name);
                this.fManagerCache.put(store, manager);
            }
            return manager;
        }

        private RefactoringDescriptor peek() throws EmptyStackException {
            if (!this.fImplementation.isEmpty()) {
                return (RefactoringDescriptor)this.fImplementation.getFirst();
            }
            throw new EmptyStackException();
        }

        private void pop() throws EmptyStackException {
            RefactoringDescriptor descriptor = this.peek();
            if (this.fImplementation.isEmpty()) {
                throw new EmptyStackException();
            }
            this.fImplementation.removeFirst();
            int index = 0;
            while (index < RefactoringHistoryService.this.fHistoryListeners.size()) {
                IRefactoringHistoryListener listener = (IRefactoringHistoryListener)RefactoringHistoryService.this.fHistoryListeners.get(index);
                Platform.run((ISafeRunnable)new ISafeRunnable(this, listener, descriptor){
                    final /* synthetic */ RefactoringDescriptorStack this$1;
                    private final /* synthetic */ IRefactoringHistoryListener val$listener;
                    private final /* synthetic */ RefactoringDescriptor val$descriptor;
                    {
                        this.this$1 = refactoringDescriptorStack;
                        this.val$listener = iRefactoringHistoryListener;
                        this.val$descriptor = refactoringDescriptor;
                    }

                    public void handleException(Throwable throwable) {
                        RefactoringCorePlugin.log(throwable);
                    }

                    public void run() throws Exception {
                        this.val$listener.historyNotification(new RefactoringHistoryEvent(RefactoringDescriptorStack.access$8(this.this$1), 2, new RefactoringDescriptorProxyAdapter(this.val$descriptor)));
                    }
                });
                ++index;
            }
        }

        private void push(RefactoringDescriptor descriptor) {
            Assert.isNotNull((Object)descriptor);
            this.fImplementation.addFirst(descriptor);
            int size = this.fImplementation.size();
            if (size > 5) {
                this.fImplementation.removeLast();
            }
            int index = 0;
            while (index < RefactoringHistoryService.this.fHistoryListeners.size()) {
                IRefactoringHistoryListener listener = (IRefactoringHistoryListener)RefactoringHistoryService.this.fHistoryListeners.get(index);
                Platform.run((ISafeRunnable)new ISafeRunnable(this, listener, descriptor){
                    final /* synthetic */ RefactoringDescriptorStack this$1;
                    private final /* synthetic */ IRefactoringHistoryListener val$listener;
                    private final /* synthetic */ RefactoringDescriptor val$descriptor;
                    {
                        this.this$1 = refactoringDescriptorStack;
                        this.val$listener = iRefactoringHistoryListener;
                        this.val$descriptor = refactoringDescriptor;
                    }

                    public void handleException(Throwable throwable) {
                        RefactoringCorePlugin.log(throwable);
                    }

                    public void run() throws Exception {
                        this.val$listener.historyNotification(new RefactoringHistoryEvent(RefactoringDescriptorStack.access$8(this.this$1), 1, new RefactoringDescriptorProxyAdapter(this.val$descriptor)));
                    }
                });
                ++index;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
            RefactoringDescriptor refactoringDescriptor;
            block16: {
                RefactoringDescriptor refactoringDescriptor2;
                block15: {
                    RefactoringDescriptor refactoringDescriptor3;
                    block14: {
                        RefactoringDescriptor refactoringDescriptor4;
                        block13: {
                            Assert.isNotNull((Object)proxy);
                            Assert.isNotNull((Object)monitor);
                            try {
                                RefactoringDescriptor descriptor;
                                block12: {
                                    monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_resolving_information, 12);
                                    long stamp = proxy.getTimeStamp();
                                    descriptor = null;
                                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 4);
                                    try {
                                        subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_resolving_information, this.fImplementation.size());
                                        Iterator iterator = this.fImplementation.iterator();
                                        while (iterator.hasNext()) {
                                            subMonitor.worked(1);
                                            RefactoringDescriptor existing = (RefactoringDescriptor)iterator.next();
                                            long time = existing.getTimeStamp();
                                            if (time < 0L || time != stamp) continue;
                                            descriptor = existing;
                                            break;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_11 = null;
                                        subMonitor.done();
                                        throw throwable;
                                    }
                                    {
                                        Object var11_12 = null;
                                    }
                                    subMonitor.done();
                                    if (monitor.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    monitor.worked(1);
                                    if (descriptor == null) {
                                        String name = proxy.getProject();
                                        IFileStore store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER);
                                        if (name != null && !"".equals(name)) {
                                            try {
                                                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                                                if (!project.isAccessible()) break block12;
                                                if (RefactoringHistoryService.this.hasSharedRefactoringHistory(project)) {
                                                    URI uri = project.getLocationURI();
                                                    if (uri == null) break block12;
                                                    refactoringDescriptor4 = this.getManager(EFS.getStore((URI)uri).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER), name).requestDescriptor(proxy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                                    Object var13_18 = null;
                                                    break block13;
                                                }
                                                refactoringDescriptor3 = this.getManager(store.getChild(name), name).requestDescriptor(proxy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                                break block14;
                                            }
                                            catch (CoreException coreException) {
                                                break block12;
                                            }
                                        }
                                        refactoringDescriptor2 = this.getManager(store.getChild(RefactoringHistoryService.NAME_WORKSPACE_PROJECT), null).requestDescriptor(proxy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        break block15;
                                    }
                                }
                                monitor.worked(6);
                                refactoringDescriptor = descriptor;
                                break block16;
                            }
                            catch (Throwable throwable) {
                                Object var13_22 = null;
                                monitor.done();
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return refactoringDescriptor4;
                    }
                    Object var13_19 = null;
                    monitor.done();
                    return refactoringDescriptor3;
                }
                Object var13_20 = null;
                monitor.done();
                return refactoringDescriptor2;
            }
            Object var13_21 = null;
            monitor.done();
            return refactoringDescriptor;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
            Assert.isNotNull((Object)proxy);
            Assert.isNotNull((Object)comment);
            Assert.isNotNull((Object)monitor);
            try {
                block13: {
                    IFileStore store;
                    block12: {
                        monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 11);
                        long stamp = proxy.getTimeStamp();
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 4);
                        try {
                            subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, this.fImplementation.size());
                            Iterator iterator = this.fImplementation.iterator();
                            while (iterator.hasNext()) {
                                RefactoringDescriptor descriptor = (RefactoringDescriptor)iterator.next();
                                subMonitor.worked(1);
                                if (descriptor.getTimeStamp() != stamp) continue;
                                descriptor.setComment(comment);
                                break;
                            }
                            Object var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            subMonitor.done();
                            throw throwable;
                        }
                        subMonitor.done();
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        String name = proxy.getProject();
                        store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER);
                        if (name == null || "".equals(name)) break block12;
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (project.isAccessible()) {
                            if (RefactoringHistoryService.this.hasSharedRefactoringHistory(project)) {
                                URI uri = project.getLocationURI();
                                if (uri != null) {
                                    this.getManager(EFS.getStore((URI)uri).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER), name).setComment(proxy, comment, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                }
                                break block13;
                            } else {
                                this.getManager(store.getChild(name), name).setComment(proxy, comment, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }
                        }
                        break block13;
                    }
                    this.getManager(store.getChild(RefactoringHistoryService.NAME_WORKSPACE_PROJECT), null).setComment(proxy, comment, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }

        static /* synthetic */ RefactoringHistoryService access$8(RefactoringDescriptorStack refactoringDescriptorStack) {
            return refactoringDescriptorStack.RefactoringHistoryService.this;
        }
    }

    private final class RefactoringOperationHistoryListener
    implements IOperationHistoryListener {
        private RefactoringDescriptor fDescriptor = null;

        RefactoringOperationHistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            IUndoableOperation operation = event.getOperation();
            if (operation instanceof TriggeredOperations) {
                operation = ((TriggeredOperations)operation).getTriggeringOperation();
            }
            UndoableOperation2ChangeAdapter adapter = null;
            if (operation instanceof UndoableOperation2ChangeAdapter) {
                adapter = (UndoableOperation2ChangeAdapter)operation;
            }
            if (adapter != null) {
                Change change = adapter.getChange();
                switch (event.getEventType()) {
                    case 1: {
                        this.fDescriptor = change.getRefactoringDescriptor();
                        if (this.fDescriptor != null) {
                            RefactoringHistoryService.this.fireAboutToPerformEvent(new RefactoringDescriptorProxyAdapter(this.fDescriptor));
                            break;
                        }
                        RefactoringHistoryService.this.fireAboutToPerformEvent(RefactoringHistoryService.this.fUnknownProxy);
                        break;
                    }
                    case 4: {
                        if (this.fDescriptor != null) {
                            if (RefactoringHistoryService.this.fOverrideTimeStamp >= 0L) {
                                this.fDescriptor.setTimeStamp(RefactoringHistoryService.this.fOverrideTimeStamp);
                            } else {
                                this.fDescriptor.setTimeStamp(System.currentTimeMillis());
                            }
                            RefactoringHistoryService.this.fUndoStack.push(this.fDescriptor);
                            RefactoringHistoryService.this.fireRefactoringPerformedEvent(new RefactoringDescriptorProxyAdapter(this.fDescriptor));
                            this.fDescriptor = null;
                            break;
                        }
                        RefactoringHistoryService.this.fUndoStack.push(RefactoringHistoryService.this.fUnknownDescriptor);
                        RefactoringHistoryService.this.fireRefactoringPerformedEvent(RefactoringHistoryService.this.fUnknownProxy);
                        break;
                    }
                    case 3: {
                        RefactoringHistoryService.this.fireAboutToUndoEvent(new RefactoringDescriptorProxyAdapter(RefactoringHistoryService.this.fUndoStack.peek()));
                        break;
                    }
                    case 10: {
                        RefactoringHistoryService.this.fRedoQueue.addFirst(RefactoringHistoryService.this.fUndoStack.peek());
                        RefactoringHistoryService.this.fUndoStack.pop();
                        RefactoringHistoryService.this.fireRefactoringUndoneEvent(new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)RefactoringHistoryService.this.fRedoQueue.getFirst()));
                        break;
                    }
                    case 2: {
                        RefactoringHistoryService.this.fireAboutToRedoEvent(new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)RefactoringHistoryService.this.fRedoQueue.getFirst()));
                        break;
                    }
                    case 9: {
                        RefactoringHistoryService.this.fUndoStack.push((RefactoringDescriptor)RefactoringHistoryService.this.fRedoQueue.removeFirst());
                        RefactoringHistoryService.this.fireRefactoringRedoneEvent(new RefactoringDescriptorProxyAdapter(RefactoringHistoryService.this.fUndoStack.peek()));
                    }
                }
            }
        }
    }

    private static final class UnknownRefactoringDescriptor
    extends RefactoringDescriptor {
        UnknownRefactoringDescriptor() {
            super(RefactoringHistoryService.UNKNOWN_REFACTORING_ID, null, RefactoringCoreMessages.RefactoringHistoryService_unknown_refactoring_description, null, Collections.EMPTY_MAP, 0);
        }
    }

    private final class WorkspaceChangeListener
    implements IResourceChangeListener {
        WorkspaceChangeListener() {
        }

        private void removeDescriptors(IResourceChangeEvent event) {
            IProject project;
            int type;
            Assert.isNotNull((Object)event);
            IResource resource = event.getResource();
            if (resource != null && (type = resource.getType()) == 4 && (project = (IProject)resource).exists()) {
                try {
                    URI uri = project.getLocationURI();
                    if (uri != null) {
                        EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER).getChild(project.getName()).delete(0, null);
                    }
                }
                catch (CoreException exception) {
                    RefactoringCorePlugin.log(exception);
                }
            }
        }

        private void resetStacks(IResourceChangeEvent event) {
            int type;
            Assert.isNotNull((Object)event);
            IResource resource = event.getResource();
            if (resource != null && (type = resource.getType()) == 4) {
                if (RefactoringHistoryService.this.fUndoStack != null) {
                    RefactoringHistoryService.this.fUndoStack.fImplementation.clear();
                }
                if (RefactoringHistoryService.this.fRedoQueue != null) {
                    RefactoringHistoryService.this.fRedoQueue.clear();
                }
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            int type = event.getType();
            if ((type & 4) != 0) {
                this.resetStacks(event);
                this.removeDescriptors(event);
            } else if ((type & 2) != 0) {
                this.resetStacks(event);
            }
        }
    }
}

