/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class RefactoringSessionTransformer {
    private Document fDocument = null;
    private Node fRefactoring = null;
    private Node fSession = null;

    RefactoringSessionTransformer() {
    }

    public void beginRefactoring(String id, long stamp, String project, String description, String comment, int flags) throws CoreException {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)description);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        try {
            if (this.fDocument == null) {
                this.fDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
        }
        catch (ParserConfigurationException exception) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
        }
        catch (FactoryConfigurationError exception) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
        }
        if (this.fRefactoring == null) {
            try {
                this.fRefactoring = this.fDocument.createElement("refactoring");
                NamedNodeMap attributes = this.fRefactoring.getAttributes();
                Attr attribute = this.fDocument.createAttribute("id");
                attribute.setValue(id);
                attributes.setNamedItem(attribute);
                if (stamp >= 0L) {
                    attribute = this.fDocument.createAttribute("stamp");
                    attribute.setValue(new Long(stamp).toString());
                    attributes.setNamedItem(attribute);
                }
                if (flags != 0) {
                    attribute = this.fDocument.createAttribute("flags");
                    attribute.setValue(String.valueOf(flags));
                    attributes.setNamedItem(attribute);
                }
                attribute = this.fDocument.createAttribute("description");
                attribute.setValue(description);
                attributes.setNamedItem(attribute);
                if (comment != null) {
                    attribute = this.fDocument.createAttribute("comment");
                    attribute.setValue(comment);
                    attributes.setNamedItem(attribute);
                }
                if (project != null) {
                    attribute = this.fDocument.createAttribute("project");
                    attribute.setValue(project);
                    attributes.setNamedItem(attribute);
                }
                if (this.fSession == null) {
                    this.fDocument.appendChild(this.fRefactoring);
                } else {
                    this.fSession.appendChild(this.fRefactoring);
                }
            }
            catch (DOMException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, exception.getLocalizedMessage(), null));
            }
        }
    }

    public void beginSession(String comment) throws CoreException {
        if (this.fDocument == null) {
            try {
                this.fDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                this.fSession = this.fDocument.createElement("session");
                Attr attribute = this.fDocument.createAttribute("version");
                attribute.setValue("1.0");
                this.fSession.getAttributes().setNamedItem(attribute);
                if (comment != null) {
                    attribute = this.fDocument.createAttribute("comment");
                    attribute.setValue(comment);
                    this.fSession.getAttributes().setNamedItem(attribute);
                }
                this.fDocument.appendChild(this.fSession);
            }
            catch (DOMException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, exception.getLocalizedMessage(), null));
            }
            catch (ParserConfigurationException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
            }
        }
    }

    public void createArgument(String name, String value) throws CoreException {
        Assert.isNotNull((Object)name);
        Assert.isTrue((!"".equals(name) ? 1 : 0) != 0);
        Assert.isNotNull((Object)value);
        Assert.isTrue((!"".equals(value) ? 1 : 0) != 0);
        if (this.fDocument != null && this.fRefactoring != null && value != null) {
            try {
                Attr attribute = this.fDocument.createAttribute(name);
                attribute.setValue(value);
                this.fRefactoring.getAttributes().setNamedItem(attribute);
            }
            catch (DOMException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, exception.getLocalizedMessage(), null));
            }
        }
    }

    public void endRefactoring() {
        this.fRefactoring = null;
    }

    public void endSession() {
        this.fSession = null;
    }

    public Object getResult() {
        Document document = this.fDocument;
        this.fDocument = null;
        return document;
    }
}

