/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.help.ui.internal.views.SorterByScore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DynamicHelpPart
extends SectionPart
implements IHelpPart {
    private static final String CANCEL_HREF = "__cancel__";
    private static final String MORE_HREF = "__more__";
    private ReusableHelpPart parent;
    private FormText searchResults;
    private SorterByScore resultSorter;
    private String id;
    private String phrase;
    private Job runningJob;
    private IContext context;
    private JobListener jobListener;
    public static final int SHORT_COUNT = 8;

    public DynamicHelpPart(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, 322);
        Section section = this.getSection();
        section.setText(Messages.SearchPart_title);
        section.marginWidth = 5;
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    DynamicHelpPart.this.refilter();
                }
            }
        });
        this.resultSorter = new SorterByScore();
        this.searchResults = toolkit.createFormText((Composite)section, false);
        section.setClient((Control)this.searchResults);
        this.searchResults.setColor("org.eclipse.ui.forms.TITLE", toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        String topicKey = "obj16/topic_small.gif";
        String nwKey = "elcl16/openseparate_co.gif";
        String searchKey = "etool16/helpsearch_co.gif";
        this.searchResults.setImage(topicKey, HelpUIResources.getImage(topicKey));
        this.searchResults.setImage(nwKey, HelpUIResources.getImage(nwKey));
        this.searchResults.setImage(searchKey, HelpUIResources.getImage(searchKey));
        this.searchResults.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                if (href.equals(DynamicHelpPart.CANCEL_HREF)) {
                    if (DynamicHelpPart.this.runningJob != null) {
                        DynamicHelpPart.this.runningJob.cancel();
                        DynamicHelpPart.this.runningJob = null;
                    }
                    DynamicHelpPart.this.clearResults();
                } else if (href.equals(DynamicHelpPart.MORE_HREF)) {
                    DynamicHelpPart.this.doMore();
                } else {
                    DynamicHelpPart.this.doOpenLink(e.getHref());
                }
            }

            public void linkEntered(HyperlinkEvent e) {
                DynamicHelpPart.this.parent.handleLinkEntered(e);
            }

            public void linkExited(HyperlinkEvent e) {
                DynamicHelpPart.this.parent.handleLinkExited(e);
            }
        });
        this.searchResults.setText("", false, false);
        this.jobListener = new JobListener();
        Platform.getJobManager().addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    public void dispose() {
        Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this.jobListener);
        this.stop();
        super.dispose();
    }

    public void setFocus() {
        if (this.searchResults != null) {
            this.searchResults.setFocus();
        }
    }

    public void stop() {
        if (this.runningJob != null) {
            this.runningJob.cancel();
            this.runningJob = null;
        }
    }

    public Control getControl() {
        return this.getSection();
    }

    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
        parent.hookFormText(this.searchResults);
    }

    public String getId() {
        return this.id;
    }

    public void setVisible(boolean visible) {
        this.getSection().setVisible(visible);
    }

    void clearResults() {
        if (this.runningJob != null) {
            this.runningJob.cancel();
            this.runningJob = null;
        }
        this.searchResults.setText("", false, false);
        this.getManagedForm().reflow(true);
    }

    public void startSearch(String newPhrase, IContext excludeContext) {
        if (this.phrase != null && this.phrase.equals(newPhrase)) {
            return;
        }
        this.phrase = newPhrase;
        this.context = excludeContext;
        if (this.getSection().isExpanded()) {
            this.startInPlaceSearch(this.phrase, excludeContext);
        }
    }

    private void startInPlaceSearch(final String phrase, final IContext excludeContext) {
        Job job = new Job(Messages.SearchPart_dynamicJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        Platform.getJobManager().join((Object)"org.eclipse.help.base.indexer", monitor);
                    }
                    catch (InterruptedException interruptedException) {}
                    DynamicHelpPart.this.performSearch(phrase, excludeContext, monitor);
                    return Status.OK_STATUS;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.OK_STATUS;
                }
            }
        };
        this.scheduleSearch(job);
    }

    private void performSearch(String phrase, IContext excludeContext, IProgressMonitor monitor) {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.setSearchWord(phrase);
        SearchResults localResults = new SearchResults(null, 16, Platform.getNL());
        BaseHelpSystem.getSearchManager().search((ISearchQuery)searchQuery, (ISearchHitCollector)localResults, monitor);
        SearchHit[] hits = localResults.getSearchHits();
        this.updateResults(phrase, excludeContext, new StringBuffer(), hits);
    }

    void scheduleSearch(Job job) {
        if (this.runningJob != null) {
            this.runningJob.cancel();
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<form>");
        buff.append("<p><span color=\"");
        buff.append("org.eclipse.ui.forms.TITLE");
        buff.append("\">");
        buff.append(Messages.SearchResultsPart_progress);
        buff.append("</span>");
        buff.append("<a href=\"");
        buff.append(CANCEL_HREF);
        buff.append("\">");
        buff.append(Messages.SearchResultsPart_cancel);
        buff.append("</a></p>");
        buff.append("</form>");
        this.searchResults.setText(buff.toString(), true, false);
        this.getManagedForm().reflow(true);
        this.runningJob = job;
        job.schedule();
    }

    private void updateResults(final String phrase, final IContext excludeContext, final StringBuffer buffer, final SearchHit[] hits) {
        if (this.getSection().isDisposed()) {
            return;
        }
        this.getSection().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DynamicHelpPart.this.doUpdateResults(phrase, excludeContext, buffer, hits);
            }
        });
    }

    private void doUpdateResults(String phrase, IContext excludeContext, StringBuffer buff, SearchHit[] hits) {
        if (this.runningJob != null) {
            this.runningJob.cancel();
        }
        this.phrase = phrase;
        buff.delete(0, buff.length());
        if (hits.length > 0) {
            buff.append("<form>");
            buff.append("<p><span color=\"");
            buff.append("org.eclipse.ui.forms.TITLE");
            buff.append("\">");
            buff.append(Messages.SearchResultsPart_label);
            buff.append("</span></p>");
            this.resultSorter.sort(null, hits);
            IHelpResource[] excludedTopics = excludeContext != null ? excludeContext.getRelatedTopics() : null;
            int i = 0;
            while (i < hits.length) {
                SearchHit hit = hits[i];
                if (!this.isExcluded(hit.getHref(), excludedTopics)) {
                    if (i == 8) break;
                    buff.append("<li indent=\"21\" style=\"image\" value=\"");
                    buff.append("obj16/topic_small.gif");
                    buff.append("\">");
                    buff.append("<a href=\"");
                    buff.append(hit.getHref());
                    buff.append("\"");
                    if (hit.getToc() != null && !Platform.getWS().equals("gtk")) {
                        buff.append(" alt=\"");
                        buff.append(this.parent.escapeSpecialChars(hit.getToc().getLabel()));
                        buff.append("\"");
                    }
                    buff.append(">");
                    buff.append(this.parent.escapeSpecialChars(hit.getLabel()));
                    buff.append("</a>");
                    buff.append("</li>");
                }
                ++i;
            }
            if (hits.length > 0) {
                buff.append("<p><img href=\"");
                buff.append("etool16/helpsearch_co.gif");
                buff.append("\"/>");
                buff.append(" <a href=\"");
                buff.append(MORE_HREF);
                buff.append("\">");
                buff.append(Messages.SearchResultsPart_moreResults);
                buff.append("</a></p>");
            }
            buff.append("</form>");
            if (!this.searchResults.isDisposed()) {
                this.searchResults.setText(buff.toString(), true, false);
            }
        } else if (!this.searchResults.isDisposed()) {
            this.searchResults.setText("", false, false);
        }
        if (!this.searchResults.isDisposed()) {
            this.getManagedForm().reflow(true);
        }
    }

    private boolean isExcluded(String href, IHelpResource[] excludedTopics) {
        if (excludedTopics == null) {
            return false;
        }
        int i = 0;
        while (i < excludedTopics.length) {
            if (href.startsWith(excludedTopics[i].getHref())) {
                return true;
            }
            if (this.parent.isFilteredByRoles() && !HelpBasePlugin.getActivitySupport().isEnabled(href)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void doMore() {
        this.parent.startSearch(this.phrase);
    }

    private void doOpenLink(Object href) {
        String url = (String)href;
        if (url.startsWith("nw:")) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(url.substring(3));
        } else {
            this.parent.showURL(url);
        }
    }

    public boolean fillContextMenu(IMenuManager manager) {
        return this.parent.fillFormContextMenu(this.searchResults, manager);
    }

    public boolean hasFocusControl(Control control) {
        return this.searchResults.equals(control);
    }

    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    public void toggleRoleFilter() {
        this.refilter();
    }

    public void refilter() {
        if (this.phrase != null && this.phrase.length() > 0) {
            this.startInPlaceSearch(this.phrase, this.context);
        }
    }

    public void saveState(IMemento memento) {
    }

    class JobListener
    implements IJobChangeListener {
        JobListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob() == DynamicHelpPart.this.runningJob) {
                DynamicHelpPart.this.runningJob = null;
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

