/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.IIndex;
import org.eclipse.help.internal.index.IIndexEntry;
import org.eclipse.help.internal.index.IIndexTopic;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class IndexData
extends ActivitiesData {
    private IIndex index;
    int entryIndex;
    Writer out;
    String indent;
    StringWriter funcOut;

    public IndexData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = HelpPlugin.getIndexManager().getIndex(Platform.getNL());
    }

    public void generateHrefs(Writer out) throws IOException {
        out.write(this.funcOut.toString());
    }

    public void generateIndex(Writer out, String indent) throws IOException {
        this.out = out;
        this.entryIndex = 0;
        this.indent = indent;
        this.funcOut = new StringWriter();
        Iterator iter = this.index.getEntries().values().iterator();
        while (iter.hasNext()) {
            IIndexEntry entry = (IIndexEntry)iter.next();
            this.generateIndexEntry(entry, 0, "");
        }
    }

    private void generateIndexEntry(IIndexEntry entry, int depth, String parent) throws IOException {
        List topics = entry.getTopics();
        int size = topics.size();
        String label = UrlUtil.htmlEncode(entry.getKeyword());
        if (size == 1) {
            IIndexTopic topic = (IIndexTopic)topics.get(0);
            String href = UrlUtil.getHelpURL(topic.getHref());
            this.funcOut.write("case " + this.entryIndex + ": openTopic(\"" + href + "\"); break;\n");
        } else if (size == 0) {
            this.funcOut.write("case " + this.entryIndex + ": alertEmpty(); break;\n");
        }
        this.out.write("<option value='" + UrlUtil.htmlEncode(String.valueOf(parent) + label) + "'>");
        int i = 0;
        while (i < depth) {
            this.out.write(this.indent);
            ++i;
        }
        this.out.write(String.valueOf(UrlUtil.htmlEncode(label)) + "</option>");
        ++this.entryIndex;
        Iterator iter = entry.getEntries().values().iterator();
        if (iter.hasNext()) {
            do {
                IIndexEntry childEntry = (IIndexEntry)iter.next();
                this.generateIndexEntry(childEntry, depth + 1, String.valueOf(parent) + label + ",");
            } while (iter.hasNext());
        }
    }

    public IIndexEntry getIndexEntry(String[] path) {
        Map entries = this.index.getEntries();
        IIndexEntry result = null;
        int i = 0;
        while (i < path.length) {
            result = (IIndexEntry)entries.get(path[i]);
            if (result == null) {
                return null;
            }
            entries = result.getEntries();
            ++i;
        }
        return result;
    }
}

