/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IResolvedMemberValuePair;
import org.eclipse.jdt.core.dom.ResolvedDefaultValuePair;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

class ResolvedMemberValuePair
implements IResolvedMemberValuePair {
    static final ResolvedMemberValuePair[] NoPair = new ResolvedMemberValuePair[0];
    private static final Object NoValue = new Object();
    private static final Object[] EmptyArray = new Object[0];
    private ElementValuePair internalPair;
    private Object value = null;
    private BindingResolver bindingResolver;

    static Object buildDOMValue(Object internalObject, BindingResolver resolver) {
        if (internalObject == null) {
            return null;
        }
        if (internalObject instanceof Constant) {
            Constant constant = (Constant)internalObject;
            switch (constant.typeID()) {
                case 5: {
                    return constant.booleanValue();
                }
                case 3: {
                    return new Byte(constant.byteValue());
                }
                case 2: {
                    return new Character(constant.charValue());
                }
                case 8: {
                    return new Double(constant.doubleValue());
                }
                case 9: {
                    return new Float(constant.floatValue());
                }
                case 10: {
                    return new Integer(constant.intValue());
                }
                case 7: {
                    return new Long(constant.longValue());
                }
                case 4: {
                    return new Short(constant.shortValue());
                }
                case 11: {
                    return constant.stringValue();
                }
            }
        } else {
            if (internalObject instanceof TypeBinding) {
                return resolver.getTypeBinding((TypeBinding)internalObject);
            }
            if (internalObject instanceof AnnotationBinding) {
                return resolver.getAnnotationInstance((AnnotationBinding)internalObject);
            }
            if (internalObject instanceof FieldBinding) {
                return resolver.getVariableBinding((FieldBinding)internalObject);
            }
            if (internalObject instanceof Object[]) {
                Object[] elements = (Object[])internalObject;
                int length = elements.length;
                Object[] values = length == 0 ? EmptyArray : new Object[length];
                int i = 0;
                while (i < length) {
                    values[i] = ResolvedMemberValuePair.buildDOMValue(elements[i], resolver);
                    ++i;
                }
                return values;
            }
        }
        throw new IllegalStateException(internalObject.toString());
    }

    ResolvedMemberValuePair(ElementValuePair pair, BindingResolver resolver) {
        this.internalPair = pair;
        this.bindingResolver = resolver;
    }

    public IMethodBinding getMethodBinding() {
        return this.bindingResolver.getMethodBinding(this.internalPair.getMethodBinding());
    }

    public String getName() {
        if (this.internalPair == null) {
            return null;
        }
        char[] membername = this.internalPair.getName();
        return membername == null ? null : new String(membername);
    }

    public Object getValue() {
        if (this.value == null) {
            this.init();
        }
        return this.value == NoValue ? null : this.value;
    }

    private void init() {
        this.value = ResolvedMemberValuePair.buildDOMValue(this.internalPair.getValue(), this.bindingResolver);
        if (this.value == null) {
            this.value = NoValue;
        }
    }

    char[] internalName() {
        return this.internalPair == null ? null : this.internalPair.getName();
    }

    public boolean isDefault() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append(this.getName());
        buffer.append(" = ");
        ResolvedDefaultValuePair.appendValue(this.getValue(), buffer);
    }
}

