/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources.internal.actions;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonActionProviderConfig;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.WizardActionGroup;
import org.eclipse.ui.navigator.resources.internal.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.resources.internal.plugin.WorkbenchNavigatorPlugin;

public class PortingActionProvider
extends CommonActionProvider {
    private static final String COMMON_NAVIGATOR_IMPORT_MENU = "common.import.menu";
    private static final String COMMON_NAVIGATOR_EXPORT_MENU = "common.export.menu";
    private ImportResourcesAction importAction;
    private ExportResourcesAction exportAction;
    private WizardActionGroup importWizardActionGroup;
    private WizardActionGroup exportWizardActionGroup;
    private boolean disposed = false;
    private boolean contribute = false;

    public void init(CommonActionProviderConfig aConfig) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            IWorkbenchWindow window = ((ICommonViewerWorkbenchSite)aConfig.getViewSite()).getWorkbenchWindow();
            this.importAction = new ImportResourcesAction(window);
            this.exportAction = new ExportResourcesAction(window);
            this.importWizardActionGroup = new WizardActionGroup(window, PlatformUI.getWorkbench().getImportWizardRegistry(), "import");
            this.exportWizardActionGroup = new WizardActionGroup(window, PlatformUI.getWorkbench().getExportWizardRegistry(), "export");
            this.contribute = true;
        }
    }

    public void dispose() {
        if (!this.contribute) {
            return;
        }
        this.importWizardActionGroup.dispose();
        this.exportWizardActionGroup.dispose();
        this.importAction = null;
        this.exportAction = null;
        this.disposed = true;
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        theActionBars.setGlobalActionHandler(ActionFactory.IMPORT.getId(), (IAction)this.importAction);
        theActionBars.setGlobalActionHandler(ActionFactory.EXPORT.getId(), (IAction)this.exportAction);
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute) {
            return;
        }
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        ISelection selection = this.getContext().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.addSimplePortingMenus(aMenu);
        } else if (((IStructuredSelection)selection).size() > 1) {
            this.addSimplePortingMenus(aMenu);
        } else {
            this.addImportMenu(aMenu);
            this.addExportMenu(aMenu);
        }
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        URL url = WorkbenchNavigatorPlugin.getDefault().find((IPath)new Path(String.valueOf(iconPath) + relativePath));
        if (url == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    private void addSimplePortingMenus(IMenuManager aMenu) {
        aMenu.appendToGroup("group.port", (IAction)this.importAction);
        aMenu.appendToGroup("group.port", (IAction)this.exportAction);
    }

    private void addImportMenu(IMenuManager aMenu) {
        this.importWizardActionGroup.setContext(this.getContext());
        if (this.importWizardActionGroup.getWizardActionIds().length == 0) {
            aMenu.appendToGroup("group.port", (IAction)this.importAction);
            return;
        }
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.ImportResourcesMenu_text, COMMON_NAVIGATOR_IMPORT_MENU);
        this.importWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.importAction);
        aMenu.appendToGroup("group.port", (IContributionItem)submenu);
    }

    private void addExportMenu(IMenuManager aMenu) {
        this.exportWizardActionGroup.setContext(this.getContext());
        if (this.importWizardActionGroup.getWizardActionIds().length == 0) {
            aMenu.appendToGroup("group.port", (IAction)this.exportAction);
            return;
        }
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.ExportResourcesMenu_text, COMMON_NAVIGATOR_EXPORT_MENU);
        this.exportWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.exportAction);
        aMenu.appendToGroup("group.port", (IContributionItem)submenu);
    }
}

