/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.JavacTask;
import org.eclipse.pde.internal.build.builder.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ClasspathComputer2_1;
import org.eclipse.pde.internal.build.builder.ClasspathComputer3_0;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.IClasspathComputer;
import org.eclipse.update.core.IPluginEntry;

public class ModelBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    private static final String SRC_ZIP = "src.zip";
    public static final String EXPANDED_DOT = "@dot";
    public static final String DOT = ".";
    protected BundleDescription model;
    private IPluginEntry associatedEntry;
    protected String fullName;
    protected String pluginZipDestination;
    protected String pluginUpdateJarDestination;
    private FeatureBuildScriptGenerator featureGenerator;
    protected final String PLUGIN_DESTINATION = Utils.getPropertyFormat("plugin.destination");
    private Properties permissionProperties;
    private String propertiesFileName = "build.properties";
    private String buildScriptFileName = "build.xml";
    private String customBuildCallbacks = null;
    private ArrayList compiledJarNames;
    private boolean dotOnTheClasspath = false;
    private boolean binaryPlugin = false;
    private boolean signJars = false;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        String custom;
        if (this.binaryPlugin) {
            return;
        }
        if (this.model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Messages.error_missingElement, null));
        }
        if (this.featureGenerator != null && !this.featureGenerator.isSourceFeatureGeneration() && this.featureGenerator.getBuildProperties().containsKey("generate.plugin@" + this.model.getSymbolicName())) {
            return;
        }
        if (!AbstractScriptGenerator.isBuildingOSGi()) {
            this.checkBootAndRuntime();
        }
        this.initializeVariables();
        if (BundleHelper.getDefault().isDebugging()) {
            System.out.println("Generating plugin " + this.model.getSymbolicName());
        }
        if ((custom = (String)this.getBuildProperties().get("custom")) != null && custom.equalsIgnoreCase("true")) {
            this.updateExistingScript();
            return;
        }
        this.openScript(this.getLocation(this.model), this.buildScriptFileName);
        try {
            this.generateBuildScript();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.closeScript();
    }

    private void checkBootAndRuntime() throws CoreException {
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.boot") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, NLS.bind((String)Messages.exception_missingPlugin, (Object)"org.eclipse.core.boot"), null);
            throw new CoreException((IStatus)status);
        }
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.runtime") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, NLS.bind((String)Messages.exception_missingPlugin, (Object)"org.eclipse.core.runtime"), null);
            throw new CoreException((IStatus)status);
        }
    }

    public static String getNormalizedName(BundleDescription bundle) {
        return String.valueOf(bundle.getSymbolicName()) + '_' + bundle.getVersion();
    }

    private void initializeVariables() throws CoreException {
        this.fullName = ModelBuildScriptGenerator.getNormalizedName(this.model);
        this.pluginZipDestination = String.valueOf(this.PLUGIN_DESTINATION) + '/' + this.fullName + ".zip";
        this.pluginUpdateJarDestination = String.valueOf(this.PLUGIN_DESTINATION) + '/' + this.fullName + ".jar";
        String[] classpathInfo = this.getClasspathEntries(this.model);
        this.dotOnTheClasspath = ModelBuildScriptGenerator.specialDotProcessing(this.getBuildProperties(), classpathInfo);
        Properties bundleProperties = (Properties)this.model.getUserObject();
        bundleProperties.put("withDot", (Object)this.dotOnTheClasspath);
        this.customBuildCallbacks = this.getBuildProperties().getProperty("customBuildCallbacks");
        if ("true".equalsIgnoreCase(this.customBuildCallbacks)) {
            this.customBuildCallbacks = "customBuildCallbacks.xml";
        } else if ("false".equalsIgnoreCase(this.customBuildCallbacks)) {
            this.customBuildCallbacks = null;
        }
    }

    protected static boolean findAndReplaceDot(String[] classpathInfo) {
        int i = 0;
        while (i < classpathInfo.length) {
            if (DOT.equals(classpathInfo[i])) {
                classpathInfo[i] = EXPANDED_DOT;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean specialDotProcessing(Properties properties, String[] classpathInfo) {
        if (ModelBuildScriptGenerator.findAndReplaceDot(classpathInfo) || classpathInfo.length > 0 && classpathInfo[0].equals(EXPANDED_DOT)) {
            String includeString;
            String extraEntries;
            String buildOrder;
            String excludedFromJar;
            String sourceFolder = properties.getProperty("source..");
            if (sourceFolder == null) {
                return false;
            }
            properties.setProperty("source.@dot", sourceFolder);
            properties.remove("source..");
            String outputValue = properties.getProperty("output..");
            if (outputValue != null) {
                properties.setProperty("output.@dot", outputValue);
                properties.remove("output..");
            }
            if ((excludedFromJar = properties.getProperty("exclude..")) != null) {
                properties.setProperty("exclude.@dot", excludedFromJar);
                properties.remove("exclude..");
            }
            if ((buildOrder = properties.getProperty("jars.compile.order")) != null) {
                String[] order = Utils.getArrayFromString(buildOrder);
                int i = 0;
                while (i < order.length) {
                    if (order[i].equals(DOT)) {
                        order[i] = EXPANDED_DOT;
                    }
                    ++i;
                }
                properties.setProperty("jars.compile.order", Utils.getStringFromArray(order, ","));
            }
            if ((extraEntries = properties.getProperty("extra..")) != null) {
                properties.setProperty("extra.@dot", extraEntries);
            }
            if ((includeString = properties.getProperty("bin.includes")) != null) {
                String[] includes = Utils.getArrayFromString(includeString);
                int i = 0;
                while (i < includes.length) {
                    if (includes[i].equals(DOT)) {
                        includes[i] = "@dot/";
                    }
                    ++i;
                }
                properties.setProperty("bin.includes", Utils.getStringFromArray(includes, ","));
            }
            return true;
        }
        return false;
    }

    private void generateBuildScript() throws CoreException {
        this.generatePrologue();
        this.generateBuildUpdateJarTarget();
        if (this.getBuildProperties().getProperty("sourcePlugin", null) == null) {
            this.generateBuildJarsTarget(this.model);
        } else {
            this.generateBuildJarsTargetForSourceGathering();
            this.generateEmptyBuildSourcesTarget();
        }
        this.generateGatherBinPartsTarget();
        this.generateBuildZipsTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateZipPluginTarget();
        this.generateEpilogue();
    }

    private void generateEmptyBuildSourcesTarget() {
        this.script.printTargetDeclaration("build.sources", null, null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTargetForSourceGathering() {
        this.script.printTargetDeclaration("build.jars", null, null, null, null);
        this.compiledJarNames = new ArrayList(0);
        Config configInfo = this.associatedEntry.getOS() == null && this.associatedEntry.getWS() == null && this.associatedEntry.getOSArch() == null ? Config.genericConfig() : new Config(this.associatedEntry.getOS(), this.associatedEntry.getWS(), this.associatedEntry.getOSArch());
        Set pluginsToGatherSourceFrom = (Set)this.featureGenerator.sourceToGather.getElementEntries().get(configInfo);
        if (pluginsToGatherSourceFrom != null) {
            Iterator iter = pluginsToGatherSourceFrom.iterator();
            while (iter.hasNext()) {
                BundleDescription plugin = (BundleDescription)iter.next();
                if (plugin.getSymbolicName().equals(this.model.getSymbolicName())) continue;
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(plugin)), (IPath)new Path(this.getLocation(this.model)));
                this.script.printAntTask("build.xml", location.toOSString(), "build.sources", null, null, null);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("destination.temp.folder", String.valueOf(Utils.getPropertyFormat("basedir")) + "/src");
                this.script.printAntTask("build.xml", location.toOSString(), "gather.sources", null, null, params);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        this.script.printTargetDeclaration("clean", "init", null, null, NLS.bind((String)Messages.build_plugin_clean, (Object)this.model.getSymbolicName()));
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(3);
            params.put("plugin.destination", this.PLUGIN_DESTINATION);
            params.put("temp.folder", Utils.getPropertyFormat("temp.folder"));
            params.put("build.result.folder", Utils.getPropertyFormat("build.result.folder"));
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.clean", DOT, "false", params, null);
        }
        int i = 0;
        while (i < availableJars.length) {
            String jarName = availableJars[i].getName(true);
            if (availableJars[i].type == 0) {
                this.script.printDeleteTask(null, this.getJARLocation(jarName), null);
            } else {
                this.script.printDeleteTask(this.getJARLocation(jarName), null, null);
            }
            this.script.printDeleteTask(null, this.getSRCLocation(jarName), null);
            ++i;
        }
        this.script.printDeleteTask(null, this.pluginUpdateJarDestination, null);
        this.script.printDeleteTask(null, this.pluginZipDestination, null);
        this.script.printDeleteTask(Utils.getPropertyFormat("temp.folder"), null, null);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.clean", DOT, "false", params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherLogTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(Utils.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("destination.temp.folder", baseDestination.toString());
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.gather.logs", DOT, "false", params, null);
        }
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        int i = 0;
        while (i < availableJars.length) {
            String name = availableJars[i].getName(true);
            IPath destination = baseDestination.append(name).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            this.script.printCopyTask(String.valueOf(this.getTempJARFolderLocation(name)) + ".log", destination.toString(), null, false, false);
            ++i;
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.gather.logs", DOT, "false", params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        Path root = new Path(Utils.getPropertyFormat("basedir"));
        this.script.printZipTask(root.append(zipName).toString(), root.append(source).toString(), false, false, null);
        this.script.printTargetEnd();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.sources", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(Utils.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("target.folder", baseDestination.toString());
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.gather.sources", DOT, "false", params, null);
        }
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        int i = 0;
        while (i < availableJars.length) {
            String jar = availableJars[i].getName(true);
            IPath destination = baseDestination.append(jar).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            this.script.printCopyTask(this.getSRCLocation(jar), destination.toString(), null, false, false);
            ++i;
        }
        String include = (String)this.getBuildProperties().get("src.includes");
        String exclude = (String)this.getBuildProperties().get("src.excludes");
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(Utils.getPropertyFormat("basedir"), null, include, null, exclude, null, null);
            this.script.printCopyTask(null, baseDestination.toString(), new FileSet[]{fileSet}, false, false);
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.gather.sources", DOT, "false", params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        FileSet fileSet;
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "destination.temp.folder", null, null);
        Path destination = new Path(Utils.getPropertyFormat("destination.temp.folder"));
        destination = destination.append(this.fullName);
        String root = destination.toString();
        this.script.printMkdirTask(root);
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(3);
            params.put("target.folder", root);
            params.put("build.result.folder", Utils.getPropertyFormat("build.result.folder"));
            params.put("basedir", Utils.getPropertyFormat("basedir"));
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.gather.bin.parts", DOT, "false", params, null);
        }
        ArrayList<Path> destinations = new ArrayList<Path>(5);
        destinations.add(destination);
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        String[] splitIncludes = Utils.getArrayFromString(include);
        String[] fileSetValues = new String[this.compiledJarNames.size()];
        int count = 0;
        boolean dotIncluded = false;
        int pos = Utils.isStringIn(splitIncludes, "@dot/");
        if (pos != -1) {
            splitIncludes[pos] = null;
            dotIncluded = true;
        }
        Iterator iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            CompiledEntry entry = (CompiledEntry)iter.next();
            String formatedName = String.valueOf(entry.getName(false)) + (entry.getType() == 1 ? "/" : "");
            if (this.dotOnTheClasspath && formatedName.startsWith(EXPANDED_DOT)) {
                dotIncluded &= true;
                continue;
            }
            fileSetValues[count++] = formatedName;
        }
        if (count != 0) {
            fileSet = new FileSet(Utils.getPropertyFormat("build.result.folder"), null, Utils.getStringFromArray(fileSetValues, ","), null, this.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true, false);
        }
        if (dotIncluded) {
            fileSet = new FileSet(String.valueOf(Utils.getPropertyFormat("build.result.folder")) + '/' + EXPANDED_DOT, null, "**", null, this.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true, false);
        }
        if (include != null || exclude != null) {
            fileSet = new FileSet(Utils.getPropertyFormat("basedir"), null, this.replaceVariables(Utils.getStringFromArray(splitIncludes, ","), true), null, this.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true, false);
        }
        this.generatePermissionProperties(root);
        this.genarateIdReplacementCall(destination.toString());
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.gather.bin.parts", DOT, "false", params, null);
        }
        this.script.printTargetEnd();
    }

    private void genarateIdReplacementCall(String location) {
        Properties bundleProperties = (Properties)this.model.getUserObject();
        if (bundleProperties == null) {
            return;
        }
        String qualifier = bundleProperties.getProperty("qualifier");
        if (qualifier == null) {
            return;
        }
        this.script.println("<eclipse.versionReplacer path=\"" + location + "\" version=\"" + this.model.getVersion() + "\"/>");
    }

    private void generatePermissionProperties(String directory) throws CoreException {
        this.getPermissionProperties();
        Iterator<Map.Entry<Object, Object>> iter = this.permissionProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> permission = iter.next();
            String instruction = (String)permission.getKey();
            String parameters = (String)permission.getValue();
            int index = instruction.indexOf("permissions");
            if (index != -1) {
                this.generateChmodInstruction(directory, instruction.substring(index + "permissions".length() + 1), parameters);
                continue;
            }
            if (!instruction.startsWith("link")) continue;
            this.generateLinkInstruction(directory, parameters);
        }
    }

    private void generateChmodInstruction(String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        this.script.printChmod(dir, rights, files);
    }

    private void generateLinkInstruction(String dir, String files) {
        String[] links = Utils.getArrayFromString(files, ",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        int i = 0;
        while (i < links.length) {
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            this.script.printExecTask("ln -s", dir, arguments, "Linux");
            arguments.clear();
            i += 2;
        }
    }

    protected Properties getPermissionProperties() throws CoreException {
        if (this.permissionProperties == null) {
            this.permissionProperties = ModelBuildScriptGenerator.readProperties(this.getLocation(this.model), "permissions.properties", 1);
        }
        return this.permissionProperties;
    }

    private void generateZipPluginTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.plugin", "init", null, null, NLS.bind((String)Messages.build_plugin_zipPlugin, (Object)this.model.getSymbolicName()));
        this.script.printDeleteTask(Utils.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(Utils.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        this.script.printAntCallTask("build.sources", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(Utils.getPropertyFormat("temp.folder")) + '/');
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printAntCallTask("gather.sources", null, params);
        FileSet fileSet = new FileSet(Utils.getPropertyFormat("temp.folder"), null, "**/*.bin.log", null, null, null, null);
        this.script.printDeleteTask(null, null, new FileSet[]{fileSet});
        this.script.printZipTask(this.pluginZipDestination, Utils.getPropertyFormat("temp.folder"), true, false, null);
        this.script.printDeleteTask(Utils.getPropertyFormat("temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, NLS.bind((String)Messages.build_plugin_buildUpdateJar, (Object)this.model.getSymbolicName()));
        this.script.printDeleteTask(Utils.getPropertyFormat("temp.folder"), null, null);
        this.script.printMkdirTask(Utils.getPropertyFormat("temp.folder"));
        this.script.printAntCallTask("build.jars", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(Utils.getPropertyFormat("temp.folder")) + '/');
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printZipTask(this.pluginUpdateJarDestination, String.valueOf(Utils.getPropertyFormat("temp.folder")) + '/' + this.fullName, false, false, null);
        this.script.printDeleteTask(Utils.getPropertyFormat("temp.folder"), null, null);
        if (this.signJars) {
            this.script.println("<signjar jar=\"" + this.pluginUpdateJarDestination + "\" alias=\"" + Utils.getPropertyFormat("sign.alias") + "\" keystore=\"" + Utils.getPropertyFormat("sign.keystore") + "\" storepass=\"" + Utils.getPropertyFormat("sign.storepass") + "\"/>");
        }
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Messages.build_plugin_refresh);
        this.script.printConvertPathTask(new Path(this.getLocation(this.model)).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(Utils.getPropertyFormat("resourcePath"), "infinite");
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.model.getSymbolicName(), "build.jars", DOT);
        this.script.println();
        this.script.printProperty("basews", Utils.getPropertyFormat("ws"));
        this.script.printProperty("baseos", Utils.getPropertyFormat("os"));
        this.script.printProperty("basearch", Utils.getPropertyFormat("arch"));
        this.script.printProperty("basenl", Utils.getPropertyFormat("nl"));
        this.script.println();
        if (this.customBuildCallbacks != null && !this.customBuildCallbacks.equals("false")) {
            this.script.printAvailableTask("customBuildCallbacks", this.customBuildCallbacks, this.customBuildCallbacks);
            this.script.println();
        }
        this.generateCompilerSettings();
        this.script.printTargetDeclaration("init", "properties", null, null, null);
        this.script.printConditionIsSet("pluginTemp", String.valueOf(Utils.getPropertyFormat("buildTempFolder")) + '/' + "plugins", "buildTempFolder");
        this.script.printProperty("pluginTemp", Utils.getPropertyFormat("basedir"));
        this.script.printConditionIsSet("build.result.folder", String.valueOf(Utils.getPropertyFormat("pluginTemp")) + '/' + new Path(this.model.getLocation()).lastSegment(), "buildTempFolder");
        this.script.printProperty("build.result.folder", Utils.getPropertyFormat("basedir"));
        this.script.printProperty("temp.folder", String.valueOf(Utils.getPropertyFormat("basedir")) + '/' + "temp.folder");
        this.script.printProperty("plugin.destination", Utils.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("properties", null, "eclipse.running", null, null);
        this.script.printProperty("build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        this.script.println();
        this.script.printTargetEnd();
    }

    private void generateCompilerSettings() {
        String javacSource = null;
        String javacTarget = null;
        String bootClasspath = null;
        String jreProfile = null;
        try {
            Properties properties = this.getBuildProperties();
            javacSource = properties.getProperty("javacSource");
            javacTarget = properties.getProperty("javacTarget");
            bootClasspath = properties.getProperty("bootClasspath");
            jreProfile = properties.getProperty("jre.compilation.profile");
        }
        catch (CoreException coreException) {}
        this.script.printComment(Messages.build_compilerSetting);
        this.script.printProperty("javacFailOnError", "false");
        this.script.printProperty("javacDebugInfo", "on");
        this.script.printProperty("javacVerbose", "true");
        this.script.printProperty("compilerArg", "");
        if (javacSource == null) {
            this.script.printProperty("javacSource", "1.3");
        }
        if (javacTarget == null) {
            this.script.printProperty("javacTarget", "1.2");
        }
        if (bootClasspath == null) {
            this.script.println("<path id=\"path_bootclasspath\">");
            this.script.println("\t<fileset dir=\"${java.home}/lib\">");
            this.script.println("\t\t<include name=\"*.jar\"/>");
            this.script.println("\t</fileset>");
            this.script.println("</path>");
            this.script.printPropertyRefid("bootclasspath", "path_bootclasspath");
        }
        Properties environmentMappings = ModelBuildScriptGenerator.getExecutionEnvironmentMappings();
        if (jreProfile != null && !environmentMappings.containsKey(String.valueOf(jreProfile) + '.' + "javacSource")) {
            if (this.reportResolutionErrors) {
                Status status = new Status(4, this.model.getSymbolicName(), 4, NLS.bind((String)Messages.build_plugin_unrecognizedJRE, (Object)jreProfile), null);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            jreProfile = null;
        }
        if (javacSource != null) {
            this.script.printProperty("bundleJavacSource", javacSource);
        }
        if (javacTarget != null) {
            this.script.printProperty("bundleJavacTarget", javacTarget);
        }
        if (bootClasspath != null) {
            this.script.printProperty("bundleBootClasspath", bootClasspath);
        }
        String target = null;
        String[] modelEnvironments = this.model.getExecutionEnvironments();
        String[] environments = null;
        if (jreProfile != null) {
            environments = new String[modelEnvironments.length + 1];
            environments[0] = jreProfile;
            System.arraycopy(modelEnvironments, 0, environments, 1, modelEnvironments.length);
        } else {
            environments = modelEnvironments;
        }
        int i = 0;
        while (i < environments.length) {
            if (bootClasspath == null) {
                this.script.printConditionIsSet("bundleBootClasspath", Utils.getPropertyFormat(environments[i]), environments[i]);
            }
            String source = (String)environmentMappings.get(String.valueOf(environments[i]) + '.' + "javacSource");
            target = (String)environmentMappings.get(String.valueOf(environments[i]) + '.' + "javacTarget");
            if (javacSource == null && source != null) {
                this.script.printConditionIsSet("bundleJavacSource", source, environments[i]);
            }
            if (javacTarget == null && target != null) {
                this.script.printConditionIsSet("bundleJavacTarget", target, environments[i]);
            }
            ++i;
        }
        if (javacSource == null) {
            this.script.printProperty("bundleJavacSource", Utils.getPropertyFormat("javacSource"));
        }
        if (javacTarget == null) {
            this.script.printProperty("bundleJavacTarget", Utils.getPropertyFormat("javacTarget"));
        }
        if (bootClasspath == null) {
            this.script.printProperty("bundleBootClasspath", Utils.getPropertyFormat("bootclasspath"));
        }
        this.script.println();
    }

    public void setModel(BundleDescription model) throws CoreException {
        if (model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Messages.error_missingElement, null));
        }
        this.model = model;
        if (this.getBuildProperties() == AbstractScriptGenerator.MissingProperties.getInstance()) {
            this.binaryPlugin = true;
        } else {
            this.getCompiledElements().add(model.getSymbolicName());
        }
        Properties bundleProperties = (Properties)model.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            model.setUserObject((Object)bundleProperties);
        }
        bundleProperties.put("isCompiler", this.binaryPlugin ? Boolean.FALSE : Boolean.TRUE);
    }

    public void setModelId(String modelId) throws CoreException {
        BundleDescription newModel = this.getModel(modelId);
        if (newModel == null) {
            String message = NLS.bind((String)Messages.exception_missingElement, (Object)modelId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, null));
        }
        this.setModel(newModel);
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    public void setFeatureGenerator(FeatureBuildScriptGenerator featureGenerator) {
        this.featureGenerator = featureGenerator;
    }

    private void generateBuildJarsTarget(BundleDescription pluginModel) throws CoreException {
        Properties properties = this.getBuildProperties();
        CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        this.compiledJarNames = new ArrayList(availableJars.length);
        HashMap<String, CompiledEntry> jars = new HashMap<String, CompiledEntry>(availableJars.length);
        int i = 0;
        while (i < availableJars.length) {
            jars.put(availableJars[i].getName(false), availableJars[i]);
            ++i;
        }
        String jarOrder = (String)this.getBuildProperties().get("jars.compile.order");
        IClasspathComputer classpath = AbstractScriptGenerator.isBuildingOSGi() ? new ClasspathComputer3_0(this) : new ClasspathComputer2_1(this);
        if (jarOrder != null) {
            String[] order = Utils.getArrayFromString(jarOrder);
            int i2 = 0;
            while (i2 < order.length) {
                CompiledEntry jar = (CompiledEntry)jars.get(order[i2]);
                if (jar != null) {
                    this.compiledJarNames.add(jar);
                    this.generateCompilationTarget(classpath.getClasspath(pluginModel, jar), jar);
                    this.generateSRCTarget(jar);
                    jars.remove(order[i2]);
                }
                ++i2;
            }
        }
        Iterator iterator = jars.values().iterator();
        while (iterator.hasNext()) {
            CompiledEntry jar = (CompiledEntry)iterator.next();
            this.compiledJarNames.add(jar);
            this.generateCompilationTarget(classpath.getClasspath(pluginModel, jar), jar);
            this.generateSRCTarget(jar);
        }
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, NLS.bind((String)Messages.build_plugin_buildJars, (Object)pluginModel.getSymbolicName()));
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("build.result.folder", Utils.getPropertyFormat("build.result.folder"));
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.build.jars", DOT, "false", params, null);
        }
        Iterator iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            String name = ((CompiledEntry)iter.next()).getName(false);
            this.script.printAvailableTask(name, this.replaceVariables(this.getJARLocation(name), true));
            this.script.printAntCallTask(name, null, null);
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.build.jars", DOT, "false", params, null);
        }
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre.build.sources", DOT, "false", params, null);
        }
        iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            String jarName = ((CompiledEntry)iter.next()).getName(false);
            String srcName = this.getSRCName(jarName);
            this.script.printAvailableTask(srcName, this.getSRCLocation(jarName));
            this.script.printAntCallTask(srcName, null, null);
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.build.sources", DOT, "false", params, null);
        }
        this.script.printTargetEnd();
    }

    /*
     * Exception decompiling
     */
    private void generateCompilerSettings(JavacTask javac, CompiledEntry entry, List classpath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 614->620)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateCompilationTarget(List classpath, CompiledEntry entry) {
        this.script.println();
        String name = entry.getName(false);
        this.script.printTargetDeclaration(name, "init", null, entry.getName(true), NLS.bind((String)Messages.build_plugin_jar, (Object)(String.valueOf(this.model.getSymbolicName()) + ' ' + name)));
        String destdir = this.getTempJARFolderLocation(entry.getName(true));
        this.script.printDeleteTask(destdir, null, null);
        this.script.printMkdirTask(destdir);
        this.script.printPathStructure("path", String.valueOf(name) + ".classpath", classpath);
        String[] sources = entry.getSource();
        HashMap<String, String> params = null;
        HashMap<String, Object> references = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(2);
            params.put("target.folder", destdir);
            int i = 1;
            while (i <= sources.length) {
                params.put("source.folder" + i, sources[i - 1]);
                ++i;
            }
            references = new HashMap<String, Object>(1);
            references.put(String.valueOf(name) + ".classpath", null);
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "pre." + name, DOT, "false", params, references);
        }
        this.script.printComment("compile the source code");
        JavacTask javac = new JavacTask();
        javac.setClasspathId(String.valueOf(name) + ".classpath");
        javac.setBootClasspath(Utils.getPropertyFormat("bundleBootClasspath"));
        javac.setDestdir(destdir);
        javac.setFailOnError(Utils.getPropertyFormat("javacFailOnError"));
        javac.setDebug(Utils.getPropertyFormat("javacDebugInfo"));
        javac.setVerbose(Utils.getPropertyFormat("javacVerbose"));
        javac.setIncludeAntRuntime("no");
        javac.setSource(Utils.getPropertyFormat("bundleJavacSource"));
        javac.setTarget(Utils.getPropertyFormat("bundleJavacTarget"));
        javac.setCompileArgs(Utils.getPropertyFormat("compilerArg"));
        javac.setSrcdir(sources);
        this.generateCompilerSettings(javac, entry, classpath);
        this.script.print(javac);
        this.script.printComment("Copy necessary resources");
        FileSet[] fileSets = new FileSet[sources.length];
        int i = 0;
        while (i < sources.length) {
            String excludes = "**/*.java, **/package.htm*";
            String excludedFromJar = entry.getExcludedFromJar();
            if (excludedFromJar != null) {
                excludes = String.valueOf(excludes) + ',' + excludedFromJar;
            }
            fileSets[i] = new FileSet(sources[i], null, null, null, excludes, null, null);
            ++i;
        }
        this.script.printCopyTask(null, destdir, fileSets, true, false);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post.compile." + name, DOT, "false", params, references);
        }
        String jarLocation = this.getJARLocation(entry.getName(true));
        this.script.printMkdirTask(new Path(jarLocation).removeLastSegments(1).toString());
        if (entry.getType() == 1) {
            FileSet[] binFolder = new FileSet[]{new FileSet(destdir, null, null, null, null, null, null)};
            this.script.printCopyTask(null, jarLocation, binFolder, true, false);
        } else {
            this.script.printJarTask(jarLocation, destdir, this.getEmbeddedManifestFile(entry, destdir));
        }
        this.script.printDeleteTask(destdir, null, null);
        if (this.customBuildCallbacks != null) {
            params.clear();
            params.put("jar.Location", jarLocation);
            this.script.printSubantTask(Utils.getPropertyFormat("customBuildCallbacks"), "post." + name, DOT, "false", params, references);
        }
        this.script.printTargetEnd();
    }

    private String getEmbeddedManifestFile(CompiledEntry jarEntry, String destdir) {
        try {
            String manifestName = this.getBuildProperties().getProperty("manifest." + jarEntry.getName(true));
            if (manifestName == null) {
                return null;
            }
            return String.valueOf(destdir) + '/' + manifestName;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected CompiledEntry[] extractEntriesToCompile(Properties properties) throws CoreException {
        ArrayList<CompiledEntry> result = new ArrayList<CompiledEntry>(5);
        int prefixLength = "source.".length();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.")) continue;
            key = key.substring(prefixLength);
            String[] source = Utils.getArrayFromString((String)entry.getValue());
            if (source.length == 0) {
                String message = NLS.bind((String)Messages.error_missingSourceFolder, (Object)this.model.getSymbolicName(), (Object)entry.getKey());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 16, message, null));
            }
            String[] output = Utils.getArrayFromString(properties.getProperty("output." + key));
            String[] extraClasspath = Utils.getArrayFromString(properties.getProperty("extra." + key));
            String excludedFromJar = properties.getProperty("exclude." + key);
            CompiledEntry newEntry = new CompiledEntry(key, source, output, extraClasspath, excludedFromJar, key.endsWith(".jar") ? (byte)0 : 1);
            result.add(newEntry);
        }
        return result.toArray(new CompiledEntry[result.size()]);
    }

    private void generateSRCTarget(CompiledEntry jar) {
        this.script.println();
        String name = jar.getName(false);
        String srcName = this.getSRCName(name);
        this.script.printTargetDeclaration(srcName, "init", null, srcName, null);
        String[] sources = jar.getSource();
        this.filterNonExistingSourceFolders(sources);
        FileSet[] fileSets = new FileSet[sources.length];
        int count = 0;
        int i = 0;
        while (i < sources.length) {
            if (sources[i] != null) {
                fileSets[count++] = new FileSet(sources[i], null, "**/*.java", null, null, null, null);
            }
            ++i;
        }
        String srcLocation = this.getSRCLocation(name);
        this.script.printMkdirTask(new Path(srcLocation).removeLastSegments(1).toString());
        if (count != 0) {
            this.script.printZipTask(srcLocation, null, false, false, fileSets);
        }
        this.script.printTargetEnd();
    }

    private void filterNonExistingSourceFolders(String[] sources) {
        File pluginRoot = new File(this.getLocation(this.model));
        int i = 0;
        while (i < sources.length) {
            File file = new File(pluginRoot, sources[i]);
            if (!file.exists()) {
                sources[i] = null;
                Status status = new Status(2, "org.eclipse.pde.build", 11, NLS.bind((String)Messages.warning_cannotLocateSource, (Object)file.getAbsolutePath()), null);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    protected String getSRCLocation(String jarName) {
        return this.getJARLocation(this.getSRCName(jarName));
    }

    protected String getTempJARFolderLocation(String jarName) {
        Path destination = new Path(Utils.getPropertyFormat("temp.folder"));
        destination = destination.append(String.valueOf(jarName) + ".bin");
        return destination.toString();
    }

    protected String getJARLocation(String jarName) {
        return new Path(Utils.getPropertyFormat("build.result.folder")).append(jarName).toString();
    }

    protected String[] getClasspathEntries(BundleDescription lookedUpModel) throws CoreException {
        return (String[])this.getSite(false).getRegistry().getExtraData().get(new Long(lookedUpModel.getBundleId()));
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = ModelBuildScriptGenerator.readProperties(this.model.getLocation(), this.propertiesFileName, this.isIgnoreMissingPropertiesFile() ? 0 : 2);
            return this.buildProperties;
        }
        return this.buildProperties;
    }

    protected String getSRCName(String jarName) {
        if (jarName.endsWith(".jar")) {
            return String.valueOf(jarName.substring(0, jarName.length() - 4)) + SRC_ZIP;
        }
        if (jarName.equals(EXPANDED_DOT)) {
            return SRC_ZIP;
        }
        return String.valueOf(jarName.replace('/', '.')) + SRC_ZIP;
    }

    private void updateExistingScript() throws CoreException {
        String root = this.getLocation(this.model);
        File buildFile = new File(root, this.buildScriptFileName);
        if (!buildFile.exists()) {
            String message = NLS.bind((String)Messages.error_missingCustomBuildFile, (Object)buildFile);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, null));
        }
        try {
            this.updateVersion(buildFile, "version.suffix", this.model.getVersion().toString());
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_writeScript, (Object)buildFile);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
        }
    }

    protected String replaceVariables(String sourceString, boolean compiledElement) {
        if (sourceString == null) {
            return null;
        }
        int i = -1;
        String result = sourceString;
        while ((i = result.indexOf("$ws$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "ws/" + Utils.getPropertyFormat(compiledElement ? "ws" : "basews") + result.substring(i + "$ws$".length());
        }
        while ((i = result.indexOf("$os$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "os/" + Utils.getPropertyFormat(compiledElement ? "os" : "baseos") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$arch$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "arch/" + Utils.getPropertyFormat(compiledElement ? "arch" : "basearch") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$nl$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "nl/" + Utils.getPropertyFormat(compiledElement ? "nl" : "basenl") + result.substring(i + "$nl$".length());
        }
        return result;
    }

    public BundleDescription getModel() {
        return this.model;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertyFileName) {
        this.propertiesFileName = propertyFileName;
    }

    public String getBuildScriptFileName() {
        return this.buildScriptFileName;
    }

    public void setBuildScriptFileName(String buildScriptFileName) {
        this.buildScriptFileName = buildScriptFileName;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    protected BundleDescription getModel(String modelId) throws CoreException {
        return this.getSite(false).getRegistry().getResolvedBundle(modelId);
    }

    public IPluginEntry getAssociatedEntry() {
        return this.associatedEntry;
    }

    public void setAssociatedEntry(IPluginEntry associatedEntry) {
        this.associatedEntry = associatedEntry;
    }

    protected class CompiledEntry {
        static final byte JAR = 0;
        static final byte FOLDER = 1;
        private String name;
        private String resolvedName;
        private String[] source;
        private String[] output;
        private String[] extraClasspath;
        private String excludedFromJar;
        byte type;

        protected CompiledEntry(String entryName, String[] entrySource, String[] entryOutput, String[] entryExtraClasspath, String excludedFromJar, byte entryType) {
            this.name = entryName;
            this.source = entrySource;
            this.output = entryOutput;
            this.extraClasspath = entryExtraClasspath;
            this.type = entryType;
            this.excludedFromJar = excludedFromJar;
        }

        protected String getName(boolean resolved) {
            if (!resolved) {
                return this.name;
            }
            if (this.resolvedName == null) {
                this.resolvedName = ModelBuildScriptGenerator.this.replaceVariables(this.name, true);
            }
            return this.resolvedName;
        }

        protected String[] getSource() {
            return this.source;
        }

        public String[] getOutput() {
            return this.output;
        }

        public String[] getExtraClasspath() {
            return this.extraClasspath;
        }

        public byte getType() {
            return this.type;
        }

        public String getExcludedFromJar() {
            return this.excludedFromJar;
        }
    }
}

